/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

#include "StdAfx.h"
#include "All.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

P3P_Match::P3P_Match(xmlChar* behavior, xmlNode* rule, xmlNode* policyNode, P3P_Policy* policy)
 : Behavior(behavior), _rule(rule), _policy(policy), _policyNode(policyNode)
{
}

P3P_Match::~P3P_Match()
{
	delete Behavior;
	xmlFreeNode(_policyNode);
}

P3P_Match* P3P_Match::Clone()
{
	xmlChar* newBehavior = CopyChar(Behavior);
	xmlNode* newPolicyNode = xmlCopyNode(_policyNode, 1);
	P3P_Match* newMatch = new P3P_Match(newBehavior, _rule, newPolicyNode, _policy);
	return newMatch;
}
