/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

#include "stdafx.h"
#include "All.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
//
//	P3P_Preference
//
//

P3P_Preference::P3P_Preference()
 : _prepared(FALSE)
{
	_fileName = new char[BUF_LEN];
	strcpy(_fileName, P3P_Common::DirName());
	strcat(_fileName, P3Ps_PREFFILE);
	_xmlDoc = xmlParseFile(_fileName);
}

P3P_Preference::~P3P_Preference()
{
	xmlFreeDoc(_xmlDoc);
	delete _fileName;
}

P3P_Match* P3P_Preference::MakeMatch(P3P_Policy* policy)
{
	//searching rule
	xmlNode* rule = SearchRule();

	//matching a rule and a policy	
	while(rule)
	{
		P3P_Match* match = RuleMatch(policy, rule);
		if(match)
		{
			return match;
		}
		rule = rule->next;
	}
	return NULL;
}

P3P_Match* P3P_Preference::RuleMatch(P3P_Policy* policy, xmlNode* rule)
{
	//extract the rule's attribute
	xmlChar* behavior = xmlGetProp(rule, P3Ps_BEHAVIOR);


	//@@ <REQUEST> element must be treated

	//matching
	xmlNode* child = rule->childs;
	if(! child || child->next)
	{
		//<RULE> must contain only one child element
		delete behavior;
		return NULL;
	}

	//set the root element of policy
	xmlDoc* xdoc = policy->XMLDoc();
	if(! xdoc) return NULL;
	xmlNode* polRoot = xmlCopyNode(xdoc->root, 1);

	//matching
	if(ExpressionMatch(polRoot, child))
	{
		P3P_Match* match = new P3P_Match(behavior, rule, polRoot, policy);
		return match;
	}
	else
	{
		xmlFreeNode(polRoot);
		delete behavior;
		return NULL;
	}
}

BOOL P3P_Preference::ExpressionMatch(xmlNode* policy, xmlNode* exp)
{
	//check if `exp` itself matches
	BOOL result = SimpleMatch(policy, exp);
	if(!result)
	{
		return result;
	}

	//no child means success
	xmlNode* eChild = exp->childs;
	if(! eChild)
	{
		//This node is leaf.
		xmlSetProp(policy, P3Ps_MATCHED, P3Ps_TRUE);
		xmlSetProp(policy, P3Ps_MATCHED_LEAF, P3Ps_TRUE);
		return TRUE;
	}

	//recognize quant attribute
	xmlChar* quant = xmlGetProp(exp, P3Ps_QUANT);
	if(!quant)
	{
		quant = CopyChar(P3Ps_QUANT_ALL);
	}
	BOOL anded = ( IsEqual(quant, P3Ps_QUANT_EXACT) || IsEqual(quant, P3Ps_QUANT_ALL));
	BOOL ignore = ( IsEqual(quant, P3Ps_QUANT_ANY) || IsEqual(quant, P3Ps_QUANT_ALL));
	delete quant;

	//check if childs match
	BOOL success = anded;
	while(eChild)
	{
		BOOL result = FALSE;
		xmlNode* pChild = policy->childs;
		while(pChild)
		{
			BOOL res = ExpressionMatch(pChild, eChild);
			if(res)
			{
				xmlSetProp(pChild, P3Ps_MATCHED, P3Ps_TRUE);
				result = TRUE;
			}
			pChild = pChild->next;
		}

		//if ANDed only one FALSE result make others fail
		if(anded && !result)
		{
			return FALSE;
		}
		//if ORed only one TRUE result make others success
		else if(!success && !anded && result)
		{
			success = TRUE;
		}
		eChild = eChild->next;
	}

	xmlNode* pChild = policy->childs;
	while(pChild)
	{
		xmlChar* matched = xmlGetProp(pChild, P3Ps_MATCHED);
		if(!matched || ! IsEqual(matched, P3Ps_TRUE))
		{
			xmlSetProp(pChild, P3Ps_MATCHED, P3Ps_FALSE);
			if(! ignore)
			{
				success = FALSE;
			}
		}
		delete matched;
		pChild = pChild->next;
	}

	return success;
}

BOOL P3P_Preference::SimpleMatch(xmlNode* policy, xmlNode* exp)
{
	if(! IsEqual(exp->name, policy->name))
	{
		return FALSE;
	}
	else
	{
		xmlAttr* eAttr = exp->properties;
		xmlAttr* pAttr = policy->properties;
		while(eAttr)
		{
			if((!eAttr->ns) || IsEqual(eAttr->ns->href, P3Ps_P3P))
			{
				if(! AttrMatch(eAttr, pAttr))
				{
					return FALSE;
				}
			}
			eAttr = eAttr->next;
		}
	}
	return TRUE;
}

BOOL P3P_Preference::AttrMatch(xmlAttr* eAttr, xmlAttr* pAttr)
{
	const xmlChar* name = eAttr->name;
	char orgvalue[BUF_LEN];
	char* value = orgvalue;
	strcpy(value, (const char*)eAttr->val->content);

	xmlAttr* p = pAttr;
	while(p)
	{
		if(IsEqual(p->name, name))
		{
			//@@general purpose regular expression routine should be used
			char* tok;
			char* star;
			const char* atvalue = (const char*)p->val->content;
			int atlen = strlen(atvalue);

			//divide "aaa|bbb|ccc" into {"aaa", "bbb", "ccc"}
			do
			{
				tok = strchr(value, '|');
				if(tok) *tok = 0;

				//match "x*y" with value;
				star = strchr(value, '*');
				if(!star)
				{
					if(IsEqual(atvalue, value)) return TRUE;
				}
				else
				{
					BOOL res1 = (strncmp(atvalue, value, star - value) == 0);
					if(res1)
					{
						int len = strlen(star) - 1;
						BOOL res2 = (strncmp(star + 1, atvalue + atlen - len, len));
						if(len == 0) res2 = TRUE;
						if(res2) return TRUE;
					}
				}

				value = tok + 1;
			}
			while(tok);
		}
		p = p->next;
	}

	return FALSE;
}

xmlNode* P3P_Preference::SearchRule()
{
	//check if the namespace of the document is APPEL
	BOOL appelNS = FALSE;
	xmlNsPtr ns = _xmlDoc->root->nsDef;
	while(ns)
	{
		if(ns->prefix && IsEqual(ns->href, P3Ps_NS_APPEL))
		{
			appelNS = TRUE;
			break;
		}
		ns = ns->next;
	}

	//search for first "<APPEL:RULE>"
	xmlNode* node = _xmlDoc->root;
	while(node)
	{
		//check if node name is "RULE"
		if(IsEqual(node->name, P3Ps_RULE))
		{
			if(appelNS == TRUE || IsEqual(node->ns->href, P3Ps_NS_APPEL))
			{
				break;
			}
		}
		node = node->childs;
	}
	if(! node)
	{
		return NULL;
	}

	//check if all siblings of the <RULE> are <RULE>
	xmlNode* sible = node->next;
	while(sible)
	{
		//node name must be "RULE"
		if(! IsEqual(sible->name, P3Ps_RULE))
		{
			return NULL;
		}

		//check the namespace
		if(appelNS == FALSE && !IsEqual(sible->ns->href, P3Ps_NS_APPEL))
		{
			return NULL;
		}
		sible = sible->next;
	}

	return node;
}

void xmlClearNS(xmlNode* node)
{
	xmlNode* child = node->childs;
	while(child)
	{
		xmlClearNS(child);
		child = child->next;
	}
	node->ns = NULL;
}

void P3P_NsMatch(xmlNode* node, xmlNs* ns)
{
	xmlNode* child = node->childs;
	while(child)
	{
		P3P_NsMatch(child, ns);
		child = child->next;
	}
	xmlNs* myNs = node->ns;
	if(! myNs) return;

	xmlNs* eachNs = ns;
	while(eachNs)
	{
		if(IsEqual(eachNs->href, myNs->href) && ((eachNs->prefix == myNs->prefix) || IsEqual(eachNs->prefix, myNs->prefix)))
		{
			node->ns = eachNs;
			node->nsDef = NULL;
			return;
		}
		eachNs = eachNs->next;
	}
}

BOOL P3P_AddQuant(xmlNode* node, xmlNs* ns)
{
	xmlNode* child = node->childs;
	if(! child) return TRUE;

	xmlAttr* attr = xmlSetProp(node, P3Ps_QUANT, P3Ps_QUANT_EXACT);
	attr->ns = ns;
	while(child)
	{
		P3P_AddQuant(child, ns);
		child = child->next;
	}
	return TRUE;
}

BOOL P3P_Preference::InsertNewRule(const xmlChar* behavior, xmlNode* policy)
{
	xmlNode* rule = SearchRule();
	xmlNs* ns = rule->ns;
	xmlNode* newRule = xmlNewNode(ns, P3Ps_RULE);
	xmlSetProp(newRule, P3Ps_BEHAVIOR, behavior);
	xmlAddNextSibling(rule, newRule);

	xmlNode* newPolicy = xmlCopyNode(policy, 1);

	P3P_NsMatch(newPolicy, ns);
	P3P_AddQuant(newPolicy, ns);

	xmlAddChild(newRule, newPolicy);
	xmlSaveFile(_fileName, _xmlDoc);

	return TRUE;
}

//
//
//	P3P_PrefManager
//
//

P3P_Preference* P3P_PrefManager::_pref = NULL;

P3P_Preference* P3P_PrefManager::GetPreference()
{
	if(! _pref)
	{
		_pref = new P3P_Preference;
	}
	return _pref;
}

void P3P_PrefManager::UnInitialize()
{
	delete _pref;
}
