/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

// P3P_PolicyView.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "All.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// P3P_PolicyView _CAO


P3P_PolicyView::P3P_PolicyView(CWnd* pParent /*=NULL*/)
	: P3P_Dialog(P3P_PolicyView::IDD, pParent)
{
	_firstSelect = NULL;

	//{{AFX_DATA_INIT(P3P_PolicyView)
	_matching = _T("");
	_policyURI = _T("");
	_matchingResult = _T("");
	_mr = -1;
	//}}AFX_DATA_INIT
}


void P3P_PolicyView::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(P3P_PolicyView)
	DDX_Control(pDX, IDC_ATTRIBUTE, _attrList);
	DDX_Control(pDX, IDC_MODIFY, _modifyButton);
	DDX_Control(pDX, IDC_TREE, _tree);
	DDX_Text(pDX, IDC_URI, _policyURI);
	DDX_Text(pDX, IDC_MATCHRESULT, _matchingResult);
	DDX_Radio(pDX, IDC_M_ACCEPT, _mr);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(P3P_PolicyView, CDialog)
	//{{AFX_MSG_MAP(P3P_PolicyView)
	ON_NOTIFY(TVN_ITEMEXPANDED, IDC_TREE, OnItemexpandedTree)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_M_ACCEPT, OnMAccept)
	ON_BN_CLICKED(IDC_MODIFY, OnModify)
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE, OnSelchangedTree)
	ON_BN_CLICKED(IDC_M_INFORM, OnMAccept)
	ON_BN_CLICKED(IDC_M_REJECT, OnMAccept)
	ON_BN_CLICKED(IDC_M_WARN, OnMAccept)
	ON_BN_CLICKED(IDC_XML, OnXml)
	ON_BN_CLICKED(IDC_NATURAL, OnNatural)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// P3P_PolicyView bZ[W nh

BOOL P3P_PolicyView::OnInitDialog() 
{
	CDialog::OnInitDialog();

	CreateImageLis();
//	CreateBitmapButtons();
	SetPolicyURI();
	SetAttributeList();
	Initialize();
	return TRUE;
}

void P3P_PolicyView::SetAttributeList()
{
	_attrList.InsertColumn(0, P3Ps_NAME, LVCFMT_LEFT, 50, -1);
	_attrList.InsertColumn(1, P3Ps_VALUE, LVCFMT_LEFT, 163, 1);
}

BOOL P3P_PolicyView::Initialize()
{
	_tree.DeleteAllItems();
	DisplayPolicy(_match->GetPolicyNode());
	ExpandPolicy(_tree.GetRootItem());
	_tree.SelectItem(_firstSelect);
//	SetRuleListView();
//	SetRuleList();

	//rule
	xmlChar* behavior = xmlGetProp(_match->GetRule(), P3Ps_BEHAVIOR);
	_matchingResult = (const char*)behavior;
	delete behavior;

	UpdateData(FALSE);

	return TRUE;
}

BOOL P3P_PolicyView::ExpandPolicy(HTREEITEM item)
{
	int image1, image2;
	_tree.GetItemImage(item, image1, image2);

	BOOL result = FALSE;
	if(! _tree.ItemHasChildren(item))
	{
		result = (image1 == _fileXIdx);
		if((_firstSelect == NULL) && result)
		{
			_firstSelect = item;
		}
	}
	else
	{
		HTREEITEM child = _tree.GetChildItem(item);
		while(child)
		{
			if(ExpandPolicy(child))
			{
				result = TRUE;
			}
			child = _tree.GetNextSiblingItem(child);
		}
		if(result)
		{
			_tree.Expand(item, TVE_EXPAND);
		}
	}

	return result;
}

void P3P_PolicyView::DisplayPolicy(xmlNode* node, HTREEITEM parent)
{
	//Prepare TreeView structures
	int mask1 = TVIF_TEXT | TVIF_IMAGE | TVIF_SELECTEDIMAGE | TVIF_PARAM;
	int mask2 = TVIF_TEXT | TVIF_IMAGE | TVIF_HANDLE | TVIF_SELECTEDIMAGE | TVIF_PARAM;

	TVINSERTSTRUCT insert;
	insert.hParent = parent;
	insert.hInsertAfter = TVI_LAST;
	insert.itemex.cChildren = 0;
	insert.itemex.cchTextMax = 100;
	insert.itemex.hItem = NULL;
	insert.itemex.iImage = 0;
	insert.itemex.iIntegral = 0;
	insert.itemex.iSelectedImage = 0;
	insert.itemex.lParam = 0;
	insert.itemex.pszText = NULL;
	insert.itemex.state = 0;
	insert.itemex.stateMask = 0;
	insert.itemex.mask = (parent == NULL) ? mask1 : mask2;	
	insert.itemex.lParam = (long)node;

	//text
	insert.itemex.pszText = (char*)node->name;

	//image
	xmlChar* matchStr = xmlGetProp(node, P3Ps_MATCHED);
	BOOL isMatch = matchStr && IsEqual(matchStr, P3Ps_TRUE);
	delete matchStr;
	matchStr = xmlGetProp(node, P3Ps_MATCHED_LEAF);
	BOOL isMatch2 = matchStr && IsEqual(matchStr, P3Ps_TRUE);
	delete matchStr;

	if(! node->childs)
		insert.itemex.iImage = isMatch ? _fileXIdx : _fileIdx;
	else
		insert.itemex.iImage = (isMatch && isMatch2) ? _closeXIdx : _closeIdx;
	insert.itemex.iSelectedImage = insert.itemex.iImage;

	//insert
	HTREEITEM item = _tree.InsertItem(&insert);

	//for child
	xmlNode* child = node->childs;
	while(child)
	{
		DisplayPolicy(child, item);
		child = child->next;
	}
}

void P3P_PolicyView::OnItemexpandedTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	int newImage;
	if(pNMTreeView->itemNew.iImage == _openIdx)
		newImage = _closeIdx;
	else if(pNMTreeView->itemNew.iImage == _openXIdx)
		newImage = _closeXIdx;
	else if(pNMTreeView->itemNew.iImage == _closeIdx)
		newImage = _openIdx;
	else if(pNMTreeView->itemNew.iImage == _closeXIdx)
		newImage = _openXIdx;

	HTREEITEM item = pNMTreeView->itemNew.hItem;
	_tree.SetItemImage(item, newImage, newImage);
}

P3P_PolicyView::~P3P_PolicyView()
{
}

void P3P_PolicyView::OnClose() 
{
	CDialog::OnClose();
	_driver->RemoveMe(this);
}

void P3P_PolicyView::CreateImageLis()
{
	//Create ImageList
	_closeBmp.LoadBitmap(IDB_F_CLOSED);
	_closeXBmp.LoadBitmap(IDB_F_CLOSED_X);
	_openBmp.LoadBitmap(IDB_F_OPEN);
	_openXBmp.LoadBitmap(IDB_F_OPEN_X);
	_fileBmp.LoadBitmap(IDB_F_FILE);
	_fileXBmp.LoadBitmap(IDB_F_FILE_X);
	_imageList.Create(P3P_IMAGE_X - 2, P3P_IMAGE_Y, ILC_COLOR24, 6, 10);
	_closeIdx = _imageList.Add(&_closeBmp, (CBitmap*)NULL);
	_closeXIdx = _imageList.Add(&_closeXBmp, (CBitmap*)NULL);
	_openIdx = _imageList.Add(&_openBmp, (CBitmap*)NULL);
	_openXIdx = _imageList.Add(&_openXBmp, (CBitmap*)NULL);
	_fileIdx = _imageList.Add(&_fileBmp, (CBitmap*)NULL);
	_fileXIdx = _imageList.Add(&_fileXBmp, (CBitmap*)NULL);

	_tree.SetImageList(&_imageList, TVSIL_NORMAL);
}

/*
void P3P_PolicyView::CreateBitmapButtons()
{
	//Prepare for bitmap buttons
	_applyBmp.LoadBitmap(IDB_R_APPLY);
	_deleteBmp.LoadBitmap(IDB_R_DELETE);
	_newBmp.LoadBitmap(IDB_R_NEW);
	_applyButton.SendMessage(BM_SETIMAGE, IMAGE_BITMAP, (long)(HANDLE)(HBITMAP)_applyBmp);
	_deleteButton.SendMessage(BM_SETIMAGE, IMAGE_BITMAP, (long)(HANDLE)(HBITMAP)_deleteBmp);
	_newButton.SendMessage(BM_SETIMAGE, IMAGE_BITMAP, (long)(HANDLE)(HBITMAP)_newBmp);
}
*/

void P3P_PolicyView::SetPolicyURI()
{
	_policyURI = _match->GetPolicy()->GetPolicyURI();
}

/*
void P3P_PolicyView::SetRuleList()
{
	//rule
	xmlChar* behavior = xmlGetProp(_match->GetRule(), P3Ps_BEHAVIOR);
	_behavior.SelectString(-1, (const char*)behavior);
	delete behavior;

	//rule list
	P3P_Preference* pref = P3P_PrefManager::GetPreference();
	xmlNode* rules = pref->SearchRule();
	int count = 0;

	LVITEM item;
	item.mask = LVIF_TEXT;
	item.iItem = 0;

	while(rules)
	{
		BOOL current = (rules == _match->GetRule());
		char* desc = (char*)xmlGetProp(rules, P3Ps_DESCRIPTION);
		if(!desc)
		{
			desc = CopyChar(P3Ps_A_RULE);
		}
		char* beha = (char*)xmlGetProp(rules, P3Ps_BEHAVIOR);

		item.pszText = current ? CopyChar(P3Ps_SELECTED) : CopyChar(P3Ps_SPACE);
		item.iSubItem = 0;
		_ruleList.SetItem(&item);
		_ruleList.InsertItem(&item);

		item.iSubItem = 1;
		item.pszText = beha;
		_ruleList.SetItem(&item);

		item.iSubItem = 2;
		item.pszText = desc;
		_ruleList.SetItem(&item);
		item.iItem++;

		rules = rules->next;
	}
}

void P3P_PolicyView::SetRuleListView()
{
	_ruleList.InsertColumn(0, P3Pss_EMPTY, LVCFMT_CENTER, 10, -1);
	_ruleList.InsertColumn(1, (const char*)P3Ps_BEHAVIOR, LVCFMT_LEFT, 55, 1);
	_ruleList.InsertColumn(2, (const char*)P3Ps_DESCRIPTION, LVCFMT_LEFT, 115, 2);
}
*/
void P3P_PolicyView::OnMAccept() 
{
	_modifyButton.EnableWindow(TRUE);	
}

void P3P_PolicyView::OnModify() 
{
	UpdateData(TRUE);
	const xmlChar* result;
	result = (_mr <= 1) ? ((_mr == 0) ? P3Ps_B_ACCEPT : P3Ps_B_INFORM) : ((_mr == 2) ? P3Ps_B_WARN : P3Ps_B_REJECT);

	P3P_Preference* pref = P3P_PrefManager::GetPreference();
	pref->InsertNewRule(result, _match->GetPolicy()->XMLDoc()->root);
	P3P_Match* match = pref->MakeMatch(_match->GetPolicy());
	if(match)
	{
		delete _match;
		_match = match;
	}
	Initialize();
}

void P3P_PolicyView::OnSelchangedTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	xmlNode* node = (xmlNode*)pNMTreeView->itemNew.lParam;
	if(!node) return;

	_attrList.DeleteAllItems();

	LVITEM item;
	item.mask = LVIF_TEXT;
	item.iItem = 0;

	xmlAttr* attr = node->properties;
	while(attr)
	{
		const xmlChar* name = attr->name;
		if((! IsEqual(name, P3Ps_MATCHED)) && !(IsEqual(name, P3Ps_MATCHED_LEAF)))
		{
			const xmlChar* value = attr->val->content;
			item.pszText = (char*)name;
			item.iSubItem = 0;
			_attrList.SetItem(&item);
			_attrList.InsertItem(&item);	

			item.iSubItem = 1;
			item.pszText = (char*)value;
			_attrList.SetItem(&item);

			item.iItem++;
		}
		attr = attr->next;
	}

	*pResult = 0;
}

void P3P_PolicyView::OnXml() 
{
	ExecuteURI(_policyURI);
}

void P3P_PolicyView::OnNatural() 
{
	xmlNode* child = _match->GetPolicyNode()->childs;
	while(child)
	{
		if(IsEqual(P3Ps_DISCLOSURE, child->name))
		{
			xmlChar* uri = xmlGetProp(child, P3Ps_DISCURI);
			if(uri)
			{
				ExecuteURI((const char*)uri);
				delete uri;
				return;
			}
			break;
		}
	}

	AfxMessageBox("There is no natural language expression of the policy");
}

void P3P_PolicyView::ExecuteURI(const char* uri)
{
	char buf[BUF_LEN];
	char cmcm[BUF_LEN];
	strcpy(buf, P3P_Common::DirName());
	strcat(buf, "p3p.html");
	FindExecutable(buf, "c:/", cmcm);
	strcat(cmcm, " ");
	strcat(cmcm, uri);
	PROCESS_INFORMATION pi;
	STARTUPINFO si;
	memset(&si, 0, sizeof(si));
	si.cb = sizeof(si);
	BOOL re;
	re = CreateProcess(NULL, cmcm, NULL, NULL, FALSE, DETACHED_PROCESS, NULL, NULL, &si, &pi);
}
