#ifndef _P3P_Policy_H_
#define _P3P_Policy_H_

//
//
//	Policy Related Classes
//
//

BOOL IsEqual(const char* s1, const char* s2);
BOOL IsEqual(const xmlChar* s1, const char* s2);
BOOL IsEqual(const char* s1, const xmlChar* s2);
BOOL IsEqual(const xmlChar* s1, const xmlChar* s2);

//
//	P3P_Policy
//
class P3P_Policy
{
public:
	P3P_Policy(const char* polURI);
	~P3P_Policy();

	const char* GetPolicyURI(){return _policyURI;}
	void SetBody(char* body){_body = body;}
	void ClearInfo();
	BOOL SetApplyURI(const char* uri);
	BOOL AddPrefix(const char* prefix);
	BOOL AddExclude(const char* exclude);
	BOOL SetLifeTime(time_t lifetime);

	CStringList* GetPrefix(){return &_prefix;}
	CStringList* GetExclude(){return &_exclude;}
	time_t GetLifeTime(){return _lifetime;}
	const char* GetApplyURI(){return _apply;}

	BOOL IsValid(time_t time);
	BOOL IsCovering(const char* uri);
	BOOL AsNaturalLang(char* buf, long length);

	xmlDoc* XMLDoc();

protected:
	CString _policyURI;
	CString _apply;
	CStringList _prefix;
	CStringList _exclude;
	time_t _lifetime;
	char* _body;	
	xmlDoc* _xmlDoc;
};
#define P3P_PolicyList CTypedPtrList<CPtrList, P3P_Policy*>

//
//	P3P_PolicyInfo
//
class P3P_PolicyInfo
{
public:
	P3P_PolicyInfo();
	BOOL SetNamespace(char* opt);
	void EatHeaderLine(char* buf);
	void EatMetaTag(char* buf);

	char _ns[LINE_LEN+1];
	char _lifetime[LINE_LEN+1];
	char _policy[LINE_LEN+1];
	char _prefix[LINE_LEN+1];
	char _exclude[LINE_LEN+1];
};

//
//	P3P_PolicyManager
//
class P3P_PolicyManager
{
public:
	P3P_PolicyManager(){};
	~P3P_PolicyManager();

	static P3P_PolicyManager* GetInstance();

	P3P_Policy* GetPolicyFromHeader(const char* uri, char* header);
	P3P_Policy* GetPolicyFromHTML(const char* uri, char* contents);
	P3P_Policy* GetCoveringPolicyFromCache(const char* uri);
	BOOL FetchPolicy(P3P_Policy* policy);

	BOOL IsVoid(const char* uri);
	BOOL AddAsVoid(const char* uri);

	BOOL InitializeDiskCache();
	char* ReadFromDiskCache(const char* uri);
	BOOL WriteToDiskCache(const char* uri, const char* body);

protected:
	static P3P_PolicyManager _instance;
	P3P_Policy* LookUp(const char* uri, BOOL fetch);
	P3P_Policy* CreatePolicy(const char* uri);
	P3P_Policy* SetPolicyInfo(P3P_PolicyInfo* pinfo, int count, const char* uri, BOOL isHeader);

	P3P_PolicyList _policyList;
	CStringList _voidList;

	CString _cacheDir;
	CString _cacheFile;
};

//
//	P3P_Common
//
class P3P_Common
{
public:
	static BOOL Write(const char* section, const char* key, const char* value);
	static char* Read(const char* section, const char* key, const char* defaultValue);
	static const char* DirName();
	static char* EncodeURI(const char* uri);
	static CString PrintNode(xmlNode* node);
	static CString AbsoluteURI(const char* uri, const char* relative);

protected:
	static CString _dirName;
	static char* FileName();
};

#endif
