/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

// P3P_DialogStatus.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "All.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// P3P_DialogStatus _CAO


P3P_DialogStatus::P3P_DialogStatus(CWnd* pParent /*=NULL*/)
	: P3P_Dialog(P3P_DialogStatus::IDD, pParent)
{
	//{{AFX_DATA_INIT(P3P_DialogStatus)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void P3P_DialogStatus::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(P3P_DialogStatus)
	DDX_Control(pDX, IDC_CHECKLINK, _checkButton);
	DDX_Control(pDX, IDC_STATUS_BITMAP, _statusBitmap);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(P3P_DialogStatus, CDialog)
	//{{AFX_MSG_MAP(P3P_DialogStatus)
	ON_BN_CLICKED(IDC_CHECKLINK, OnChecklink)
	ON_BN_CLICKED(IDC_ViewPolicy, OnViewPolicy)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// P3P_DialogStatus bZ[W nh

void P3P_DialogStatus::OnChecklink() 
{
	CString str;
	_checkButton.GetWindowText(str);

	if(str == P3Ps_CK_CHECK)
	{
		_driver->CheckLink(TRUE);
		_checkButton.SetWindowText(P3Ps_CK_UNCHECK);
	}
	else
	{
		_driver->CheckLink(FALSE);
		_checkButton.SetWindowText(P3Ps_CK_CHECK);
	}
}

void P3P_DialogStatus::OnViewPolicy() 
{
	ViewPolicy();	
}

void P3P_DialogStatus::OnClose() 
{
	CDialog::OnClose();
	_driver->RemoveMe(this);
}

BOOL P3P_DialogStatus::OnInitDialog() 
{
	CDialog::OnInitDialog();

	_accept.LoadBitmap(IDB_S_ACCEPT);
	_reject.LoadBitmap(IDB_S_REJECT);
	_unknown.LoadBitmap(IDB_S_UNKNOWN);
	_warn.LoadBitmap(IDB_S_WARN);
	_inform.LoadBitmap(IDB_S_INFORM);

	if(_match)
	{
		ShowPageStatus(_match);
	}

	return TRUE;
}

void P3P_DialogStatus::ShowPageStatus(P3P_Match* match)
{
	_checkButton.SetWindowText(P3Ps_CK_CHECK);

	if(match != _match)
	{
		delete _match;
		_match = match;
	}

	HBITMAP bitmap;
	if(IsEqual(match->Behavior, P3Ps_B_ACCEPT))
	{
		bitmap = _accept;
	}
	else if(IsEqual(match->Behavior,  P3Ps_B_INFORM))
	{
		bitmap = _inform;
	}
	else if(IsEqual(match->Behavior, P3Ps_B_WARN))
	{
		bitmap = _warn;
	}
	else if(IsEqual(match->Behavior, P3Ps_B_REJECT))
	{
		bitmap = _reject;
	}
	else
	{
		bitmap = _unknown;
	}
	_statusBitmap.SetBitmap(bitmap);
}

void P3P_DialogStatus::Sticky()
{
	HWND ieWnd;
	_driver->GetEvents()->GetIE()->get_HWND((long*)&ieWnd);
	if(ieWnd)
	{
		CRect rect;
		::GetWindowRect(ieWnd, rect);
		CRect rect2;
		GetWindowRect(rect2);
		int width = rect2.Width();
		int height = rect2.Height();
		if(rect.left >= width)
		{
			rect2.left = rect.left - width;
		}
		else if(::GetSystemMetrics(SM_CXSCREEN) - rect.right >= width)
		{
			rect2.left = rect.right;
		}
		else
		{
			rect2.left = ::GetSystemMetrics(SM_CXSCREEN) - width;
		}
		rect2.right = rect2.left + width;
		rect2.top = rect.top;
		rect2.bottom = rect2.top + height;
		MoveWindow(rect2);
	}
}