#ifndef BrowserDriver_H
#define BrowserDriver_H

#define BD_CLASS_NAME (TEXT("BrowserDriverClass"))

class P3P_BrowserDriver : public IObjectWithSite, public IOleCommandTarget
{
protected:
	DWORD m_ObjRefCount;
	CIEEvents* _events;
	P3P_Bar* _bar;
	P3P_BrowserDriver* _bd;
	DWORD _threadId;
	static CTypedPtrList<CPtrList, P3P_BrowserDriver*> _bdList;
	CString _url1, _url2;
	P3P_DialogStatus* _statusDialog;
	P3P_Match* _match;

public:
	P3P_BrowserDriver();
	~P3P_BrowserDriver();

	CIEEvents* GetEvents(){return _events;}
	void URIChanged();
	P3P_Policy* GetAssociatedPolicy(const char* uri, BOOL useHTML);
	static P3P_BrowserDriver* GetInstance(DWORD threadId);
	void SetBar(P3P_Bar* bar){_bar = bar;}
	void RemoveMe(P3P_Dialog* dlg){delete dlg;}
	void RemoveMe(P3P_DialogStatus* dlg);

	//IE Event Handler
	void OnBeforeNavigate2(LPDISPATCH pDisp, VARIANT* URL, VARIANT* Flags, VARIANT* TargetFrameName, VARIANT* PostData, VARIANT* Headers, BOOL* Cancel);
	void OnNavigateComplete2(LPDISPATCH pDisp, VARIANT* URL);
	void OnProgressChange(long lProgress, long lProgressMax);

	void OpenStatusView();
	CString GetCurrentURI();
	char* GetCurrentContents();
	char* GetHeader(const char* uri);
	void ShowPageStatus(P3P_Match* match);
	void CheckLink(BOOL check);
	int CheckURL(const char* url);
	void Highlight(IHTMLElement* elem, int result, IHTMLDocument2* doc);

	static char* GetFile(const char* url, BOOL get = TRUE, BOOL header = FALSE);

//	void ShowLinkStatus(P3P_Match* match, place);
//	BOOL SetState(P3P_Match* match, Pagȅꏊ);

	//IUnknown methods
	STDMETHODIMP QueryInterface(REFIID, LPVOID*);
	STDMETHODIMP_(DWORD) AddRef();
	STDMETHODIMP_(DWORD) Release();

	//IOleCommandTarget methods
	STDMETHODIMP Exec(const GUID *pguidCmdGroup, DWORD nCmdID, DWORD nCmdExecOpt, VARIANTARG *pvaIn, VARIANTARG *pvaOut);
	STDMETHODIMP QueryStatus(const GUID *pguidCmdGroup, ULONG cCmds, OLECMD prgCmds[], OLECMDTEXT *pCmdText);

	//IObjectWithSite methods
	STDMETHOD (SetSite) (IUnknown*);
	STDMETHOD (GetSite) (REFIID, LPVOID*);
};

#endif //BrowserDriver_H
