/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

#include "stdafx.h"
#include "All.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CTypedPtrList<CPtrList, P3P_BrowserDriver*> P3P_BrowserDriver::_bdList;

P3P_BrowserDriver::P3P_BrowserDriver()
{
	m_ObjRefCount = 1;
	g_DllRefCount++;
	_events = NULL;
	_bar = NULL;
	_bd = NULL;
	_statusDialog = NULL;
	_match = NULL;
}

P3P_BrowserDriver::~P3P_BrowserDriver()
{
	g_DllRefCount--;
	delete _statusDialog;
	delete _match;
}

STDMETHODIMP P3P_BrowserDriver::QueryInterface(REFIID riid, LPVOID *ppReturn)
{
	*ppReturn = NULL;

	//IUnknown
	if(IsEqualIID(riid, IID_IUnknown))
	{
		*ppReturn = this;
	}

	//IObjectWithSite
	else if(IsEqualIID(riid, IID_IOleCommandTarget))
	{
		*ppReturn = (IOleCommandTarget*)this;
	}

	//IObjectWithSite
	else if(IsEqualIID(riid, IID_IObjectWithSite))
	{
		*ppReturn = (IObjectWithSite*)this;
	}

	if(*ppReturn)
	{
		(*(LPUNKNOWN*)ppReturn)->AddRef();
		return S_OK;
	}

	return E_NOINTERFACE;
}

STDMETHODIMP_(DWORD) P3P_BrowserDriver::AddRef()
{
	return ++m_ObjRefCount;
}


STDMETHODIMP_(DWORD) P3P_BrowserDriver::Release()
{
	if(--m_ObjRefCount == 0)
	{
		delete this;
		return 0;
	}

	return m_ObjRefCount;
}

///////////////////////////////////////////////////////////////////////////
//
// IOleCommandTarget implementations
//

STDMETHODIMP P3P_BrowserDriver::QueryStatus(const GUID *pguidCmdGroup, ULONG cCmds, OLECMD *prgCmds, OLECMDTEXT *pCmdText)
{
	ULONG i;

	//make sure prgCmds is not NULL
	if(!prgCmds) return E_POINTER;

	//run through all of the commands and supply the correct information
	for(i=0;i<cCmds;i++)
	{
		prgCmds[i].cmdf = OLECMDF_SUPPORTED | OLECMDF_ENABLED;
	}

	return S_OK;
}

STDMETHODIMP P3P_BrowserDriver::Exec(const GUID *pguidCmdGroup, DWORD nCmdID, DWORD nCmdExecOpt, VARIANTARG *pvaIn, VARIANTARG *pvaOut)
{
	if(_bd == NULL)
	{
		_threadId = GetCurrentThreadId();
		P3P_BrowserDriver* bd = P3P_BrowserDriver::GetInstance(_threadId);
		if(!bd)
		{
			return E_FAIL;
		}
		_bd = bd;
	}

	_bd->OpenStatusView();
	
	return S_OK;
}

///////////////////////////////////////////////////////////////////////////
//
// IObjectWithSite implementations
//

STDMETHODIMP P3P_BrowserDriver::SetSite(IUnknown* punkSite)
{
	if(punkSite)
	{
		IShellBrowser* shb;
		punkSite->QueryInterface(IID_IShellBrowser, (void**)&shb);
		if(shb)
		{
			return S_OK;		
		}
		
		if(_bar == NULL)
		{
			_threadId = GetCurrentThreadId();
			P3P_Bar* bar = P3P_Bar::GetInstance(_threadId);
			if(bar)
			{
				_bar = bar;
				bar->SetBD(this);
			}
			else
			{
				_bdList.AddTail(this);
			}
		}

		_events = new CIEEvents((IWebBrowser2*)punkSite, this);
		BOOL result = _events->Initialize();
		P3P_PolicyManager::GetInstance()->InitializeDiskCache();
		if(result)
		{
			return S_OK;
		}
	}
	else
	{
		delete _events;
		_events = NULL;
		return S_OK;
	}
	delete _events;
	_events = NULL;
	return E_FAIL;
}

STDMETHODIMP P3P_BrowserDriver::GetSite(REFIID riid, LPVOID *ppvReturn)
{
	if(_events)
	{
		IWebBrowser2* ie = _events->GetIE();
		if(ie)
		{
			return ie->QueryInterface(riid, ppvReturn);
		}
	}

	(*ppvReturn) = NULL;
	return E_FAIL;
}

CString P3P_BrowserDriver::GetCurrentURI()
{
	USES_CONVERSION;
	BSTR bstrURL;
	IWebBrowser2* ie = _events->GetIE();
	HRESULT hr = ie->get_LocationURL(&bstrURL);
	if(SUCCEEDED(hr))
	{
		CString uri(OLE2T(bstrURL));
		return uri;
	}

	return CString();
}

char* P3P_BrowserDriver::GetHeader(const char* url)
{
	char* buf = GetFile(url, FALSE, TRUE);
	return buf;
}

void P3P_BrowserDriver::OnBeforeNavigate2(LPDISPATCH pDisp, VARIANT* URL, VARIANT* Flags, VARIANT* TargetFrameName, VARIANT* PostData, VARIANT* Headers, BOOL* Cancel)
{
	P3P_Match* oldMatch = _match;
	_match = NULL;

	USES_CONVERSION;
	_url1 = OLE2T(URL->bstrVal);
	_url2.Empty();

	HWND ieWnd;
	_events->GetIE()->get_HWND((long*)&ieWnd);

	P3P_Policy* policy = GetAssociatedPolicy(_url1, FALSE);

	if(! policy)
	{
		if(IsEqual(P3Ps_NO, P3P_Common::Read(P3Ps_GENERAL, P3Ps_IGUNKN, P3Ps_NO)))
		{
			P3P_DialogUnknown dlg;
			dlg.SetIEWnd(ieWnd);
			int res = dlg.DoCustomModal();
			if(res == IDOK)
			{
				if(dlg.NoMore())
				{
					P3P_Common::Write(P3Ps_GENERAL, P3Ps_IGUNKN, P3Ps_YES);
				}
			}
			else
			{
				*Cancel = TRUE;
				_match = oldMatch;
			}
		}
	}
	else
	{
		P3P_Preference* pref = P3P_PrefManager::GetPreference();
		P3P_Match* match = pref->MakeMatch(policy);
		if(IsEqual(match->Behavior, P3Ps_B_ACCEPT))
		{
			delete match;
			delete oldMatch;
		}
		else if(IsEqual(match->Behavior, P3Ps_B_REJECT))
		{
			//ɉ
			*Cancel = TRUE;
			delete match;
			_match = oldMatch;
		}
		else if(IsEqual(match->Behavior, P3Ps_B_WARN))
		{
			P3P_DialogWarn dlg;
			dlg.SetIEWnd(ieWnd);
			dlg.SetMatch(match);
			dlg.SetBD(this);
			int res = dlg.DoCustomModal();
			if(res == IDOK)
			{
				*Cancel = TRUE;
				_match = oldMatch;
			}
			else
			{
				delete oldMatch;
			}
		}
		else if(IsEqual(match->Behavior, P3Ps_B_INFORM))
		{
			P3P_DialogInform dlg;
			dlg.SetIEWnd(ieWnd);
			dlg.SetMatch(match);
			dlg.SetBD(this);
			int res = dlg.DoCustomModal();
			if(res == IDOK)
			{
				delete oldMatch;
			}
			else
			{
				*Cancel = TRUE;
				_match = oldMatch;
			}
		}
	}
}

void P3P_BrowserDriver::OnNavigateComplete2(LPDISPATCH pDisp, VARIANT* URL)
{
	USES_CONVERSION;
	_url2 = OLE2T(URL->bstrVal);
}

void P3P_BrowserDriver::OnProgressChange(long lProgress, long lProgressMax)
{
	//When the browser is stable, start to do P3P things.
	if(lProgress == 0 && lProgressMax == 0)
	{
		if(!_url2.IsEmpty())
		{
			URIChanged();
		}
	}
}

char* P3P_BrowserDriver::GetCurrentContents()
{
	USES_CONVERSION;

	//variables
	IDispatch* disp;
	IHTMLDocument2* doc;
	IWebBrowser2* ie;
	IHTMLElementCollection* elements;
	IHTMLElement* elem;	

	//get IE object
	ie = _events->GetIE();
	if(!ie) return NULL;

	//get HTML document object
	ie->get_Document(&disp);
	if(!disp) return NULL;
	disp->QueryInterface(IID_IHTMLDocument2, (void**)&doc);
	if(!doc) return NULL;

	//get <HEAD> elements
	doc->get_all(&elements);
	if(!elements) return NULL;
	COleVariant tagName("HEAD");
	elements->tags(tagName, &disp);
	if(!disp) return NULL;
	disp->QueryInterface(IID_IHTMLElementCollection, (void**)&elements);
	if(!elements) return NULL;
	elements->item(COleVariant((long)0), COleVariant((long)0), &disp);
	if(!disp) return NULL;
	disp->QueryInterface(IID_IHTMLElement, (void**)&elem);
	if(!elem) return NULL;

	//get <HTML> string
	BSTR body;
	elem->get_outerHTML(&body);
	const char* str = OLE2T(body);
	if(!body) return NULL;
	return CopyChar(str);
}

void P3P_BrowserDriver::ShowPageStatus(P3P_Match* match)
{
	delete _match;
	_match = match;
	if(_bar)
	{
		_bar->ShowPageStatus(match);
	}

	if(_statusDialog)
	{
		_statusDialog->ShowPageStatus(match->Clone());
	}
}

P3P_BrowserDriver* P3P_BrowserDriver::GetInstance(DWORD threadId)
{
	POSITION pos = _bdList.GetHeadPosition();
	while(pos)
	{
		POSITION pos2 = pos;
		P3P_BrowserDriver* bd = _bdList.GetNext(pos);
		if(bd->_threadId == threadId)
		{
			_bdList.RemoveAt(pos2);
			return bd;
		}
	}
	return NULL;
}


char* P3P_BrowserDriver::GetFile(const char* url, BOOL get, BOOL header)
{
	//verb
	int verb;
	if(get)
	{
		verb = CHttpConnection::HTTP_VERB_GET;
	}
	else
	{
		verb = CHttpConnection::HTTP_VERB_HEAD;
	}

	CInternetSession session("P3P_WWW", 1, PRE_CONFIG_INTERNET_ACCESS);
	CHttpConnection* pServer = NULL;
	CHttpFile* pFile = NULL;
	char* buffer = NULL;
	CString str;
	try
	{
		//Parsing URL
		CString server, object;
		INTERNET_PORT port;
		DWORD service;

		BOOL result = AfxParseURL(url, service, server, object, port);
		if(!result)
		{
			return NULL;
		}

		//Only http: is accepted
		if(service != INTERNET_SERVICE_HTTP)
		{
			return NULL;
		}

		//Connect
		pServer = session.GetHttpConnection(server, port);
		pFile = pServer->OpenRequest(verb, object, NULL, 1, NULL, NULL,
			INTERNET_FLAG_EXISTING_CONNECT | INTERNET_FLAG_NO_AUTO_REDIRECT);
		pFile->SendRequest();

		DWORD dwRet;
		pFile->QueryInfoStatusCode(dwRet);

		//Connection denied
		if(dwRet == HTTP_STATUS_DENIED)
		{
			DWORD dwPrompt;
			dwPrompt = pFile->ErrorDlg(NULL, ERROR_INTERNET_INCORRECT_PASSWORD,
				FLAGS_ERROR_UI_FLAGS_GENERATE_DATA | FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS, NULL);

			// if the user cancelled the dialog, bail out
			if(dwPrompt != ERROR_INTERNET_FORCE_RETRY)
			{
				return NULL;
			}

			pFile->SendRequest();
			pFile->QueryInfoStatusCode(dwRet);
		}

		//Redirected
		if(dwRet == HTTP_STATUS_MOVED ||
			dwRet == HTTP_STATUS_REDIRECT ||
			dwRet == HTTP_STATUS_REDIRECT_METHOD)
		{
			CString strNewLocation;
			pFile->QueryInfo(HTTP_QUERY_RAW_HEADERS_CRLF, strNewLocation);

			int nPlace = strNewLocation.Find(_T("Location: "));
			if(nPlace == -1)
			{
				return NULL;
			}

			strNewLocation = strNewLocation.Mid(nPlace + 10);
			nPlace = strNewLocation.Find('\n');
			if(nPlace > 0)
			{
				strNewLocation = strNewLocation.Left(nPlace);
			}

			//Close up the redirected site
			pFile->Close();
			delete pFile;
			pServer->Close();
			delete pServer;
			return P3P_BrowserDriver::GetFile(strNewLocation, get, header);
		}

		if(! header)
		{
			char buf[BUF_LEN];
			while (pFile->ReadString(buf, BUF_LEN - 1))
			{
				str += buf;
			}
			pFile->Close();
			pServer->Close();
		}
		else
		{
			pFile->QueryInfo(HTTP_QUERY_RAW_HEADERS_CRLF, str);
		}
	}
	catch (CInternetException* pEx)
	{
		TCHAR szErr[1024];
		pEx->GetErrorMessage(szErr, 1024);
		pEx->Delete();
		return NULL;
	}

	pFile->Close();
	pServer->Close();
	delete pFile;
	delete pServer;
	session.Close();

	return CopyChar(str);
}

void P3P_BrowserDriver::OpenStatusView()
{
	if(! _statusDialog)
	{
		_statusDialog = new P3P_DialogStatus;
		_statusDialog->SetMatch(_match->Clone());
		_statusDialog->SetBD(this);
		_statusDialog->DoCustomModal(FALSE, FALSE);
	}

	_statusDialog->Sticky();
	_statusDialog->ShowWindow(SW_SHOW);
	_statusDialog->BringWindowToTop();
}

void P3P_BrowserDriver::RemoveMe(P3P_DialogStatus* dlg)
{
	delete dlg;
	_statusDialog = NULL;
}

void P3P_BrowserDriver::URIChanged()
{
	//Getting Current Page's Policy
	CString uri = GetCurrentURI();
	P3P_Policy* pol = GetAssociatedPolicy(uri, TRUE);
	P3P_Match* match = NULL;
	if(!pol)
	{
		//no P3P compliant site
		match = new P3P_Match();
		match->Behavior = CopyChar(P3Ps_B_UNKNOWN);
	}
	else
	{
		P3P_Preference* pref = P3P_PrefManager::GetPreference();
		match = pref->MakeMatch(pol);
	}

	//Show Matching Status on the Browser
	ShowPageStatus(match);
}

P3P_Policy* P3P_BrowserDriver::GetAssociatedPolicy(const char* uri, BOOL useHTML)
{
	P3P_PolicyManager* man = P3P_PolicyManager::GetInstance();
	P3P_Policy* policy;

	//step 0: check if it is known as no-P3P-compliant page
	if(man->IsVoid(uri))
	{
		return NULL;
	}

	//step 1: try to get Policy URI from policy cache
	policy = man->GetCoveringPolicyFromCache(uri);
	if(policy)
	{
		return policy;
	}

	//step 2: try to get Policy URI from HTTP header
	char* head = GetHeader(uri);
	if(head)
	{
		policy = man->GetPolicyFromHeader(uri, head);
		delete head;
		if(policy)
		{
			return policy;
		}
	}

	if(!useHTML)
	{
		return NULL;
	}
/*
	//step 3: try to get Policy URI from HTML contents
	char* contents = _driver->GetCurrentContents();
	if(contents)
	{
		policy = man->GetPolicyFromHTML(uri, contents);
		delete contents;
		if(policy)
		{
			return policy;
		}
	}
*/
	//step 4: no P3P compliant server or page
	man->AddAsVoid(uri);
	return NULL;
}


void P3P_BrowserDriver::CheckLink(BOOL check)
{
	USES_CONVERSION;

	//variables
	IDispatch* disp;
	IHTMLDocument2* doc;
	IWebBrowser2* ie;
	IHTMLElementCollection* elements;
	IHTMLElementCollection* elems;
	IHTMLAnchorElement* anchor;
	IHTMLElement* elem;
	BSTR body;
	long i, size;

	//get IE object
	ie = _events->GetIE();
	if(!ie) return;

	//get HTML document object
	ie->get_Document(&disp);
	if(!disp) return;
	disp->QueryInterface(IID_IHTMLDocument2, (void**)&doc);
	if(!doc) return;

	//get all elements
	doc->get_all(&elements);
	if(!elements) return;

	//get "<A>" elemens
	COleVariant tagName("A");
	elements->tags(tagName, &disp);
	if(!disp) return;
	disp->QueryInterface(IID_IHTMLElementCollection, (void**)&elems);
	if(!elems) return;
	elems->get_length(&size);
	for(i=0;i<size;i++)
	{
		HRESULT res = elems->item(COleVariant(i), COleVariant((long)0), &disp);
		if(!disp) continue;
		disp->QueryInterface(IID_IHTMLAnchorElement, (void**)&anchor);
		if(!anchor) continue;
		int result = -1;
		if(check)
		{
			anchor->get_href(&body);
			result = CheckURL(OLE2T(body));
		}
		if(result)
		{
			disp->QueryInterface(IID_IHTMLElement, (void**)&elem);
			if(elem) Highlight(elem, result, doc);
		}
	}

/*
	//get "<Form>" elemens
	BSTR bbaseURL;
	doc->get_URL(&bbaseURL);
	const char* baseURL = OLE2T(bbaseURL);

	tagName = "FORM";
	elements->tags(tagName, &disp);
	if(!disp) return;
	disp->QueryInterface(IID_IHTMLElementCollection, (void**)&elems);
	if(!elems) return;
	elems->get_length(&size);
	for(i=0;i<size;i++)
	{
		HRESULT res = elems->item(COleVariant((long)0), COleVariant(i), &disp);
		if(!disp) continue;
		disp->QueryInterface(IID_IHTMLFormElement, (void**)&form);
		if(!form) continue;
		int result = -1;
		if(check)
		{
			form->get_action(&body);
			const char* url = P3P_Common::AbsoluteURI(baseURL, OLE2T(body));
			result = CheckURL(url);
		}
		if(result)
		{
			disp->QueryInterface(IID_IHTMLElement, (void**)&elem);
			if(elem) Highlight(elem, result, doc);
		}
	}
*/
}

int P3P_BrowserDriver::CheckURL(const char* url)
{
	P3P_PolicyManager* man = P3P_PolicyManager::GetInstance();
	P3P_Policy* policy = man->GetCoveringPolicyFromCache(url);
	if(!policy) return 1;

	P3P_Preference* pref = P3P_PrefManager::GetPreference();
	P3P_Match* match = pref->MakeMatch(policy);
	int result = 0;
	if(IsEqual(match->Behavior, P3Ps_B_REJECT))
	{
		result = 3;
	}
	else if(IsEqual(match->Behavior, P3Ps_B_WARN) || IsEqual(match->Behavior, P3Ps_B_INFORM))
	{
		result = 2;
	}

	delete match;
	return result;
}

void P3P_BrowserDriver::Highlight(IHTMLElement* elem, int result, IHTMLDocument2* doc)
{
	USES_CONVERSION;

	const char* color = "YELLOW";
	switch(result)
	{
		case -1:
			color = "NONE";
			break;
		case 1:
			color = "YELLOW";
			break;
		case 2:
			color = "PINK";
			break;
		case 3:
			color = "RED";
			break;
	}


	IHTMLBodyElement* body;
	IHTMLElement* element;
	IHTMLTxtRange* range;
	short val2;
	doc->get_body(&element);
	if(!element) return;
	element->QueryInterface(IID_IHTMLBodyElement, (void**)&body);
	if(!body) return;
	body->createTextRange(&range);
	if(!range) return;
	range->moveToElementText(elem);
	BSTR cmd= T2OLE("BackColor");
	range->execCommand(cmd, 0, COleVariant(color), &val2);
}
