/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

#include "stdafx.h"
#include "All.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_DYNCREATE(CIEEvents, CCmdTarget)

//#define _TRACE_ON_

static CTypedPtrList<CObList, CIEEvents*> _instances;
static int _trace_count = 0;

CIEEvents::CIEEvents(IWebBrowser2* ie, P3P_BrowserDriver* bd)
 : _ie(ie), _bd(bd)
{
	EnableAutomation();
}

BOOL CIEEvents::Initialize()
{
	BOOL bAdvised = AfxConnectionAdvise(
		_ie, 
		DIID_DWebBrowserEvents2, 
		GetInterface(&IID_IUnknown), 
		TRUE, 
		&_dwCookie);

	return bAdvised;
}

CIEEvents::~CIEEvents()
{
	BOOL bUnadvised = AfxConnectionUnadvise(
		_ie,
		DIID_DWebBrowserEvents2,
		GetInterface(&IID_IUnknown),
		TRUE,
		_dwCookie);

	_dwCookie = 0;
}

IWebBrowser2* CIEEvents::GetIE()
{
	return _ie;
}

BEGIN_MESSAGE_MAP(CIEEvents, CCmdTarget)
	//{{AFX_MSG_MAP(CIEEvents)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CIEEvents, CCmdTarget)
	DISP_FUNCTION_ID(CIEEvents, "BeforeNavigate2", DISPID_BEFORENAVIGATE2,
					OnBeforeNavigate2, VT_EMPTY, VTS_DISPATCH VTS_PVARIANT
					VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PBOOL)

	DISP_FUNCTION_ID(CIEEvents, "CommandStateChange", DISPID_COMMANDSTATECHANGE,
					OnCommandStateChange, VT_EMPTY, VTS_I4 VTS_BOOL)

	DISP_FUNCTION_ID(CIEEvents, "DocumentComplete", DISPID_DOCUMENTCOMPLETE,
					OnDocumentComplete, VT_EMPTY, VTS_DISPATCH VTS_PVARIANT)

	DISP_FUNCTION_ID(CIEEvents, "DownloadComplete", DISPID_DOWNLOADCOMPLETE,
					OnDownloadComplete, VT_EMPTY, VTS_NONE)

	DISP_FUNCTION_ID(CIEEvents, "NavigateComplete2", DISPID_NAVIGATECOMPLETE2,
					OnNavigateComplete2, VT_EMPTY, VTS_DISPATCH VTS_PVARIANT)

	DISP_FUNCTION_ID(CIEEvents, "NewWindow2", DISPID_NEWWINDOW2, 
					OnNewWindow2, VT_EMPTY, VTS_DISPATCH VTS_PBOOL)

	DISP_FUNCTION_ID(CIEEvents, "OnQuit", DISPID_ONQUIT, OnQuit, VT_EMPTY, VTS_NONE)

	DISP_FUNCTION_ID(CIEEvents, "ProgressChange", DISPID_PROGRESSCHANGE,
					OnProgressChange, VT_EMPTY, VTS_I4 VTS_I4)

	DISP_FUNCTION_ID(CIEEvents, "StatusTextChange", DISPID_STATUSTEXTCHANGE,
					OnStatusTextChange, VT_EMPTY, VTS_BSTR)

	DISP_FUNCTION_ID(CIEEvents, "TitleChange", DISPID_TITLECHANGE,
					OnTitleChange, VT_EMPTY, VTS_BSTR)
END_DISPATCH_MAP()

BEGIN_INTERFACE_MAP(CIEEvents, CCmdTarget)
	INTERFACE_PART(CIEEvents, DIID_DWebBrowserEvents2, Dispatch)
END_INTERFACE_MAP()

void CIEEvents::OnBeforeNavigate2(LPDISPATCH pDisp, VARIANT* URL, VARIANT* Flags, VARIANT* TargetFrameName, VARIANT* PostData, VARIANT* Headers, BOOL* Cancel)
{
#ifdef _TRACE_ON_
	USES_CONVERSION;
	CString strEvt("BeforeNavigate2: ");
	strEvt += OLE2T(URL->bstrVal);
	TRACE("%5d %s\n", _trace_count++, strEvt);
#endif
	_bd->OnBeforeNavigate2(pDisp, URL, Flags, TargetFrameName, PostData, Headers, Cancel);
}

void CIEEvents::OnCommandStateChange(long lCommand, BOOL bEnable)
{
/*
#ifdef _TRACE_ON_
	CString strEvt;
	strEvt.Format("CommandStateChange: Command = %ld Enable = %d", lCommand, bEnable);
	TRACE("%5d %s\n", _trace_count++, strEvt);
#endif
*/
}

void CIEEvents::OnDocumentComplete(LPDISPATCH pDisp, VARIANT* URL)
{
#ifdef _TRACE_ON_
	USES_CONVERSION;
	CString strEvt("DocumentComplete: ");
	strEvt += OLE2T(URL->bstrVal);
	TRACE("%5d %s\n", _trace_count++, strEvt);
#endif
}

void CIEEvents::OnDownloadComplete() 
{
#ifdef _TRACE_ON_
	TRACE("%5d Download Complete \n", _trace_count++);
#endif
}

void CIEEvents::OnNavigateComplete2(LPDISPATCH pDisp, VARIANT* URL)
{
#ifdef _TRACE_ON_
	USES_CONVERSION;
	CString strEvt("NavigateComplete2: ");
	strEvt += OLE2T(URL->bstrVal);
	TRACE("%5d %s\n", _trace_count++, strEvt);
#endif
	_bd->OnNavigateComplete2(pDisp, URL);
}

void CIEEvents::OnNewWindow2(LPDISPATCH* ppDisp, BOOL* Cancel)
{
#ifdef _TRACE_ON_
	TRACE("%5d OnNewWindow2 \n", _trace_count++);
#endif
}

void CIEEvents::OnProgressChange(long lProgress, long lProgressMax)
{
/*
#ifdef _TRACE_ON_
	CString strEvt;
	strEvt.Format("ProgressChange: Progress = %ld ProgressMax = %ld", lProgress, lProgressMax);
	TRACE("%d %s\n", _trace_count++, strEvt);
#endif
*/
	//When the browser is stable, start to do P3P things.
	if(lProgress == 0 && lProgressMax == 0)
	{
		_bd->OnProgressChange(lProgress, lProgressMax);
	}
}

void CIEEvents::OnStatusTextChange(LPCTSTR lpszText) 
{
/*
#ifdef _TRACE_ON_
	CString strEvt("StatusTextChange: ");
	strEvt += lpszText;
	TRACE("%5d %s\n", _trace_count++, strEvt);
#endif
*/
}

void CIEEvents::OnTitleChange(LPCTSTR lpszText) 
{
/*
#ifdef _TRACE_ON_
	CString strEvt("TitleChange: ");
	strEvt += lpszText;
	TRACE("%5d %s\n", _trace_count++, strEvt);
#endif
*/
}

void CIEEvents::OnQuit()
{
#ifdef _TRACE_ON_
	TRACE("%5d IE Quit\n", _trace_count++);
#endif
}
