/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

#include "stdafx.h"
#include "All.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////////////
//
// IClassFactory implementation
//

CClassFactory::CClassFactory(CLSID clsid)
{
	m_clsidObject = clsid;
	m_ObjRefCount = 1;
	g_DllRefCount++;
}

CClassFactory::~CClassFactory()
{
	g_DllRefCount--;
}

STDMETHODIMP CClassFactory::QueryInterface(REFIID riid, LPVOID *ppReturn)
{
	*ppReturn = NULL;

	if(IsEqualIID(riid, IID_IUnknown))
	{
		*ppReturn = this;
	}
	else if(IsEqualIID(riid, IID_IClassFactory))
	{
		*ppReturn = (IClassFactory*)this;
	}

	if(*ppReturn)
	{
		(*(LPUNKNOWN*)ppReturn)->AddRef();
		return S_OK;
	}

	return E_NOINTERFACE;
}

STDMETHODIMP_(DWORD) CClassFactory::AddRef()
{
	return ++m_ObjRefCount;
}

STDMETHODIMP_(DWORD) CClassFactory::Release()
{
	if(--m_ObjRefCount == 0)
	{
		delete this;
		return 0;
	}

	return m_ObjRefCount;
}

STDMETHODIMP CClassFactory::CreateInstance(LPUNKNOWN pUnknown, REFIID riid, LPVOID *ppObject)
{
	HRESULT hResult = E_FAIL;
	LPVOID pTemp = NULL;

	*ppObject = NULL;

	if(pUnknown != NULL)
		return CLASS_E_NOAGGREGATION;

	//create the proper object
	if(IsEqualCLSID(m_clsidObject, CLSID_P3P_Bar))
	{
		P3P_Bar *pCommBand = new P3P_Bar();
		if(NULL == pCommBand)
			return E_OUTOFMEMORY;

		pTemp = pCommBand;
	}
	if(IsEqualCLSID(m_clsidObject, CLSID_P3P_BrowserDriver))
	{
		P3P_BrowserDriver *pCommBand = new P3P_BrowserDriver();
		if(NULL == pCommBand)
			return E_OUTOFMEMORY;

		pTemp = pCommBand;
	}
  
	if(pTemp)
	{
		//get the QueryInterface return for our return value
		hResult = ((LPUNKNOWN)pTemp)->QueryInterface(riid, ppObject);

		//call Release to decement the ref count
		((LPUNKNOWN)pTemp)->Release();
	}

	return hResult;
}


STDMETHODIMP CClassFactory::LockServer(BOOL)
{
	return E_NOTIMPL;
}
