/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

#include "stdafx.h"
#include "BrowserView.h"
#include "Guid.h"
#include "IEEvents.h"

P3P_BrowserView::P3P_BrowserView()
{
	m_pSite = NULL;
	m_hWnd = NULL;
	m_hwndParent = NULL;
	m_bFocus = FALSE;
	m_dwViewMode = 0;
	m_dwBandID = 0;
	m_ObjRefCount = 1;
	g_DllRefCount++;

}

P3P_BrowserView::~P3P_BrowserView()
{
	//this should have been freed in a call to SetSite(NULL), but just to be safe
	if(m_pSite)
	{
		m_pSite->Release();
	m_pSite = NULL;
	}
	g_DllRefCount--;
}

STDMETHODIMP P3P_BrowserView::QueryInterface(REFIID riid, LPVOID *ppReturn)
{
	*ppReturn = NULL;

	//IUnknown
	if(IsEqualIID(riid, IID_IUnknown))
	{
		*ppReturn = this;
	}

	//IOleWindow
	else if(IsEqualIID(riid, IID_IOleWindow))
	{
		*ppReturn = (IOleWindow*)this;
	}

	//IDockingWindow
	else if(IsEqualIID(riid, IID_IDockingWindow))
	{
		*ppReturn = (IDockingWindow*)this;
	}

	//IInputObject
	else if(IsEqualIID(riid, IID_IInputObject))
	{
		*ppReturn = (IInputObject*)this;
	}

	//IObjectWithSite
	else if(IsEqualIID(riid, IID_IObjectWithSite))
	{
		*ppReturn = (IObjectWithSite*)this;
	}

	//IDeskBand
	else if(IsEqualIID(riid, IID_IDeskBand))
	{
		*ppReturn = (IDeskBand*)this;
	}

	//IPersist
	else if(IsEqualIID(riid, IID_IPersist))
	{
		*ppReturn = (IPersist*)this;
	}

	//IPersistStream
	else if(IsEqualIID(riid, IID_IPersistStream))
	{
		*ppReturn = (IPersistStream*)this;
	}

	//IContextMenu
	else if(IsEqualIID(riid, IID_IContextMenu))
	{
		*ppReturn = (IContextMenu*)this;
	}

	if(*ppReturn)
	{
		(*(LPUNKNOWN*)ppReturn)->AddRef();
		return S_OK;
	}

	return E_NOINTERFACE;
}

STDMETHODIMP_(DWORD) P3P_BrowserView::AddRef()
{
	return ++m_ObjRefCount;
}


STDMETHODIMP_(DWORD) P3P_BrowserView::Release()
{
	if(--m_ObjRefCount == 0)
	{
		delete this;
		return 0;
	}

	return m_ObjRefCount;
}

///////////////////////////////////////////////////////////////////////////
//
// IOleWindow Implementation
//

STDMETHODIMP P3P_BrowserView::GetWindow(HWND *phWnd)
{
	*phWnd = m_hWnd;
	return S_OK;
}

STDMETHODIMP P3P_BrowserView::ContextSensitiveHelp(BOOL fEnterMode)
{
	return E_NOTIMPL;
}

///////////////////////////////////////////////////////////////////////////
//
// IDockingWindow Implementation
//

STDMETHODIMP P3P_BrowserView::ShowDW(BOOL fShow)
{
	if(m_hWnd)
	{
		if(fShow)
		{
			//show our window
			ShowWindow(m_hWnd, SW_SHOW);
		}
		else
		{
			//hide our window
			ShowWindow(m_hWnd, SW_HIDE);
		}
	}

	return S_OK;
}

STDMETHODIMP P3P_BrowserView::CloseDW(DWORD dwReserved)
{
	ShowDW(FALSE);

	if(IsWindow(m_hWnd))
		DestroyWindow(m_hWnd);

	m_hWnd = NULL;

	return S_OK;
}

STDMETHODIMP P3P_BrowserView::ResizeBorderDW(LPCRECT prcBorder, IUnknown* punkSite, BOOL fReserved)
{
	//This method is never called for Band Objects.
	return E_NOTIMPL;
}

///////////////////////////////////////////////////////////////////////////
//
// IInputObject Implementation
//

STDMETHODIMP P3P_BrowserView::UIActivateIO(BOOL fActivate, LPMSG pMsg)
{
	if(fActivate)
		SetFocus(m_hWnd);

	return S_OK;
}

/**************************************************************************
P3P_BrowserView::HasFocusIO()

If this window or one of its decendants has the focus, return S_OK. Return 
S_FALSE if we don't have the focus.
**************************************************************************/

STDMETHODIMP P3P_BrowserView::HasFocusIO(void)
{
	if(m_bFocus)
		return S_OK;

	return S_FALSE;
}

/**************************************************************************
P3P_BrowserView::TranslateAcceleratorIO()

If the accelerator is translated, return S_OK or S_FALSE otherwise.
**************************************************************************/

STDMETHODIMP P3P_BrowserView::TranslateAcceleratorIO(LPMSG pMsg)
{
	return S_FALSE;
}

///////////////////////////////////////////////////////////////////////////
//
// IObjectWithSite implementations
//

STDMETHODIMP P3P_BrowserView::SetSite(IUnknown* punkSite)
{
	//If a site is being held, release it.
	if(m_pSite)
	{
		m_pSite->Release();
		m_pSite = NULL;
	}

	//If punkSite is not NULL, a new site is being set.
	if(punkSite)
	{
		//Get the parent window.
		IOleWindow  *pOleWindow;

		m_hwndParent = NULL;

		if(SUCCEEDED(punkSite->QueryInterface(IID_IOleWindow, (LPVOID*)&pOleWindow)))
		{
			pOleWindow->GetWindow(&m_hwndParent);
			pOleWindow->Release();
		}

		if(!m_hwndParent)
			return E_FAIL;

		if(!RegisterAndCreateWindow())
			return E_FAIL;

		//Get and keep the IInputObjectSite pointer.
		if(SUCCEEDED(punkSite->QueryInterface(IID_IInputObjectSite, (LPVOID*)&m_pSite)))
		{
			return S_OK;
		}

		return E_FAIL;
	}

	return S_OK;
}

STDMETHODIMP P3P_BrowserView::GetSite(REFIID riid, LPVOID *ppvReturn)
{
	*ppvReturn = NULL;

	if(m_pSite)
		return m_pSite->QueryInterface(riid, ppvReturn);

	return E_FAIL;
}

///////////////////////////////////////////////////////////////////////////
//
// IDeskBand implementation
//

STDMETHODIMP P3P_BrowserView::GetBandInfo(DWORD dwBandID, DWORD dwViewMode, DESKBANDINFO* pdbi)
{
	if(pdbi)
	{
		m_dwBandID = dwBandID;
		m_dwViewMode = dwViewMode;

		if(pdbi->dwMask & DBIM_MINSIZE)
		{
			pdbi->ptMinSize.x = 0;
			pdbi->ptMinSize.y = 30;
		}

		if(pdbi->dwMask & DBIM_MAXSIZE)
		{
			pdbi->ptMaxSize.x = -1;
			pdbi->ptMaxSize.y = 30;
		}

		if(pdbi->dwMask & DBIM_INTEGRAL)
		{
			pdbi->ptIntegral.x = 1;
			pdbi->ptIntegral.y = 1;
		}

		if(pdbi->dwMask & DBIM_ACTUAL)
		{
			pdbi->ptActual.x = 0;
			pdbi->ptActual.y = 0;
		}

		if(pdbi->dwMask & DBIM_TITLE)
		{
			lstrcpyW(pdbi->wszTitle, L"");
		}

		if(pdbi->dwMask & DBIM_MODEFLAGS)
		{
			pdbi->dwModeFlags = DBIMF_NORMAL;
		}

		if(pdbi->dwMask & DBIM_BKCOLOR)
		{
			//Use the default background color by removing this flag.
			pdbi->dwMask &= ~DBIM_BKCOLOR;
		}

		return S_OK;
	}

	return E_INVALIDARG;
}

///////////////////////////////////////////////////////////////////////////
//
// IPersistStream implementations
// 
// This is only supported to allow the desk band to be dropped on the 
// desktop and to prevent multiple instances of the desk band from showing 
// up in the context menu. This desk band doesn't actually persist any data.
//

STDMETHODIMP P3P_BrowserView::GetClassID(LPCLSID pClassID)
{
	*pClassID = CLSID_P3P_BrowserView;

	return S_OK;
}

STDMETHODIMP P3P_BrowserView::IsDirty(void)
{
	return S_FALSE;
}

STDMETHODIMP P3P_BrowserView::Load(LPSTREAM pStream)
{
	return S_OK;
}

STDMETHODIMP P3P_BrowserView::Save(LPSTREAM pStream, BOOL fClearDirty)
{
	return S_OK;
}

STDMETHODIMP P3P_BrowserView::GetSizeMax(ULARGE_INTEGER *pul)
{
	return E_NOTIMPL;
}

///////////////////////////////////////////////////////////////////////////
//
// IContextMenu Implementation
//

STDMETHODIMP P3P_BrowserView::QueryContextMenu( HMENU hMenu, UINT indexMenu, UINT idCmdFirst, UINT idCmdLast, UINT uFlags)
{
	if(!(CMF_DEFAULTONLY & uFlags))
	{
		InsertMenu(hMenu, indexMenu, MF_STRING | MF_BYPOSITION, idCmdFirst + IDM_COMMAND, "&Sample Comm Band Command");

		return MAKE_HRESULT(SEVERITY_SUCCESS, 0, USHORT(IDM_COMMAND + 1));
	}

	return MAKE_HRESULT(SEVERITY_SUCCESS, 0, USHORT(0));
}

STDMETHODIMP P3P_BrowserView::InvokeCommand(LPCMINVOKECOMMANDINFO lpcmi)
{
	switch (LOWORD(lpcmi->lpVerb))
	{
		case IDM_COMMAND:
			MessageBox(lpcmi->hwnd, TEXT("Comm Band Command selected."), TEXT("Sample Comm Band"), MB_OK | MB_ICONINFORMATION);
			break;

		default:
			return E_INVALIDARG;
	}

	return NOERROR;
}

STDMETHODIMP P3P_BrowserView::GetCommandString( UINT idCommand, UINT uFlags, UINT* lpReserved,
 LPSTR lpszName, UINT uMaxNameLen)
{
	HRESULT  hr = E_INVALIDARG;

	switch(uFlags)
	{
		case GCS_HELPTEXT:
			switch(idCommand)
			{
				case IDM_COMMAND:
					lstrcpy(lpszName, TEXT("Comm Band command help text"));
					hr = NOERROR;
					break;
			}
			break;

		case GCS_VERB:
			switch(idCommand)
			{
				case IDM_COMMAND:
					lstrcpy(lpszName, TEXT("command"));
					hr = NOERROR;
					break;
			}
			break;

		case GCS_VALIDATE:
			hr = NOERROR;
			break;
	}

	return hr;
}

///////////////////////////////////////////////////////////////////////////
//
// private method implementations
//
LRESULT CALLBACK P3P_BrowserView::WndProc(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam)
{
	P3P_BrowserView  *pThis = (P3P_BrowserView*)GetWindowLong(hWnd, GWL_USERDATA);

	switch (uMessage)
	{
		case WM_NCCREATE:
			{
				LPCREATESTRUCT lpcs = (LPCREATESTRUCT)lParam;
				pThis = (P3P_BrowserView*)(lpcs->lpCreateParams);
				SetWindowLong(hWnd, GWL_USERDATA, (LONG)pThis);

				//set the window handle
				pThis->m_hWnd = hWnd;
			}
			break;

		case WM_PAINT:
			return pThis->OnPaint();

		case WM_COMMAND:
			return pThis->OnCommand(wParam, lParam);

		case WM_SETFOCUS:
			return pThis->OnSetFocus();

		case WM_KILLFOCUS:
			return pThis->OnKillFocus();
	}

	return DefWindowProc(hWnd, uMessage, wParam, lParam);
}

LRESULT P3P_BrowserView::OnPaint(void)
{
	PAINTSTRUCT ps;
	RECT  rc;

	BeginPaint(m_hWnd, &ps);

	GetClientRect(m_hWnd, &rc);
	SetTextColor(ps.hdc, RGB(0, 0, 0));
	SetBkMode(ps.hdc, TRANSPARENT);
	DrawText(ps.hdc, TEXT("Sample Comm Band"), -1, &rc, DT_SINGLELINE | DT_CENTER | DT_VCENTER);

	EndPaint(m_hWnd, &ps);

	return 0;
}

LRESULT P3P_BrowserView::OnCommand(WPARAM wParam, LPARAM lParam)
{
	return 0;
}

void P3P_BrowserView::FocusChange(BOOL bFocus)
{
	m_bFocus = bFocus;

	//inform the input object site that the focus has changed
	if(m_pSite)
	{
		m_pSite->OnFocusChangeIS((IDockingWindow*)this, bFocus);
	}
}

LRESULT P3P_BrowserView::OnSetFocus(void)
{
	FocusChange(TRUE);
	return 0;
}

LRESULT P3P_BrowserView::OnKillFocus(void)
{
	FocusChange(FALSE);
	return 0;
}

BOOL P3P_BrowserView::RegisterAndCreateWindow(void)
{
	//If the window doesn't exist yet, create it now.
	if(!m_hWnd)
	{
		//Can't create a child window without a parent.
		if(!m_hwndParent)
		{
			return FALSE;
		}

		//If the window class has not been registered, then do so.
		WNDCLASS wc;
		if(!GetClassInfo(g_hInst, BV_CLASS_NAME, &wc))
		{
			ZeroMemory(&wc, sizeof(wc));
			wc.style = CS_HREDRAW | CS_VREDRAW | CS_GLOBALCLASS;
			wc.lpfnWndProc = (WNDPROC)WndProc;
			wc.cbClsExtra  = 0;
			wc.cbWndExtra  = 0;
			wc.hInstance= g_hInst;
			wc.hIcon = NULL;
			wc.hCursor  = LoadCursor(NULL, IDC_ARROW);
			wc.hbrBackground  = (HBRUSH)CreateSolidBrush(RGB(0, 192, 0));
			wc.lpszMenuName= NULL;
			wc.lpszClassName  = BV_CLASS_NAME;

			if(!RegisterClass(&wc))
			{
				//If RegisterClass fails, CreateWindow below will fail.
			}
		}

		RECT  rc;

		GetClientRect(m_hwndParent, &rc);

		//Create the window. The WndProc will set m_hWnd.
		CreateWindowEx(0,
			BV_CLASS_NAME,
			NULL,
			WS_CHILD | WS_CLIPSIBLINGS | WS_BORDER,
			rc.left,
			rc.top,
			rc.right - rc.left,
			rc.bottom - rc.top,
			m_hwndParent,
			NULL,
			g_hInst,
			(LPVOID)this);

	}

	return (NULL != m_hWnd);
}
