/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

#include "stdafx.h"
#include "BrowserDriver.h"
#include "Guid.h"
#include "IEEvents.h"

P3P_BrowserDriver::P3P_BrowserDriver()
{
	m_ObjRefCount = 1;
	g_DllRefCount++;
}

P3P_BrowserDriver::~P3P_BrowserDriver()
{
	g_DllRefCount--;
}

STDMETHODIMP P3P_BrowserDriver::QueryInterface(REFIID riid, LPVOID *ppReturn)
{
	*ppReturn = NULL;

	//IUnknown
	if(IsEqualIID(riid, IID_IUnknown))
	{
		*ppReturn = this;
	}

	//IObjectWithSite
	else if(IsEqualIID(riid, IID_IObjectWithSite))
	{
		*ppReturn = (IObjectWithSite*)this;
	}

	if(*ppReturn)
	{
		(*(LPUNKNOWN*)ppReturn)->AddRef();
		return S_OK;
	}

	return E_NOINTERFACE;
}

STDMETHODIMP_(DWORD) P3P_BrowserDriver::AddRef()
{
	return ++m_ObjRefCount;
}


STDMETHODIMP_(DWORD) P3P_BrowserDriver::Release()
{
	if(--m_ObjRefCount == 0)
	{
		delete this;
		return 0;
	}

	return m_ObjRefCount;
}

///////////////////////////////////////////////////////////////////////////
//
// IObjectWithSite implementations
//

STDMETHODIMP P3P_BrowserDriver::SetSite(IUnknown* punkSite)
{
	if(punkSite)
	{
		BOOL result = CIEEvents::CreateInstance((IWebBrowser2*)punkSite, this);
		if(result)
		{
			return S_OK;
		}
	}
	else
	{
		CIEEvents::Release(this);
	}
	return E_FAIL;
}

STDMETHODIMP P3P_BrowserDriver::GetSite(REFIID riid, LPVOID *ppvReturn)
{
	IWebBrowser2* ie = CIEEvents::GetIE(this);
	if(ie)
	{
		return ie->QueryInterface(riid, ppvReturn);
	}
	else
	{
		(*ppvReturn) = NULL;
		return E_FAIL;
	}
}
