#ifndef Bar_H
#define Bar_H

#define BV_CLASS_NAME (TEXT("BarClass"))

#define IDM_COMMAND  0

class P3P_Bar : public IDeskBand, 
				public IInputObject, 
				public IObjectWithSite,
				public IPersistStream,
				public IContextMenu
{
protected:
	//COM related members
	DWORD m_ObjRefCount;
	BOOL m_bFocus;
	HWND m_hwndParent;
	HWND m_hWnd;
	DWORD m_dwViewMode;
	DWORD m_dwBandID;
	IInputObjectSite *m_pSite;

	//BrowserDriver
	DWORD _threadId;
	static CTypedPtrList<CPtrList, P3P_Bar*> _barList;
	P3P_BrowserDriver* _bd;

	//Bitmap Images
	HBITMAP _logo, _s_accept, _s_reject, _s_unknown, _s_prompt, _c_view, _c_check, _status;

	//Others
	const char* _p3p_page_status;

public:
	//construction
	P3P_Bar();
	~P3P_Bar();

	//Browser Driver
	static P3P_Bar* GetInstance(DWORD thread);	
	void SetBD(P3P_BrowserDriver* bd){_bd = bd;}

	//Page status
	void ShowPageStatus(P3P_Match* match);

	//IUnknown methods
	STDMETHODIMP QueryInterface(REFIID, LPVOID*);
	STDMETHODIMP_(DWORD) AddRef();
	STDMETHODIMP_(DWORD) Release();

	//IOleWindow methods
	STDMETHOD (GetWindow) (HWND*);
	STDMETHOD (ContextSensitiveHelp) (BOOL);

	//IDockingWindow methods
	STDMETHOD (ShowDW) (BOOL fShow);
	STDMETHOD (CloseDW) (DWORD dwReserved);
	STDMETHOD (ResizeBorderDW) (LPCRECT prcBorder, IUnknown* punkToolbarSite, BOOL fReserved);

	//IDeskBand methods
	STDMETHOD (GetBandInfo) (DWORD, DWORD, DESKBANDINFO*);

	//IInputObject methods
	STDMETHOD (UIActivateIO) (BOOL, LPMSG);
	STDMETHOD (HasFocusIO) (void);
	STDMETHOD (TranslateAcceleratorIO) (LPMSG);

	//IObjectWithSite methods
	STDMETHOD (SetSite) (IUnknown*);
	STDMETHOD (GetSite) (REFIID, LPVOID*);

	//IPersistStream methods
	STDMETHOD (GetClassID) (LPCLSID);
	STDMETHOD (IsDirty) (void);
	STDMETHOD (Load) (LPSTREAM);
	STDMETHOD (Save) (LPSTREAM, BOOL);
	STDMETHOD (GetSizeMax) (ULARGE_INTEGER*);

	//IContextMenu methods
	STDMETHOD (QueryContextMenu)(HMENU, UINT, UINT, UINT, UINT);
	STDMETHOD (InvokeCommand)(LPCMINVOKECOMMANDINFO);
	STDMETHOD (GetCommandString)(UINT, UINT, UINT*, LPSTR, UINT);

protected:
	void FocusChange(BOOL);
	LRESULT OnKillFocus(void);
	LRESULT OnSetFocus(void);
	static LRESULT CALLBACK WndProc(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam);
	LRESULT OnPaint(void);
	LRESULT OnCommand(WPARAM wParam, LPARAM lParam);
	BOOL RegisterAndCreateWindow(void);
};

#endif //Bar_H
