/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

#include "stdafx.h"
#include "All.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CTypedPtrList<CPtrList, P3P_Bar*> P3P_Bar::_barList;

P3P_Bar::P3P_Bar()
{
	//Initialize
	m_pSite = NULL;
	m_hWnd = NULL;
	m_hwndParent = NULL;
	m_bFocus = FALSE;
	m_dwViewMode = 0;
	m_dwBandID = 0;
	m_ObjRefCount = 1;
	g_DllRefCount++;
	_bd = NULL;

	//Bitmap Loading
	_logo = (HBITMAP)LoadImage(NULL, "d:\\Proj\\P3P\\P3PAgent\\P3P_logo.bmp", IMAGE_BITMAP, 104, 32, LR_LOADFROMFILE);
	_s_accept = (HBITMAP)LoadImage(NULL, "d:\\Proj\\P3P\\P3PAgent\\s_accept.bmp", IMAGE_BITMAP, 32, 32, LR_LOADFROMFILE);
	_s_reject = (HBITMAP)LoadImage(NULL, "d:\\Proj\\P3P\\P3PAgent\\s_reject.bmp", IMAGE_BITMAP, 32, 32, LR_LOADFROMFILE);
	_s_unknown = (HBITMAP)LoadImage(NULL, "d:\\Proj\\P3P\\P3PAgent\\s_unknown.bmp", IMAGE_BITMAP, 32, 32, LR_LOADFROMFILE);
	_s_prompt = (HBITMAP)LoadImage(NULL, "d:\\Proj\\P3P\\P3PAgent\\s_prompt.bmp", IMAGE_BITMAP, 32, 32, LR_LOADFROMFILE);
	_c_view = (HBITMAP)LoadImage(NULL, "d:\\Proj\\P3P\\P3PAgent\\c_view.bmp", IMAGE_BITMAP, 104, 32, LR_LOADFROMFILE);
	_c_check = (HBITMAP)LoadImage(NULL, "d:\\Proj\\P3P\\P3PAgent\\c_check.bmp", IMAGE_BITMAP, 104, 32, LR_LOADFROMFILE);

	_status = _s_unknown;
}

P3P_Bar::~P3P_Bar()
{
	//this should have been freed in a call to SetSite(NULL), but just to be safe
	if(m_pSite)
	{
		m_pSite->Release();
	m_pSite = NULL;
	}
	g_DllRefCount--;

	DeleteObject(_logo);
	DeleteObject(_s_accept);
	DeleteObject(_s_reject);
	DeleteObject(_s_prompt);
	DeleteObject(_s_unknown);
	DeleteObject(_c_view);
	DeleteObject(_c_check);
}

STDMETHODIMP P3P_Bar::QueryInterface(REFIID riid, LPVOID *ppReturn)
{
	*ppReturn = NULL;

	//IUnknown
	if(IsEqualIID(riid, IID_IUnknown))
	{
		*ppReturn = this;
	}

	//IOleWindow
	else if(IsEqualIID(riid, IID_IOleWindow))
	{
		*ppReturn = (IOleWindow*)this;
	}

	//IDockingWindow
	else if(IsEqualIID(riid, IID_IDockingWindow))
	{
		*ppReturn = (IDockingWindow*)this;
	}

	//IInputObject
	else if(IsEqualIID(riid, IID_IInputObject))
	{
		*ppReturn = (IInputObject*)this;
	}

	//IObjectWithSite
	else if(IsEqualIID(riid, IID_IObjectWithSite))
	{
		*ppReturn = (IObjectWithSite*)this;
	}

	//IDeskBand
	else if(IsEqualIID(riid, IID_IDeskBand))
	{
		*ppReturn = (IDeskBand*)this;
	}

	//IPersist
	else if(IsEqualIID(riid, IID_IPersist))
	{
		*ppReturn = (IPersist*)this;
	}

	//IPersistStream
	else if(IsEqualIID(riid, IID_IPersistStream))
	{
		*ppReturn = (IPersistStream*)this;
	}

	//IContextMenu
	else if(IsEqualIID(riid, IID_IContextMenu))
	{
		*ppReturn = (IContextMenu*)this;
	}

	if(*ppReturn)
	{
		(*(LPUNKNOWN*)ppReturn)->AddRef();
		return S_OK;
	}

	return E_NOINTERFACE;
}

STDMETHODIMP_(DWORD) P3P_Bar::AddRef()
{
	return ++m_ObjRefCount;
}


STDMETHODIMP_(DWORD) P3P_Bar::Release()
{
	if(--m_ObjRefCount == 0)
	{
		delete this;
		return 0;
	}

	return m_ObjRefCount;
}

///////////////////////////////////////////////////////////////////////////
//
// IOleWindow Implementation
//

STDMETHODIMP P3P_Bar::GetWindow(HWND *phWnd)
{
	*phWnd = m_hWnd;
	return S_OK;
}

STDMETHODIMP P3P_Bar::ContextSensitiveHelp(BOOL fEnterMode)
{
	return E_NOTIMPL;
}

///////////////////////////////////////////////////////////////////////////
//
// IDockingWindow Implementation
//

STDMETHODIMP P3P_Bar::ShowDW(BOOL fShow)
{
	if(m_hWnd)
	{
		if(fShow)
		{
			//show our window
			ShowWindow(m_hWnd, SW_SHOW);
		}
		else
		{
			//hide our window
			ShowWindow(m_hWnd, SW_HIDE);
		}
	}

	return S_OK;
}

STDMETHODIMP P3P_Bar::CloseDW(DWORD dwReserved)
{
	ShowDW(FALSE);

	if(IsWindow(m_hWnd))
		DestroyWindow(m_hWnd);

	m_hWnd = NULL;

	return S_OK;
}

STDMETHODIMP P3P_Bar::ResizeBorderDW(LPCRECT prcBorder, IUnknown* punkSite, BOOL fReserved)
{
	//This method is never called for Band Objects.
	return E_NOTIMPL;
}

///////////////////////////////////////////////////////////////////////////
//
// IInputObject Implementation
//

STDMETHODIMP P3P_Bar::UIActivateIO(BOOL fActivate, LPMSG pMsg)
{
	if(fActivate)
		SetFocus(m_hWnd);

	return S_OK;
}

/**************************************************************************
P3P_Bar::HasFocusIO()

If this window or one of its decendants has the focus, return S_OK. Return 
S_FALSE if we don't have the focus.
**************************************************************************/

STDMETHODIMP P3P_Bar::HasFocusIO(void)
{
	if(m_bFocus)
		return S_OK;

	return S_FALSE;
}

/**************************************************************************
P3P_Bar::TranslateAcceleratorIO()

If the accelerator is translated, return S_OK or S_FALSE otherwise.
**************************************************************************/

STDMETHODIMP P3P_Bar::TranslateAcceleratorIO(LPMSG pMsg)
{
	return S_FALSE;
}

///////////////////////////////////////////////////////////////////////////
//
// IObjectWithSite implementations
//

STDMETHODIMP P3P_Bar::SetSite(IUnknown* punkSite)
{
	//If a site is being held, release it.
	if(m_pSite)
	{
		m_pSite->Release();
		m_pSite = NULL;
	}

	//If punkSite is not NULL, a new site is being set.
	if(punkSite)
	{
		if(_bd == NULL)
		{
			_threadId = GetCurrentThreadId();
			P3P_BrowserDriver* bd= P3P_BrowserDriver::GetInstance(_threadId);
			if(bd)
			{
				_bd = bd;
				bd->SetBar(this);
			}
			else
			{
				_barList.AddTail(this);
			}
		}

		//Get the parent window.
		IOleWindow  *pOleWindow;

		m_hwndParent = NULL;

		if(SUCCEEDED(punkSite->QueryInterface(IID_IOleWindow, (LPVOID*)&pOleWindow)))
		{
			pOleWindow->GetWindow(&m_hwndParent);
			pOleWindow->Release();
		}

		if(!m_hwndParent)
			return E_FAIL;

		if(!RegisterAndCreateWindow())
			return E_FAIL;

		//Get and keep the IInputObjectSite pointer.
		if(SUCCEEDED(punkSite->QueryInterface(IID_IInputObjectSite, (LPVOID*)&m_pSite)))
		{
			return S_OK;
		}

		return E_FAIL;
	}

	return S_OK;
}

STDMETHODIMP P3P_Bar::GetSite(REFIID riid, LPVOID *ppvReturn)
{
	*ppvReturn = NULL;

	if(m_pSite)
		return m_pSite->QueryInterface(riid, ppvReturn);

	return E_FAIL;
}

///////////////////////////////////////////////////////////////////////////
//
// IDeskBand implementation
//

STDMETHODIMP P3P_Bar::GetBandInfo(DWORD dwBandID, DWORD dwViewMode, DESKBANDINFO* pdbi)
{
	if(pdbi)
	{
		m_dwBandID = dwBandID;
		m_dwViewMode = dwViewMode;

		if(pdbi->dwMask & DBIM_MINSIZE)
		{
			pdbi->ptMinSize.x = 0;
			pdbi->ptMinSize.y = 32;
		}

		if(pdbi->dwMask & DBIM_MAXSIZE)
		{
			pdbi->ptMaxSize.x = -1;
			pdbi->ptMaxSize.y = 32;
		}

		if(pdbi->dwMask & DBIM_INTEGRAL)
		{
			pdbi->ptIntegral.x = 1;
			pdbi->ptIntegral.y = 1;
		}

		if(pdbi->dwMask & DBIM_ACTUAL)
		{
			pdbi->ptActual.x = 0;
			pdbi->ptActual.y = 0;
		}

		if(pdbi->dwMask & DBIM_TITLE)
		{
			lstrcpyW(pdbi->wszTitle, L"");
		}

		if(pdbi->dwMask & DBIM_MODEFLAGS)
		{
			pdbi->dwModeFlags = DBIMF_NORMAL;
		}

		if(pdbi->dwMask & DBIM_BKCOLOR)
		{
			//Use the default background color by removing this flag.
			pdbi->dwMask &= ~DBIM_BKCOLOR;
		}

		return S_OK;
	}

	return E_INVALIDARG;
}

///////////////////////////////////////////////////////////////////////////
//
// IPersistStream implementations
// 
// This is only supported to allow the desk band to be dropped on the 
// desktop and to prevent multiple instances of the desk band from showing 
// up in the context menu. This desk band doesn't actually persist any data.
//

STDMETHODIMP P3P_Bar::GetClassID(LPCLSID pClassID)
{
	*pClassID = CLSID_P3P_Bar;

	return S_OK;
}

STDMETHODIMP P3P_Bar::IsDirty(void)
{
	return S_FALSE;
}

STDMETHODIMP P3P_Bar::Load(LPSTREAM pStream)
{
	return S_OK;
}

STDMETHODIMP P3P_Bar::Save(LPSTREAM pStream, BOOL fClearDirty)
{
	return S_OK;
}

STDMETHODIMP P3P_Bar::GetSizeMax(ULARGE_INTEGER *pul)
{
	return E_NOTIMPL;
}

///////////////////////////////////////////////////////////////////////////
//
// IContextMenu Implementation
//

STDMETHODIMP P3P_Bar::QueryContextMenu( HMENU hMenu, UINT indexMenu, UINT idCmdFirst, UINT idCmdLast, UINT uFlags)
{
	if(!(CMF_DEFAULTONLY & uFlags))
	{
		InsertMenu(hMenu, indexMenu, MF_STRING | MF_BYPOSITION, idCmdFirst + IDM_COMMAND, "&Sample Comm Band Command");

		return MAKE_HRESULT(SEVERITY_SUCCESS, 0, USHORT(IDM_COMMAND + 1));
	}

	return MAKE_HRESULT(SEVERITY_SUCCESS, 0, USHORT(0));
}

STDMETHODIMP P3P_Bar::InvokeCommand(LPCMINVOKECOMMANDINFO lpcmi)
{
	switch (LOWORD(lpcmi->lpVerb))
	{
		case IDM_COMMAND:
			MessageBox(lpcmi->hwnd, TEXT("Comm Band Command selected."), TEXT("Sample Comm Band"), MB_OK | MB_ICONINFORMATION);
			break;

		default:
			return E_INVALIDARG;
	}

	return NOERROR;
}

STDMETHODIMP P3P_Bar::GetCommandString( UINT idCommand, UINT uFlags, UINT* lpReserved,
 LPSTR lpszName, UINT uMaxNameLen)
{
	HRESULT  hr = E_INVALIDARG;

	switch(uFlags)
	{
		case GCS_HELPTEXT:
			switch(idCommand)
			{
				case IDM_COMMAND:
					lstrcpy(lpszName, TEXT("Comm Band command help text"));
					hr = NOERROR;
					break;
			}
			break;

		case GCS_VERB:
			switch(idCommand)
			{
				case IDM_COMMAND:
					lstrcpy(lpszName, TEXT("command"));
					hr = NOERROR;
					break;
			}
			break;

		case GCS_VALIDATE:
			hr = NOERROR;
			break;
	}

	return hr;
}

///////////////////////////////////////////////////////////////////////////
//
// private method implementations
//
LRESULT CALLBACK P3P_Bar::WndProc(HWND hWnd, UINT uMessage, WPARAM wParam, LPARAM lParam)
{
	P3P_Bar  *pThis = (P3P_Bar*)GetWindowLong(hWnd, GWL_USERDATA);

	switch (uMessage)
	{
		case WM_NCCREATE:
			{
				LPCREATESTRUCT lpcs = (LPCREATESTRUCT)lParam;
				pThis = (P3P_Bar*)(lpcs->lpCreateParams);
				SetWindowLong(hWnd, GWL_USERDATA, (LONG)pThis);

				//set the window handle
				pThis->m_hWnd = hWnd;
			}
			break;

		case WM_PAINT:
			return pThis->OnPaint();

		case WM_COMMAND:
			return pThis->OnCommand(wParam, lParam);

		case WM_SETFOCUS:
			return pThis->OnSetFocus();

		case WM_KILLFOCUS:
			return pThis->OnKillFocus();
	}

	return DefWindowProc(hWnd, uMessage, wParam, lParam);
}

LRESULT P3P_Bar::OnPaint(void)
{
	PAINTSTRUCT ps;
	RECT  rc;

	//prepare for paint
	BeginPaint(m_hWnd, &ps);
	GetClientRect(m_hWnd, &rc);

	//bitmap related operations
	HDC bitmapDC = CreateCompatibleDC(ps.hdc);

	//display logo bitmap
	SelectObject(bitmapDC, _logo);
	BitBlt(ps.hdc, 0, 0, 104, 32, bitmapDC, 0, 0, SRCCOPY);

	//display status bitmap
	SelectObject(bitmapDC, _status);
	BitBlt(ps.hdc, 104, 0, 32, 32, bitmapDC, 0, 0, SRCCOPY);

	//display command bitmap1
	SelectObject(bitmapDC, _c_view);
	BitBlt(ps.hdc, 152, 0, 104, 32, bitmapDC, 0, 0, SRCCOPY);

	//display command bitmap2
	SelectObject(bitmapDC, _c_check);
	BitBlt(ps.hdc, 256, 0, 104, 32, bitmapDC, 0, 0, SRCCOPY);

	DeleteDC(bitmapDC);
	EndPaint(m_hWnd, &ps);

	return 0;
}

LRESULT P3P_Bar::OnCommand(WPARAM wParam, LPARAM lParam)
{
	return 0;
}

void P3P_Bar::FocusChange(BOOL bFocus)
{
	m_bFocus = bFocus;

	//inform the input object site that the focus has changed
	if(m_pSite)
	{
		m_pSite->OnFocusChangeIS((IDockingWindow*)this, bFocus);
	}
}

LRESULT P3P_Bar::OnSetFocus(void)
{
	FocusChange(TRUE);
	return 0;
}

LRESULT P3P_Bar::OnKillFocus(void)
{
	FocusChange(FALSE);
	return 0;
}

BOOL P3P_Bar::RegisterAndCreateWindow(void)
{
	//If the window doesn't exist yet, create it now.
	if(!m_hWnd)
	{
		//Can't create a child window without a parent.
		if(!m_hwndParent)
		{
			return FALSE;
		}

		//If the window class has not been registered, then do so.
		WNDCLASS wc;
		if(!GetClassInfo(g_hInst, BV_CLASS_NAME, &wc))
		{
			ZeroMemory(&wc, sizeof(wc));
			wc.style = CS_HREDRAW | CS_VREDRAW | CS_GLOBALCLASS;
			wc.lpfnWndProc = (WNDPROC)WndProc;
			wc.cbClsExtra  = 0;
			wc.cbWndExtra  = 0;
			wc.hInstance= g_hInst;
			wc.hIcon = NULL;
			wc.hCursor  = LoadCursor(NULL, IDC_ARROW);
			wc.hbrBackground  = (HBRUSH)CreateSolidBrush(RGB(204, 204, 255));
			wc.lpszMenuName= NULL;
			wc.lpszClassName  = BV_CLASS_NAME;

			if(!RegisterClass(&wc))
			{
				//If RegisterClass fails, CreateWindow below will fail.
			}
		}

		RECT  rc;

		GetClientRect(m_hwndParent, &rc);

		//Create the window. The WndProc will set m_hWnd.
		CreateWindowEx(0,
			BV_CLASS_NAME,
			NULL,
			WS_CHILD | WS_CLIPSIBLINGS,
			rc.left,
			rc.top,
			rc.right - rc.left,
			rc.bottom - rc.top,
			m_hwndParent,
			NULL,
			g_hInst,
			(LPVOID)this);
	}

	return (NULL != m_hWnd);
}

P3P_Bar* P3P_Bar::GetInstance(DWORD threadId)
{
	POSITION pos = _barList.GetHeadPosition();
	while(pos)
	{
		POSITION pos2 = pos;
		P3P_Bar* bar = _barList.GetNext(pos);
		if(bar->_threadId == threadId)
		{
			_barList.RemoveAt(pos2);
			return bar;
		}
	}
	return NULL;
}

void P3P_Bar::ShowPageStatus(P3P_Match* match)
{
	if(IsEqual(match->Behavior, P3Ps_B_ACCEPT))
	{
		_status = _s_accept;
	}
	else if(IsEqual(match->Behavior,  P3Ps_B_INFORM))
	{
		_status = _s_prompt;
	}
	else if(IsEqual(match->Behavior, P3Ps_B_WARN))
	{
		_status = _s_prompt;
	}
	else if(IsEqual(match->Behavior, P3Ps_B_REJECT))
	{
		_status = _s_reject;
	}
	else
	{
		_status = _s_unknown;
	}
	InvalidateRect(m_hWnd, CRect(104, 0, 136, 32), FALSE);
}
