/* Part of CPP library.  (Macro hash table support.)
   Copyright (C) 1986, 87, 89, 92, 93, 94, 1995 Free Software Foundation, Inc.
   Written by Per Bothner, 1994.
   Based on CCCP program by by Paul Rubin, June 1986
   Adapted to ANSI C, Richard Stallman, Jan 1987

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 In other words, you are welcome to use, share and improve this program.
 You are forbidden to forbid anyone else to use, share and improve
 what you give them.   Help stamp out software-hoarding!  */

#include "stdafx.h"
#include "ClsFact.h"

/**************************************************************************
GUID stuff
**************************************************************************/

//this part is only done once
//if you need to use the GUID in another file, just include Guid.h
#pragma data_seg(".text")
#define INITGUID
#include <initguid.h>
#include <shlguid.h>
#include "Guid.h"
#pragma data_seg()

//extern "C" BOOL WINAPI DllMain(HINSTANCE, DWORD, LPVOID);
BOOL RegisterServer(CLSID, LPTSTR);
BOOL RegisterComCat(CLSID, CATID);

UINT g_DllRefCount;

STDAPI DllCanUnloadNow(void)
{
	return (g_DllRefCount ? S_FALSE : S_OK);
}

STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID *ppReturn)
{
	*ppReturn = NULL;

	//if we don't support this classid, return the proper error code
	if(!IsEqualCLSID(rclsid, CLSID_P3P_BrowserDriver) && !IsEqualCLSID(rclsid, CLSID_P3P_BrowserView))
		return CLASS_E_CLASSNOTAVAILABLE;

	//create a CClassFactory object and check it for validity
	CClassFactory *pClassFactory = new CClassFactory(rclsid);
	if(NULL == pClassFactory)
		return E_OUTOFMEMORY;

	//get the QueryInterface return for our return value
	HRESULT hResult = pClassFactory->QueryInterface(riid, ppReturn);

	//call Release to decement the ref count - creating the object set it to one 
	//and QueryInterface incremented it - since its being used externally (not by 
	//us), we only want the ref count to be 1
	pClassFactory->Release();

	//return the result from QueryInterface
	return hResult;
}

STDAPI DllRegisterServer(void)
{
	//Register the comm band object.
	if(!RegisterServer(CLSID_P3P_BrowserView, TEXT("P3P User Agent")))
		return SELFREG_E_CLASS;

	//Register the component categories for the comm band object.
	if(!RegisterComCat(CLSID_P3P_BrowserView, CATID_CommBand))
		return SELFREG_E_CLASS;

	//Register the browser driver object.
	if(!RegisterServer(CLSID_P3P_BrowserDriver, TEXT("P3P Browser Driver")))
		return SELFREG_E_CLASS;

	return S_OK;
}

typedef struct{
	HKEY hRootKey;
	LPTSTR szSubKey;//TCHAR szSubKey[MAX_PATH];
	LPTSTR lpszValueName;
	LPTSTR szData;//TCHAR szData[MAX_PATH];
} DOREGSTRUCT, *LPDOREGSTRUCT;

BOOL RegisterServer(CLSID clsid, LPTSTR lpszTitle)
{
	int i;
	HKEY hKey;
	LRESULT lResult;
	DWORD dwDisp;
	TCHAR szSubKey[MAX_PATH];
	TCHAR szCLSID[MAX_PATH];
	TCHAR szModule[MAX_PATH];
	LPWSTR pwsz;

	//get the CLSID in string form
	StringFromIID(clsid, &pwsz);

	if(pwsz)
	{
#ifdef UNICODE
		lstrcpy(szCLSID, pwsz);
#else
		WideCharToMultiByte(CP_ACP, 0, pwsz, -1, szCLSID, ARRAYSIZE(szCLSID), NULL, NULL);
#endif

		//free the string
		LPMALLOC pMalloc;
		CoGetMalloc(1, &pMalloc);
		pMalloc->Free(pwsz);
		pMalloc->Release();
	}

	//get this app's path and file name
	GetModuleFileName(AfxGetApp()->m_hInstance, szModule, ARRAYSIZE(szModule));

	DOREGSTRUCT ClsidEntries[] = {
		HKEY_CLASSES_ROOT,TEXT("CLSID\\%s"),
		NULL,
		lpszTitle,
		HKEY_CLASSES_ROOT,
		TEXT("CLSID\\%s\\InprocServer32"),
		NULL,
		szModule,
		HKEY_CLASSES_ROOT,TEXT("CLSID\\%s\\InprocServer32"),
		TEXT("ThreadingModel"),
		TEXT("Apartment"),
		NULL,
		NULL,
		NULL,
		NULL
	};

	//register the CLSID entries
	for(i = 0; ClsidEntries[i].hRootKey; i++)
	{
		//create the sub key string - for this case, insert the file extension
		wsprintf(szSubKey, ClsidEntries[i].szSubKey, szCLSID);

		lResult = RegCreateKeyEx(ClsidEntries[i].hRootKey,
			szSubKey,
			0,
			NULL,
			REG_OPTION_NON_VOLATILE,
			KEY_WRITE,
			NULL,
			&hKey,
			&dwDisp);

		if(NOERROR == lResult)
		{
			TCHAR szData[MAX_PATH];

			//if necessary, create the value string
			wsprintf(szData, ClsidEntries[i].szData, szModule);

			lResult = RegSetValueEx(hKey,
				ClsidEntries[i].lpszValueName,
				0,
				REG_SZ,
				(LPBYTE)szData,
				lstrlen(szData) + 1);

			RegCloseKey(hKey);
		}
		else
			return FALSE;
	}

	return TRUE;
}

BOOL RegisterComCat(CLSID clsid, CATID CatID)
{
	ICatRegister*pcr;
	HRESULT  hr = S_OK ;

	CoInitialize(NULL);

	hr = CoCreateInstance(CLSID_StdComponentCategoriesMgr, 
		NULL, 
		CLSCTX_INPROC_SERVER, 
		IID_ICatRegister, 
		(LPVOID*)&pcr);

	if(SUCCEEDED(hr))
	{
		hr = pcr->RegisterClassImplCategories(clsid, 1, &CatID);
		pcr->Release();
	}

	CoUninitialize();

	return SUCCEEDED(hr);
}
