# package.make
# $Id: package.make,v 1.7 1999/04/01 14:13:38 ylafon Exp $
# COPYRIGHT

# This makefile should be included in all packages Makefiles. To use it, define
# the PACKAGES variable to the set of packages defined in your directory,
# and the PACKAGE variable to this package name.
# So, if you have a 'foo' package, included in 'w3c' and containing 'bar1'
# and 'bar2' sub packages, your Makefile should look like this:
# ----------
# PACKAGE=w3c.foo
# PACKAGES=bar1 bar2
# TOP=../..
# include $(TOP)/makefiles/package.make
# ----------
#
# This make file defines the following targets:
# all:	 to build the class files from the java files.
# clean: to clean all sub packages
# doc:   to build the appropriate documentation files from the source
# The 'doc' target uses DESTDIR variable that should point to the absolute 
# path of the target directory (in which doc files will be created).

all::
	@@for p in $(PACKAGES); do \
		echo 'building ' $(PACKAGE).$$p; \
		if [ -z "$(TARGET)" ]; then \
			(cd $$p; make); \
		else \
			(cd $$p; make VPATH=$(VPATH)/$$p); \
		fi \
	done

jigsaw::
	@@for p in $(JIGSAWPACKAGES); do \
		echo 'building ' $(PACKAGE).$$p; \
		if [ -z "$(TARGET)" ]; then \
			(cd $$p; make MAKEDIR=$(MAKEDIR) jigsaw ); \
		else \
			(cd $$p; make MAKEDIR=$(MAKEDIR) VPATH=$(VPATH)/$$p jigsaw); \
		fi \
	done

dumpjigsawpackages::
	@@for p in $(JIGSAWPACKAGES); do \
		(cd $$p ; make MAKEDIR=$(MAKEDIR) dumpjigsawpackages); \
	done

test::
	@@for p in $(JIGSAWPACKAGES); do \
		(cd $$p ; make MAKEDIR=$(MAKEDIR) test); \
	done

doc::
	@@for p in $(PACKAGES); do \
		echo 'doc ' $(PACKAGE).$$p; \
		(cd $$p; make DESTDIR=$(DESTDIR) doc); \
	done

clean::
	@@for p in $(PACKAGES); do \
		echo 'cleaning ' $(PACKAGE).$$p; \
		(cd $$p ; make clean) ; \
	done

jigsawtag::
	@@if [ "" != "$(TAG)" ]; then \
		echo 'Tagging in package ' $(PACKAGE).$$p; \
		for p in $(JIGSAWPACKAGES); do \
			(cd $$p; make MAKEDIR=$(MAKEDIR) TAG=$(TAG) jigsawtag); \
		done ;\
		cvs tag $(TAG) Makefile; \
	else \
		echo 'set the TAG variable!'; \
	fi
