// StatisticsFrame.java
// $Id: StatisticsFrame.java,v 1.5 1998/03/18 10:13:26 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.status ;

import java.util.* ;

import org.w3c.tools.resources.*;
import org.w3c.www.http.*;
import org.w3c.jigsaw.frames.*;
import org.w3c.jigsaw.http.*;
import org.w3c.jigsaw.html.*;

/**
 * This class exports the server statistics.
 * It makes available a bunch of various parameters about the current
 * server, and uses the Refresh meta-tag (as the ThreadStat) to 
 * make them redisplay.
 * <p>This would benefit from being an applet.
 */

public class StatisticsFrame extends HTTPFrame {
  protected static Integer REFRESH_DEFAULT = new Integer(5) ;

  /**
   * Attribute index - Our refresh interval.
   */
  protected static int ATTR_REFRESH = -1 ;
    
  static {
    Attribute a   = null ;
    Class     cls = null ;
    try {
      cls = Class.forName("org.w3c.jigsaw.status.StatisticsFrame");
    } catch (Exception ex) {
      ex.printStackTrace() ;
      System.exit(1) ;
    }
    // The refresh interval attribute:
    a = new IntegerAttribute("refresh"
			     , new Integer(5)
			     , Attribute.EDITABLE) ;
    ATTR_REFRESH = AttributeRegistry.registerAttribute(cls, a) ;
  }

  static String time_tbl = ("<p>Request processing times:"
			    + "<table border width=50%><tr>"
			    + "<th align=\"center\">min"
			    + "<th align=\"center\">avg"
			    + "<th align=\"center\">max"
			    + "</tr><tr>") ;
  static String thread_tbl = ("<p>Thread counts:"
			      + "<table border width=50%><tr>"
			      + "<th align=\"center\">free"
			      + "<th align=\"center\">idle"
			      + "<th align=\"center\">total"
			      + "</tr><tr>");

  public void registerResource(FramedResource resource) {
    super.registerOtherResource(resource);
  }
				
  /**
   * Get the current set of statistics.
   * Display the collected statistics in an HTML table.
   * @param request TYhe request to process.
   */

  public Reply get (Request request) {
    HtmlGenerator g = new HtmlGenerator("Statistics") ;
    g.meta("Refresh", getValue(ATTR_REFRESH, REFRESH_DEFAULT).toString());
    addStyleSheet(g);
    // Dump the statistics:
    httpdStatistics stats = ((httpd)getServer()).getStatistics() ;
    // Uptime:
    g.append("<h1>Server statistics</h1>");
    long start_time = stats.getStartTime();
    long uptime     = (System.currentTimeMillis() - start_time) / 1000;
    g.append("<p>Your server was started on ");
    g.append(new Date(start_time).toString());
    long duptime = uptime / (3600L*24L);
    long htemp   = uptime % (3600L*24L);
    long huptime = htemp / 3600L;
    long mtemp   = htemp % 3600L;
    long muptime = mtemp / 60L;
    long suptime = mtemp % 60L;
    g.append("<p>It has now been running for "+
	     duptime + " days, "+
	     huptime + " hours, "+
	     muptime + " minutes and "+
	     suptime + " seconds.");
    // Hits and bytes:
    g.append("<ul><li>hits:", Long.toString(stats.getHitCount()));
    g.append("<li>bytes:", Long.toString(stats.getEmittedBytes()));
    g.append("</ul>");
    // Request times:
    g.append(time_tbl) ;
    g.append("<th align=\"center\">"
	     , Long.toString(stats.getMinRequestTime())
	     , " ms") ;
    g.append("<th align=\"center\">"
	     , Long.toString(stats.getMeanRequestTime())
	     , " ms") ;
    g.append("<th align=\"center\">"
	     , Long.toString(stats.getMaxRequestTime())
	     , " ms");
    g.append("</table>") ;
    // Thread report:
    g.append(thread_tbl) ;
    g.append("<th align=\"center\">"
	     , Integer.toString(stats.getFreeThreadCount())) ;
    g.append("<th align=\"center\">"
	     , Integer.toString(stats.getIdleThreadCount())) ;
    g.append("<th align=\"center\">"
	     , Integer.toString(stats.getTotalThreadCount()));
    g.append("</table>") ;
    g.append("<p>Current load:"+stats.getServerLoad());
    Reply reply = request.makeReply(HTTP.OK) ;
    reply.setStream (g) ;
    return reply ;
  }

}

