// NoSearchMapEntry.java
// $Id: NoSearchMapEntry.java,v 1.5 1998/02/19 10:48:28 bmahe Exp $
// (c) COPYRIGHT MIT and INRIA, 1996.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.jigsaw.map ;

import java.io.*;

class NoSearchMapEntry extends MapEntry {
    public NoSearchMapEntry()
    {
	// nil 
    }

    // Shouldn't be called, but just in case:
    public boolean matches(Point p)
    {
	return true;
    }

    protected void unpickleRest(DataInputStream in)
    {
	// nil
    }
    
    public void pickle(DataOutputStream out)
	throws IOException
    {
	super.pickle(out);
	out.writeInt(NOSEARCH);
    }

    protected final void parseRestNCSA(String line)
	throws MapException
    {
	URL = line.trim();
	if(URL.equals(""))
	    throw new MapException("missing nosearch URL");
    }

    protected final void parseRestW3C(String line)
	throws MapException
    {
	parseRestNCSA(line);
    }
}
