/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.ResourceCell;
import org.w3c.jigadmin.editors.ResourceCellRenderer;
import org.w3c.jigadmin.editors.ResourceTreeBrowser;
import org.w3c.jigadmin.editors.ServerHelperInterface;
import org.w3c.jigadmin.events.ResourceActionEvent;
import org.w3c.jigadmin.events.ResourceActionListener;
import org.w3c.jigadmin.widgets.DraggableList;
import org.w3c.tools.sorter.Sorter;

public class SpaceServerHelper
extends JDesktopPane
implements ServerHelperInterface,
ResourceActionListener {
    protected String name = null;
    protected String tooltip = null;
    protected RemoteResourceWrapper root = null;
    protected ResourceTreeBrowser tree = null;
    protected JTabbedPane tabbedPane = null;
    protected JScrollPane treeview = null;
    protected JInternalFrame iframe = null;

    protected void build() {
        this.setOpaque(false);
        this.tree = this.getTreeBrowser();
        this.treeview = new JScrollPane(this.tree);
        this.add((Component)this.treeview, JLayeredPane.FRAME_CONTENT_LAYER);
        this.treeview.setLocation(10, 10);
        this.treeview.setBorder(BorderFactory.createBevelBorder(1));
        this.iframe = this.getInternalFrame();
        this.add((Component)this.iframe, JLayeredPane.PALETTE_LAYER);
    }

    public Component getComponent() {
        return this;
    }

    protected JInternalFrame getInternalFrame() {
        Object object;
        Object object2;
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        JInternalFrame jInternalFrame = new JInternalFrame("Available Resources", true, false, true, true);
        this.tabbedPane = new JTabbedPane();
        Hashtable hashtable = propertyManager.getResources();
        Enumeration enumeration = Sorter.sortStringEnumeration(hashtable.keys()).elements();
        Vector<Object> vector = new Vector<Object>(10);
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = new ResourceCell((String)object2, (String)hashtable.get(object2));
            vector.addElement(object);
        }
        object2 = this.getResourceList(vector);
        object = new JScrollPane((Component)object2);
        this.tabbedPane.addTab("Resources", null, (Component)object, "Resources available");
        hashtable = propertyManager.getFrames();
        enumeration = Sorter.sortStringEnumeration(hashtable.keys()).elements();
        vector = new Vector(10);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ResourceCell resourceCell = new ResourceCell(string, (String)hashtable.get(string));
            vector.addElement(resourceCell);
        }
        object2 = this.getResourceList(vector);
        object = new JScrollPane((Component)object2);
        this.tabbedPane.addTab("Frames", null, (Component)object, "Frames and Filters available");
        jInternalFrame.getContentPane().add(this.tabbedPane);
        jInternalFrame.setSize(350, 410);
        return jInternalFrame;
    }

    public String getName() {
        return this.name;
    }

    protected DraggableList getResourceList(Vector vector) {
        DraggableList draggableList = new DraggableList(vector);
        draggableList.setCellRenderer(new ResourceCellRenderer());
        return draggableList;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    protected ResourceTreeBrowser getTreeBrowser() {
        return ResourceTreeBrowser.getResourceTreeBrowser(this.root, "Root");
    }

    public void initialize(String string, RemoteResourceWrapper remoteResourceWrapper, Properties properties) {
        this.name = string;
        this.root = remoteResourceWrapper;
        this.tooltip = (String)((Hashtable)properties).get("tooltip");
        this.build();
    }

    public void resourceActionPerformed(ResourceActionEvent resourceActionEvent) {
        this.tree.resourceActionPerformed(resourceActionEvent);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.updateLayout(n3, n4);
        super.setBounds(n, n2, n3, n4);
    }

    protected void updateLayout(int n, int n2) {
        int n3 = 5 * n / 12;
        this.treeview.setLocation(10, 10);
        this.treeview.setSize(n3, n2 - 20);
        int n4 = this.iframe.getLocation().x;
        int n5 = 20 + n3;
        if (n4 < n5) {
            this.iframe.setLocation(n5, 10);
        }
    }
}

