/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.MiniBrowser;
import org.w3c.jigadmin.editors.ServerHelperInterface;
import org.w3c.jigadmin.events.ResourceActionEvent;
import org.w3c.jigadmin.events.ResourceActionListener;
import org.w3c.jigadmin.events.ResourceActionSource;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigadmin.widgets.Icons;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.widgets.Utilities;

public class ControlServerHelper
extends JToolBar
implements ServerHelperInterface,
ResourceActionSource {
    protected RemoteResourceWrapper control = null;
    protected Vector listeners = null;
    protected String name = null;
    protected String tooltip = null;
    protected static final String SAVE_A = "save";
    protected static final String STOP_A = "stop";
    protected static final String HELP_A = "help";
    protected static final String DELE_A = "del";
    protected static final String ADD_A = "add";
    protected static final String REIN_A = "reindx";
    protected static final String REFE_A = "reference";
    protected static final String EDIT_A = "edit";
    protected String saveBTT = null;
    protected String stopBTT = null;
    protected String helpBTT = null;
    protected String deleBTT = null;
    protected String addBTT = null;
    protected String reinBTT = null;
    protected String refeBTT = null;
    protected String editBTT = null;
    boolean res_op_enabled = true;
    boolean built = false;
    ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            ControlServerHelper.this.control.getServerBrowser().setCursor(3);
            if (string.equals(ControlServerHelper.HELP_A)) {
                try {
                    String string2 = (String)ControlServerHelper.this.control.getResource().getValue("help-url");
                    MiniBrowser.showDocumentationURL(string2, "Documentation");
                }
                catch (RemoteAccessException remoteAccessException) {
                    remoteAccessException.printStackTrace();
                }
                catch (Exception exception) {}
            } else if (string.equals(ControlServerHelper.DELE_A)) {
                ControlServerHelper.this.fireResourceEvent(10);
            } else if (string.equals(ControlServerHelper.ADD_A)) {
                ControlServerHelper.this.fireResourceEvent(20);
            } else if (string.equals(ControlServerHelper.STOP_A)) {
                ControlServerHelper.this.fireResourceEvent(50);
                try {
                    ControlServerHelper.this.control.getChildResource(actionEvent.getActionCommand());
                }
                catch (RemoteAccessException remoteAccessException) {
                    Message.showErrorMessage((Component)ControlServerHelper.this, remoteAccessException);
                }
            } else if (string.equals(ControlServerHelper.SAVE_A)) {
                ControlServerHelper.this.fireResourceEvent(40);
                try {
                    ControlServerHelper.this.control.getChildResource(actionEvent.getActionCommand());
                }
                catch (RemoteAccessException remoteAccessException) {
                    Message.showErrorMessage((Component)ControlServerHelper.this, remoteAccessException);
                }
            } else if (string.equals(ControlServerHelper.REIN_A)) {
                ControlServerHelper.this.fireResourceEvent(30);
            } else if (string.equals(ControlServerHelper.REFE_A)) {
                ControlServerHelper.this.fireResourceEvent(60);
            } else if (string.equals(ControlServerHelper.EDIT_A)) {
                ControlServerHelper.this.fireResourceEvent(70);
            }
            ControlServerHelper.this.control.getServerBrowser().setCursor(0);
        }
    };

    public ControlServerHelper() {
        super(0);
    }

    public void addResourceActionListener(ResourceActionListener resourceActionListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(1);
        }
        this.listeners.addElement(resourceActionListener);
    }

    protected void build() {
        JButton jButton = (JButton)this.add(new JButton(Icons.saveIcon));
        if (this.saveBTT == null) {
            this.saveBTT = "Save the configuration";
        }
        jButton.setToolTipText(this.saveBTT);
        jButton.setMargin(Utilities.insets0);
        jButton.setActionCommand(SAVE_A);
        jButton.addActionListener(this.al);
        this.addSeparator(Utilities.dim3_3);
        JButton jButton2 = (JButton)this.add(new JButton(Icons.stopIcon));
        if (this.stopBTT == null) {
            this.stopBTT = "Stop the server";
        }
        jButton2.setToolTipText(this.stopBTT);
        jButton2.setMargin(Utilities.insets0);
        jButton2.setActionCommand(STOP_A);
        jButton2.addActionListener(this.al);
        if (this.res_op_enabled) {
            this.addSeparator(Utilities.dim10_10);
            JButton jButton3 = (JButton)this.add(new JButton(Icons.reindexIcon));
            if (this.reinBTT == null) {
                this.reinBTT = "Reindex children of selected Container(s)";
            }
            jButton3.setToolTipText(this.reinBTT);
            jButton3.setMargin(Utilities.insets0);
            jButton3.setActionCommand(REIN_A);
            jButton3.addActionListener(this.al);
            this.addSeparator(Utilities.dim3_3);
            JButton jButton4 = (JButton)this.add(new JButton(Icons.addIcon));
            if (this.addBTT == null) {
                this.addBTT = "Add a resource to the selected Container";
            }
            jButton4.setToolTipText(this.addBTT);
            jButton4.setMargin(Utilities.insets0);
            jButton4.setActionCommand(ADD_A);
            jButton4.addActionListener(this.al);
            this.addSeparator(Utilities.dim3_3);
            JButton jButton5 = (JButton)this.add(new JButton(Icons.deleteIcon));
            if (this.deleBTT == null) {
                this.deleBTT = "Delete selected resources";
            }
            jButton5.setToolTipText(this.deleBTT);
            jButton5.setMargin(Utilities.insets0);
            jButton5.setActionCommand(DELE_A);
            jButton5.addActionListener(this.al);
            this.addSeparator(Utilities.dim3_3);
            JButton jButton6 = (JButton)this.add(new JButton(Icons.editIcon));
            if (this.editBTT == null) {
                this.editBTT = "Edit selected resource";
            }
            jButton6.setToolTipText(this.editBTT);
            jButton6.setMargin(Utilities.insets0);
            jButton6.setActionCommand(EDIT_A);
            jButton6.addActionListener(this.al);
            this.addSeparator(Utilities.dim10_10);
            JButton jButton7 = (JButton)this.add(new JButton(Icons.infoIcon));
            if (this.refeBTT == null) {
                this.refeBTT = "Show reference documentation of selected resource";
            }
            jButton7.setToolTipText(this.refeBTT);
            jButton7.setMargin(Utilities.insets0);
            jButton7.setActionCommand(REFE_A);
            jButton7.addActionListener(this.al);
            this.addSeparator(Utilities.dim3_3);
            JButton jButton8 = (JButton)this.add(new JButton(Icons.helpIcon));
            if (this.helpBTT == null) {
                this.helpBTT = "Show documentation";
            }
            jButton8.setToolTipText(this.helpBTT);
            jButton8.setMargin(Utilities.insets0);
            jButton8.setActionCommand(HELP_A);
            jButton8.addActionListener(this.al);
        }
        this.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
        this.built = true;
    }

    protected void fireResourceEvent(int n) {
        if (this.listeners == null) {
            return;
        }
        ResourceActionEvent resourceActionEvent = new ResourceActionEvent(this, n);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ((ResourceActionListener)this.listeners.elementAt(n2)).resourceActionPerformed(resourceActionEvent);
            ++n2;
        }
    }

    public Component getComponent() {
        if (!this.built) {
            this.build();
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public void initialize(String string, RemoteResourceWrapper remoteResourceWrapper, Properties properties) {
        this.control = remoteResourceWrapper;
        this.name = string;
        this.tooltip = (String)((Hashtable)properties).get("tooltip");
    }

    public void removeResourceActionListener(ResourceActionListener resourceActionListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(resourceActionListener);
    }

    public void setAddToolTipText(String string) {
        this.addBTT = string;
    }

    public void setDeleteToolTipText(String string) {
        this.deleBTT = string;
    }

    public void setEditToolTipText(String string) {
        this.editBTT = string;
    }

    public void setHelpToolTipText(String string) {
        this.helpBTT = string;
    }

    public void setReferenceToolTipText(String string) {
        this.refeBTT = string;
    }

    public void setReindexToolTipText(String string) {
        this.reinBTT = string;
    }

    public void setResOpEnabled(boolean bl) {
        this.res_op_enabled = bl;
    }

    public void setSaveToolTipText(String string) {
        this.saveBTT = string;
    }

    public void setStopToolTipText(String string) {
        this.stopBTT = string;
    }
}

