<!-- generate-translate-decorator.xsl, part of ITS Translate Decorator 0.2
For documentation, see http://www.w3.org/International/its/wiki/ITS_Translate_Decorator

 -->
<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:XSL="http://www.w3.org/1999/XSL/TransformAlias" exclude-result-prefixes="xsl" version="1.0">
  <xsl:param name="rules">rules.xml</xsl:param>
  <xsl:output method="xml" encoding="utf-8" indent="yes"/>
  <xsl:namespace-alias stylesheet-prefix="XSL" result-prefix="xsl"/>

  <xsl:template match="/">
    <!-- General structure of intermediate stylesheet -->
    <XSL:stylesheet version="1.0" xmlns:its="http://www.w3.org/2005/11/its"
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
      <XSL:output method="xml" encoding="utf-8"/>
      <XSL:template match="/">
        <XSL:apply-templates mode="Translate" select="@* | node()">
          <XSL:with-param name="existingValue">yes</XSL:with-param>
        </XSL:apply-templates>
      </XSL:template>
      <!-- Writing various kinds of tests for ITS "Translate" information -->
      <xsl:call-template name="localMarkupTemplate"/>
      <xsl:call-template name="recursionTemplate"/>
      <xsl:call-template name="globalRulesTemplate"/>
    </XSL:stylesheet>
  </xsl:template>

  <!-- For each "Translate" rule available, we write a template-->
  <xsl:template name="globalRulesTemplate">
    <xsl:for-each select="document($rules)//its:translateRule">
      <xsl:variable name="value">
        <xsl:text>'</xsl:text>
        <xsl:value-of select="@translate"/>
        <xsl:text>'</xsl:text>
      </xsl:variable>
      <XSL:template match="{./@selector}" mode="Translate">
        <xsl:variable name="currentRuleEl" select="."/>
        <xsl:for-each select="namespace::*
          [not(.='http://www.w3.org/XML/1998/namespace')]">
          <xsl:variable name="ns">
            <xsl:value-of select="."/>
          </xsl:variable>          
          <xsl:variable name="nsprefix">
            <xsl:value-of select="name()"/>
          </xsl:variable>
          <xsl:variable name="no">
            <xsl:number/>
          </xsl:variable>
          <xsl:attribute 
            name="{concat($nsprefix,':','dummy_for_its_',$no)}"             
            namespace="{$ns}">
            <xsl:value-of select="$ns"/>
          </xsl:attribute>
           </xsl:for-each>
         <xsl:attribute name="priority">
          <xsl:number/>
        </xsl:attribute>
        <XSL:variable name="value" select="{$value}"/>
        <!--     Different processing for elements and attributes below  -->
        <XSL:choose>
          <XSL:when test="self::*">
            <XSL:copy>
              <XSL:attribute name="itsTve">
                <XSL:value-of select="$value"/>
              </XSL:attribute>
              <XSL:apply-templates select="@* | node()" mode="Translate">
                <XSL:with-param name="existingValue">
                  <XSL:value-of select="$value"/>
                </XSL:with-param>
              </XSL:apply-templates>
            </XSL:copy>
          </XSL:when>
          <XSL:otherwise>
            <XSL:copy/>
            <XSL:if test="$value='yes'">
              <XSL:variable name="attrval">
                <XSL:text>transval-attr-</XSL:text>
                <XSL:value-of select="generate-id()"/>
              </XSL:variable>
              <XSL:attribute name="{{$attrval}}">
                <XSL:value-of select="name()"/>
              </XSL:attribute>
            </XSL:if>
          </XSL:otherwise>
          </XSL:choose> 
      </XSL:template>
    </xsl:for-each>
  </xsl:template>

  <!-- Template for local "its:translate" attribute -->
  <xsl:template name="localMarkupTemplate">
    <XSL:template match="*[@its:translate] | its:span[@translate]" priority="1000" mode="Translate">
      <XSL:copy>
        <XSL:attribute name="itsTve">
          <XSL:value-of select="@its:translate | self::its:span/@translate"/>
        </XSL:attribute>
        <XSL:apply-templates select="@* | node()" mode="Translate">
          <XSL:with-param name="existingValue">
            <XSL:value-of select="@its:translate | self::its:span/@translate"/>
          </XSL:with-param>
        </XSL:apply-templates>
      </XSL:copy>
    </XSL:template>
  </xsl:template>

  <!-- Templates for elements and attributes which don't match anything -->
  <xsl:template name="recursionTemplate">
    <XSL:template match="*" priority="-1000" mode="Translate">
      <XSL:param name="existingValue">yes</XSL:param>
      <XSL:copy>
        <XSL:attribute name="itsTve">
          <XSL:choose>
            <XSL:when test="$existingValue='yes'">yes</XSL:when>
            <XSL:otherwise>no</XSL:otherwise>
          </XSL:choose>
        </XSL:attribute>
        <XSL:apply-templates select="@* | node()" mode="Translate">
          <XSL:with-param name="existingValue">
            <XSL:value-of select="$existingValue"/>
          </XSL:with-param>
        </XSL:apply-templates>
      </XSL:copy>
    </XSL:template>
    <XSL:template match="@*" priority="-1000" mode="Translate">
      <XSL:copy/>
    </XSL:template>
  </xsl:template>

</xsl:stylesheet>
