<!-- gather-attributes.xsl, part of ITS Translate Decorator 0.2
For documentation, see http://www.w3.org/International/its/wiki/ITS_Translate_Decorator

 -->
<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:XSL="http://www.w3.org/1999/XSL/TransformAlias"
 xmlns:itd="http://www.w3.org/International/its/wiki/ITS_Translate_Decorator"
 xmlns:xlink="http://www.w3.org/1999/xlink"
 exclude-result-prefixes="xsl its xlink" version="1.0">

 <xsl:output method="xml" indent="yes" encoding="utf-8"/>
 <xsl:strip-space elements="*"/>
 <xsl:template match="@*">
 <xsl:copy/>
 </xsl:template>
<!-- For each element with translatable attributes, 
 attach an itsTva attribute which contains the names of these attributes.-->
<xsl:template match="*[@*[starts-with(name(),'transval-attr-')]]">
<xsl:copy>
<xsl:attribute name="itsTva">
<xsl:for-each select="@*[starts-with(name(),'transval-attr-')]">
<xsl:value-of select="concat('#',.,'#')"/>
</xsl:for-each>
</xsl:attribute>
<xsl:apply-templates select="node() | @*[not(starts-with(name(),'transval-attr-'))]"/>
</xsl:copy>
</xsl:template>
<xsl:template match="*">
 <xsl:copy>  
  <xsl:apply-templates select="node() | @*"/>
 </xsl:copy>
</xsl:template>
</xsl:stylesheet>
