<!-- generate-withintext-decorator.xsl 0.1
For documentation, see http://www.w3.org/International/its/wiki/ITS_Translate_Decorator

 -->
<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:XSL="http://www.w3.org/1999/XSL/TransformAlias"
		exclude-result-prefixes="xsl" version="2.0">

  <xsl:output method="xml" encoding="utf-8"/>
  <xsl:strip-space elements="*"/>
  <xsl:namespace-alias stylesheet-prefix="XSL" result-prefix="xsl"/>
  <xsl:param name="inputDoc">none</xsl:param>
  <xsl:param name="externalRules">none</xsl:param>
  <xsl:variable name="XMLInput" select="doc($inputDoc)" as="node()*"/>

  <xsl:template match="/">
<!-- General structure of intermediate stylesheet -->
    <XSL:stylesheet version="2.0" xmlns:its="http://www.w3.org/2005/11/its"
		    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
      <XSL:output method="xml" encoding="utf-8"/>
      <XSL:strip-space elements="*"/>
      <XSL:template match="/">
	<XSL:apply-templates mode="withinText" select="@* | node()"/>
      </XSL:template>
<!-- Writing various kinds of tests for ITS "Within Text" information -->
      <xsl:call-template name="recursionTemplate"/>
      <xsl:call-template name="globalRulesTemplate"/>
    </XSL:stylesheet>
  </xsl:template>

<!-- Gathering global "Within Text" rules from input document and optionally from external file -->
  <xsl:template name="gatherRules">
    <xsl:param name="docWithRules"/>
    <xsl:for-each select="$docWithRules//its:rules">
      <xsl:if test="@xlink:href" xmlns:xlink="http://www.w3.org/1999/xlink">
	<xsl:call-template name="gatherRules">
	  <xsl:with-param name="docWithRules"
			  select="doc(concat(substring-before(base-uri($docWithRules),tokenize(base-uri($docWithRules), '(/)|(\\)')[last()]),@xlink:href))"
			  />
	</xsl:call-template>
      </xsl:if>
      <xsl:for-each select=".//its:withinTextRule">
	<xsl:copy-of select="."/>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>

<!-- For each "Within Text" rule available, we write a template-->
  <xsl:template name="globalRulesTemplate">
    <xsl:variable name="globalRules">
      <xsl:call-template name="gatherRules">
	<xsl:with-param name="docWithRules">
	  <xsl:choose>
	    <xsl:when test="$externalRules!='none'">
	      <xsl:copy-of select="$XMLInput | doc($externalRules)"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:copy-of select="$XMLInput"/>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:for-each select="$globalRules/*">
      <xsl:variable name="value">
	<xsl:text>'</xsl:text>
	<xsl:value-of select="@withinText"/>
	<xsl:text>'</xsl:text>
      </xsl:variable>
      <XSL:template match="{./@selector}" mode="withinText">
	<xsl:variable name="currentRuleEl" select="."/>
	<xsl:for-each select="in-scope-prefixes(.)[not(.='xml')]">
	  <xsl:namespace name="{.}"
			 select="namespace-uri-for-prefix(.,$currentRuleEl)"/>
	</xsl:for-each>
	<xsl:attribute name="priority">
	  <xsl:number/>
	</xsl:attribute>
	<XSL:variable name="value" select="{$value}"/>
<!-- Different processing for elements and attributes below -->
	<XSL:choose>
	  <XSL:when test="self::element()">
	    <XSL:copy>
	      <XSL:attribute name="itsWtv">
		<XSL:value-of select="$value"/>
	      </XSL:attribute>
	      <XSL:apply-templates select="@* | node()" mode="withinText"/>
	    </XSL:copy>
	  </XSL:when>
          <XSL:otherwise>
            <XSL:message terminate="yes">
              <XSL:text>Error: Within text rule matches attribute node.</XSL:text>
            </XSL:message>
          </XSL:otherwise>
	</XSL:choose>
      </XSL:template>
    </xsl:for-each>
  </xsl:template>

<!-- Templates for elements and attributes which don't match anything -->
  <xsl:template name="recursionTemplate">
    <XSL:template match="*" priority="-1000" mode="withinText">
      <XSL:copy>
	<XSL:attribute name="itsWtv">
	    <XSL:text>no</XSL:text>
	</XSL:attribute>
	<XSL:apply-templates select="@* | node()" mode="withinText"/>	
      </XSL:copy>
    </XSL:template>

    <XSL:template match="@*" priority="-1000" mode="withinText">
      <XSL:copy/>
    </XSL:template>

  </xsl:template>

</xsl:stylesheet>
