<!-- gather-attributes.xsl 0.1
For documentation, see http://www.w3.org/International/its/wiki/ITS_Translate_Decorator

 -->
<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:XSL="http://www.w3.org/1999/XSL/TransformAlias"
 xmlns:itd="http://www.w3.org/International/its/wiki/ITS_Translate_Decorator"
 exclude-result-prefixes="xsl" version="2.0">

 <xsl:output method="xml" indent="yes" encoding="utf-8"/>
 <xsl:strip-space elements="*"/>
 <xsl:template match="@*">
 <xsl:copy/>
 </xsl:template>
<!-- For each element with translatable attributes, 
 attach an itsTva attribute which contains the names of these attributes.-->
<xsl:template match="*[@*[starts-with(name(),'transval-attr-')]]">
<xsl:copy>
 <!-- itd:id needed for roundtripping, that is back from e.g. XLIFF to translated
  input  document -->
 <xsl:attribute name="itd:id" select="generate-id(.)"/>
<xsl:attribute name="itsTva">
<xsl:for-each select="@*[starts-with(name(),'transval-attr-')]">
<xsl:value-of select="concat('#',.,'#')"/>
</xsl:for-each>
</xsl:attribute>
<xsl:apply-templates select="node() | @*[not(starts-with(name(),'transval-attr-'))]"/>
</xsl:copy>
</xsl:template>
<xsl:template match="*">
 <xsl:copy>  
  <!-- again itd:id needed for roundtripping -->
  <xsl:attribute name="itd:id" select="generate-id(.)"/>
  <xsl:apply-templates select="node() | @*"/>
 </xsl:copy>
</xsl:template>
</xsl:stylesheet>
