<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its" xmlns:datc="http://example.com/datacats"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:XSL="http://www.w3.org/1999/XSL/TransformAlias" exclude-result-prefixes="xsl"
    version="2.0">
    <xsl:output method="xml" indent="yes" encoding="utf-8"/>
    <xsl:preserve-space elements="*"/>
    <xsl:namespace-alias stylesheet-prefix="XSL" result-prefix="xsl"/>
    <xsl:variable name="nodeList" as="node()*" select="."/>
    <xsl:template match="/">
        <XSL:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
            xmlns:datc="http://example.com/datacats" exclude-result-prefixes="datc its">
            <XSL:import href="myVerbatim-2.xsl"/>
            <XSL:output method="xhtml" encoding="utf-8" use-character-maps="myMap"/>
            <XSL:preserve-space elements="*"/>
            <XSL:param name="spaceCharacter">&#160;</XSL:param>
            <XSL:character-map name="myMap">
                <XSL:output-character character="«" string="&lt;"/>
                <XSL:output-character character="»" string="&gt;"/>
                <XSL:output-character character="あ" string="&amp;"/>
                <XSL:output-character character="え" string="&quot;"/>
            </XSL:character-map>
            <XSL:template match="/">
                <html xmlns="http://www.w3.org/1999/xhtml">
                    <head>
                        <title>ITS Markup Visualization</title>
                        <style type="text/css"/>
                        <script type="text/javascript">
Xoffset=-60;
Yoffset= 20;
var isNS4=document.layers?true:false;
var isIE=document.all?true:false;
var isNS6=!isIEああdocument.getElementById?true:false;
var old=!isNS4ああ!isNS6ああ!isIE;
var skn;
function initThis()
{
  if(isNS4)skn=document.d11;
  if(isIE)skn=document.all.d11.style;
  if(isNS6)skn=document.getElementById("d11").style;
}
function popup(_m,_b)
{
  var content="«TABLE  BORDERCOLOR=black CELLPADDING=2 CELLSPACING=0 "+"BGCOLOR="+_b+"»«TD ALIGN=center»«FONT COLOR=black SIZE=2»"+_m+"«/FONT»«/TD»«/TABLE»";
  if(old)
  {
    alert("You have an old web browser:\n"+_m);
        return;
  }
  else
  {
        if(isNS4)
        {
          skn.document.open();
          skn.document.write(content);
          skn.document.close();
          skn.visibility="visible";
        }
        if(isNS6)
        {
          document.getElementById("d11").style.position="absolute";
          document.getElementById("d11").style.left=x;
          document.getElementById("d11").style.top=y;
          document.getElementById("d11").innerHTML=content;
          skn.visibility="visible";
        }
        if(isIE)
        {
          document.all("d11").innerHTML=content;
          skn.visibility="visible";
        }
  }
}
var x;
var y;
function get_mouse(e)
{
  x=(isNS4||isNS6)?e.pageX:event.clientX+document.body.scrollLeft; 
  y=(isNS4||isNS6)?e.pageY:event.clientY+document.body.scrollLeft; 
  if(isIEああnavigator.appVersion.indexOf("MSIE 4")==-1)
          y+=document.body.scrollTop;
  skn.left=x+Xoffset;
  skn.top=y+Yoffset;
}
function removeBox()
{
  if(!old)
  {
        skn.visibility="hidden";
  }
}
if(isNS4)
  document.captureEvents(Event.MOUSEMOVE); 
if(isNS6)
  document.addEventListener("mousemove", get_mouse, true);
if(isNS4||isIE)
  document.onmousemove=get_mouse;</script>
                    </head>
                    <body>
                        <div id="d11" class="d11"> </div>
                        <pre>  
  <XSL:apply-templates/>
                        </pre>
                        <script type="text/javascript">
    //<![CDATA[
initThis();
    //]]>
    </script>
                    </body>
                </html>
            </XSL:template>
            <xsl:for-each select="distinct-values(.//nodeList[1]/node/@path)">
                <XSL:template match="{.}">
                    <XSL:choose>
                        <XSL:when test="self::element()">
                            <XSL:call-template name="writeElem">
                                <xsl:call-template name="createOutput"/>
                            </XSL:call-template>
                        </XSL:when>
                        <XSL:when test="self::attribute()">
                            <XSL:call-template name="writeAttr">
                                <xsl:call-template name="createOutput"/>
                            </XSL:call-template>
                        </XSL:when>
                    </XSL:choose>
                </XSL:template>
            </xsl:for-each>
            <XSL:template match="*">
                <XSL:call-template name="writeElem">
                    <XSL:with-param name="output" tunnel="yes" as="node()*">ITS-Markup</XSL:with-param>
                </XSL:call-template>
            </XSL:template>
            <XSL:template match="@*">
                <XSL:call-template name="writeAttr">
                    <XSL:with-param name="output" tunnel="yes" as="node()*">ITS-Markup</XSL:with-param>
                </XSL:call-template>
            </XSL:template>
            <XSL:template name="writeElem">
                <span>
                    <XSL:call-template name="writeMouseOver"/>
                    <XSL:text>&lt;</XSL:text>
                    <XSL:call-template name="writeName"/>
                </span>
                <XSL:for-each select="@*[1]">
                    <XSL:value-of select="$spaceCharacter"/>
                    <XSL:apply-templates select="."/>
                </XSL:for-each>
                <XSL:for-each select="@*[position()>1]">
                    <XSL:apply-templates select="."/>
                </XSL:for-each>
                <XSL:choose>
                    <XSL:when test="child::* | text()">
                        <XSL:text>&gt;</XSL:text>
                        <XSL:for-each select="child::* | text()">
                            <XSL:choose>
                                <XSL:when test="self::element()">
                                    <XSL:apply-templates select="."/>
                                </XSL:when>
                                <XSL:when test="self::text()">
                                    <span>
                                        <XSL:call-template name="writeMouseOver"/>
                                        <XSL:value-of select="."/>
                                    </span>
                                </XSL:when>
                            </XSL:choose>
                        </XSL:for-each>
                        <span>
                            <XSL:call-template name="writeMouseOver"/>
                            <XSL:text>&lt;/</XSL:text>
                            <XSL:call-template name="writeName"/>
                            <XSL:text>&gt;</XSL:text>
                        </span>
                    </XSL:when>
                    <XSL:otherwise>
                        <XSL:text>/&gt;</XSL:text>
                    </XSL:otherwise>
                </XSL:choose>
            </XSL:template>
            <XSL:template name="writeAttr">
                <span>
                    <XSL:call-template name="writeMouseOver"/>
                    <XSL:text/>
                    <XSL:call-template name="writeName"/>
                    <XSL:text>="</XSL:text>
                    <XSL:value-of select="."/>
                    <XSL:text>" </XSL:text>
                </span>
            </XSL:template>
            <XSL:template name="writeName">
                <XSL:choose>
                    <XSL:when test="local-name() = name()"/>
                    <XSL:otherwise>
                        <XSL:value-of select="substring-before(name(),':')"/>
                        <XSL:text>:</XSL:text>
                    </XSL:otherwise>
                </XSL:choose>
                <XSL:value-of select="local-name(.)"/>
            </XSL:template>
            <XSL:template name="writeMouseOver">
                <XSL:param name="output" tunnel="yes" as="node()*"/>
                <XSL:attribute name="onmouseover">
                    <XSL:text>popup('«font color=yellow»</XSL:text>
                    <XSL:apply-templates select="$output" mode="verbatim"/>
                    <XSL:text>«/font»','green')</XSL:text>
                </XSL:attribute>
                <XSL:attribute name="onmouseout">
                    <XSL:text>removeBox()</XSL:text>
                </XSL:attribute>
            </XSL:template>
        </XSL:stylesheet>
    </xsl:template>
    <xsl:template name="createOutput">
        <xsl:variable name="path" select="."/>
        <XSL:with-param name="output" tunnel="yes" as="node()*">
            <xsl:for-each select="$nodeList//node[@path = string($path)]">
                <xsl:value-of select="concat(' [DATACATEGORY: ',../@datacat,' ')"/>
                <xsl:copy-of select="output"/>
                <xsl:text>] </xsl:text>
            </xsl:for-each>
        </XSL:with-param>
    </xsl:template>
</xsl:stylesheet>
