<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its" xmlns:datc="http://example.com/datacats"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:XSL="http://www.w3.org/1999/XSL/TransformAlias" xmlns:ex="http://example.com"
    exclude-result-prefixes="xsl its datc XSL ex"
    xmlns:o="http://www.w3.org/2005/11/its/testoutputformat"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="2.0">
    <xsl:strip-space elements="its:locNote"/>
    <xsl:template match="/"> 
        <!-- <xsl:processing-instruction name="oxygen"
  select="('RNGSchema=&quot;../itsoutput.rnc&quot;', 'type=&quot;compact&quot;')"/> -->
        <xsl:element name="o:nodeList">
        <xsl:namespace name="xsi" select="'http://www.w3.org/2001/XMLSchema-instance'"/>
        <xsl:attribute name="xsi:schemaLocation">http://www.w3.org/2005/11/its/testoutputformat/ ../itsoutput.xsd</xsl:attribute>
        <xsl:apply-templates select="/*/@* | /*/node()"/>
            </xsl:element>
    </xsl:template>
    <xsl:template match="@* | node()">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*[local-name()='nodeList' or local-name()='node']">
        <xsl:element name="{concat('o:',local-name())}">
            <xsl:apply-templates select="@* | node()"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="output">
        <xsl:element name="o:output">
            <xsl:apply-templates select="@* | node()"/>
        </xsl:element>
    </xsl:template>

    <!-- General templates -->
    <xsl:template match="*" mode="markupCopy" exclude-result-prefixes="its datc">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" mode="markupCopy"
                exclude-result-prefixes="its datc"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="@*" mode="markupCopy" exclude-result-prefixes="its datc">
        <xsl:value-of select="."/>
    </xsl:template>

    <!-- For translate data category -->
    <xsl:template match="@translate | @its:translate">
        <xsl:attribute name="o:translate">
            <xsl:value-of select="."/>
        </xsl:attribute>
    </xsl:template>

    <!-- For localization note -->
    <xsl:template match="@locNoteType | @its:locNoteType">
        <xsl:attribute name="o:locNoteType">
            <xsl:value-of select="."/>
        </xsl:attribute>
    </xsl:template>

    <xsl:template match="its:span[@locNote] | *[@its:locNote or @locNote]">
        <o:output>
            <xsl:attribute name="o:locNoteType">
                <xsl:choose>
                    <xsl:when test="@*[local-name()='locNoteType']">
                        <xsl:value-of select="@locNoteType | @its:locNoteType"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>description</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:element name="o:locNoteText">
                <xsl:value-of select="@locNote | @its:locNote"/>
            </xsl:element>
        </o:output>
    </xsl:template>

    <xsl:template match="its:span[@locNoteRef] | *[@its:locNoteRef or @locNoteRef]">
        <o:output>
            <xsl:attribute name="o:locNoteType">
                <xsl:choose>
                    <xsl:when test="@*[local-name()='locNoteType']">
                        <xsl:value-of select="@locNoteType | @its:locNoteType"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>description</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:element name="o:locNoteReference">
                <xsl:value-of select="@locNoteRef | @its:locNoteRef"/>
            </xsl:element>
        </o:output>
    </xsl:template>

    <xsl:template match="output[locNoteRefPointer]">
        <o:output o:locNoteType="{@locNoteType}">
            <xsl:element name="o:locNoteReference">
                <xsl:apply-templates select="locNoteRefPointer/@* | locNoteRefPointer/node()"
                    mode="markupCopy"/>
            </xsl:element>
        </o:output>
    </xsl:template>

    <xsl:template match="locNotePointer">
        <xsl:element name="o:locNoteText">
            <xsl:value-of select="./*"/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="its:locNote">
        <xsl:element name="o:locNoteText">
            <xsl:apply-templates mode="markupCopy"/>
        </xsl:element>
    </xsl:template>

    <!-- For terminology -->

    <xsl:template match="its:span[@term[.='yes']] | *[@its:term[.='yes']
		      or @term[.='yes']]"
        priority="1">
        <o:output o:term="yes"/>
    </xsl:template>

    <xsl:template match="output[termInfoRefPointer]" priority="2">
        <o:output o:term="yes">
            <xsl:element name="o:termInfoReference">
                <xsl:apply-templates select="termInfoRefPointer/@* | termInfoRefPointer/node()"
                    mode="markupCopy"/>
            </xsl:element>
        </o:output>
    </xsl:template>

    <xsl:template match="output[termInfoPointer]" priority="2">
        <o:output o:term="yes">
            <xsl:element name="o:termInfoText">
                <xsl:apply-templates select="termInfoPointer/@* | termInfoPointer/*/node()"
                    mode="markupCopy"/>
            </xsl:element>
        </o:output>
    </xsl:template>


    <xsl:template match="output[@its:termInfoRef | @termInfoRef]" priority="2">
        <o:output o:term="yes">
            <xsl:element name="o:termInfoReference">
                <xsl:value-of select="@its:termInfoRef | @termInfoRef"/>
            </xsl:element>
        </o:output>
    </xsl:template>

    <xsl:template match="its:span[@term[.='no']] | *[@its:term[.='no'] or
  @term[.='no']]">
        <o:output o:term="no"/>
    </xsl:template>


    <!-- For elements within text -->
    <xsl:template match="output[@its:withinText | @withinText]">
        <o:output o:withinText="{@its:withinText | @withinText}"/>
    </xsl:template>

    <!-- For directionality -->
    <xsl:template match="output[@its:dir | @dir]">
        <o:output o:dir="{@its:dir | @dir}"/>
    </xsl:template>


    <!-- For language information -->
    <xsl:template match="output[langPointer]">
        <o:output>
            <o:langInfo>
                <xsl:apply-templates select="langPointer/@* | langPointer/*/node()"
                    mode="markupCopy"/>
            </o:langInfo>
        </o:output>
    </xsl:template>

    <xsl:template match="its:ruby">
        <o:ruby>
            <xsl:apply-templates mode="markupCopy" select="@*|node()"/>
        </o:ruby>
    </xsl:template>

    <xsl:template match="its:rb" mode="markupCopy">
        <o:rb>
            <xsl:apply-templates mode="markupCopy" select="@*|node()"/>
        </o:rb>
    </xsl:template>

    <xsl:template match="its:rt" mode="markupCopy">
        <o:rt>
            <xsl:apply-templates mode="markupCopy" select="@*|node()"/>
        </o:rt>
    </xsl:template>

    <xsl:template match="@rbspan" mode="markupCopy">
        <xsl:attribute name="o:rbspan" select="."/>
    </xsl:template>

    <xsl:template match="its:rp" mode="markupCopy">
        <o:rp>
            <xsl:apply-templates mode="markupCopy" select="@*|node()"/>
        </o:rp>
    </xsl:template>

    <xsl:template match="its:rbc" mode="markupCopy">
        <o:rbc>
            <xsl:apply-templates mode="markupCopy" select="@*|node()"/>
        </o:rbc>
    </xsl:template>

    <xsl:template match="its:rtc" mode="markupCopy">
        <o:rtc>
            <xsl:apply-templates mode="markupCopy" select="@*|node()"/>
        </o:rtc>
    </xsl:template>

    <xsl:template match="its:rubyText">
        <o:rubyText>
            <xsl:apply-templates mode="markupCopy" select="@*|node()"/>
        </o:rubyText>
    </xsl:template>

    <xsl:template
        match="rubyPointer | rpPointer | rbcPointer | rtcPointer
| rbspanPointer | rbspanPointer | rtPointer">
        <xsl:element name="{concat('o:',substring-before(name(),'Pointer'),'Pointer')}">
            <xsl:apply-templates select="@*|element()" mode="markupCopy"/>
        </xsl:element>
    </xsl:template>

</xsl:stylesheet>
