<xsl:stylesheet xmlns:rng="http://relaxng.org/ns/structure/1.0"
    xmlns:teix="http://www.tei-c.org/ns/Examples" xmlns:tei="http://www.tei-c.org/ns/1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="2.0">
    <xsl:template match="*" mode="verbatim">
        <xsl:value-of>« </xsl:value-of>
        <xsl:call-template name="writeName"/>
        <xsl:for-each select="attribute()">
            <xsl:apply-templates mode="verbatim" select="."/>
        </xsl:for-each>
        <xsl:value-of> »</xsl:value-of>
        <xsl:for-each select="child::* | text()">
            <xsl:choose>
                <xsl:when test="self::element()">
                    <xsl:apply-templates select="." mode="verbatim"/>
                </xsl:when>
                <xsl:when test="self::text()">
                    <xsl:value-of select="."/>
                </xsl:when>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    <xsl:template match="@*" mode="verbatim">
        <xsl:text> @</xsl:text>
        <xsl:call-template name="writeName"/>
        <xsl:text>=</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text></xsl:text>
    </xsl:template>
</xsl:stylesheet>
