<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its"
    xmlns:eg="http://www.tei-c.org/ns/Examples"
    xmlns:a="http://relaxng.org/ns/compatibility/annotations/1.0"
    xmlns:rng="http://relaxng.org/ns/structure/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:tei="http://www.tei-c.org/ns/1.0" xmlns:teix="http://www.tei-c.org/ns/Examples"
    xmlns:local="http://www.pantor.com/ns/local" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:spec="http://example.com/xmlspec"
    exclude-result-prefixes="fo a tei rng local teix xs eg its" version="2.0">
    <!-- todos: no span / class, emtpy space between delimiters«» -->
    <xsl:param name="startBold"/>
    <xsl:param name="endBold"/>
    <xsl:param name="startItalic"/>
    <xsl:param name="endItalic"/>
    <xsl:param name="startRed"/>
    <xsl:param name="endRed"/>
    <xsl:param name="spaceCharacter"/>
    <xsl:template match="*" mode="verbatim">
        <xsl:call-template name="writeDatacatElem"/>
    </xsl:template>
    <xsl:template name="writeDatacatElem">
        <xsl:text>« </xsl:text>
        <xsl:call-template name="writeName"/>
        <xsl:for-each select="@*[1]">
            <xsl:value-of select="$spaceCharacter"/>
            <xsl:call-template name="writeDatacatAttr"/>
        </xsl:for-each>
        <xsl:for-each select="@*[position()>1]">
            <xsl:call-template name="writeDatacatAttr"/>
        </xsl:for-each>
        <xsl:choose>
            <xsl:when test="child::* | text()">
                <xsl:text> »</xsl:text>
                <xsl:for-each select="child::* | text()">
                    <xsl:choose>
                        <xsl:when test="self::element()">
                            <xsl:apply-templates select="." mode="verbatim"/>
                        </xsl:when>
                        <xsl:when test="self::text()">
                            <xsl:value-of select="."/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:for-each>
                <xsl:text>« /</xsl:text>
                <xsl:call-template name="writeName"/>
                <xsl:text> »</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>/ »</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="writeDatacatAttr">                
                    <xsl:text/>
                    <xsl:call-template name="writeName"/>
                    <xsl:text>=</xsl:text>
                    <xsl:value-of select="."/>
                    <xsl:text> </xsl:text>
            </xsl:template>
    <!-- <xsl:template name="verbatimElement">
        <xsl:param name="class">verbatim</xsl:param>
        <xsl:choose>
            <xsl:when test="not(preceding-sibling::node())">
                <xsl:call-template name="lineBreak">
                    <xsl:with-param name="id">2</xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="makeIndent"/>
            </xsl:when>
            <xsl:when test="preceding-sibling::node()[1]/self::*">
                <xsl:call-template name="lineBreak">
                    <xsl:with-param name="id">1</xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="makeIndent"/>
            </xsl:when>
            <xsl:when test="preceding-sibling::node()[1]/self::text()"> </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="lineBreak">
                    <xsl:with-param name="id">9</xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="makeIndent"/>
            </xsl:otherwise>
        </xsl:choose>
        <span class="{$class}">
            <xsl:text>« </xsl:text>
            <xsl:call-template name="showElement">
                <xsl:with-param name="element">
                    <xsl:call-template name="eName"/>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:apply-templates select="@*" mode="verbatim"/>
            <xsl:choose>
                <xsl:when test="child::node()">
                    <xsl:text> »</xsl:text>
                     <xsl:apply-templates mode="verbatim"/>
                    <xsl:choose>
                        <xsl:when test="child::node()[last()]/self::text()[normalize-space(.)='']">
                            <xsl:call-template name="lineBreak">
                                <xsl:with-param name="id">3</xsl:with-param>
                            </xsl:call-template>
                            <xsl:call-template name="makeIndent"/>
                        </xsl:when>
                        <xsl:when test="child::node()[last()]/self::comment()">
                            <xsl:call-template name="lineBreak">
                                <xsl:with-param name="id">4</xsl:with-param>
                            </xsl:call-template>
                            <xsl:call-template name="makeIndent"/>
                        </xsl:when>
                        <xsl:when test="child::node()[last()]/self::*">
                            <xsl:call-template name="lineBreak">
                                <xsl:with-param name="id">5</xsl:with-param>
                            </xsl:call-template>
                            <xsl:call-template name="makeIndent"/>
                        </xsl:when>
                    </xsl:choose>
                    <xsl:text>«/ </xsl:text>
                    <xsl:call-template name="showElement">
                        <xsl:with-param name="element">
                            <xsl:call-template name="eName"/>
                        </xsl:with-param>
                    </xsl:call-template>
                    <xsl:text> »</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text> /»</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </span>
    </xsl:template>
    <xsl:template name="eName">
        <xsl:choose>
            <xsl:when test="namespace-uri()='http://relaxng.org/ns/structure/1.0'">
                <xsl:text>rng:</xsl:text>
                <xsl:value-of select="local-name(.)"/>
            </xsl:when>
            <xsl:when test="namespace-uri()='http://www.w3.org/2001/XMLSchema'">
                <xsl:text>xs:</xsl:text>
                <xsl:value-of select="local-name(.)"/>
            </xsl:when>
            <xsl:when test="namespace-uri()='http://www.w3.org/2005/11/its'">
                <xsl:text>its:</xsl:text>
                <xsl:value-of select="local-name(.)"/>
            </xsl:when>
            <xsl:when test="namespace-uri()='http://www.w3.org/1999/XSL/Transform'">
                <xsl:value-of select="$startRed"/>
                <xsl:text>xsl:</xsl:text>
                <xsl:value-of select="local-name(.)"/>
                <xsl:value-of select="$endRed"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="local-name(.)"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="makeIndent">
        <xsl:for-each select="ancestor::*[not(namespace-uri()='http://www.tei-c.org/ns/1.0')]">
            <xsl:value-of select="$spaceCharacter"/>
        </xsl:for-each>
    </xsl:template>
    <xsl:template match="@*" mode="verbatim">
        <xsl:call-template name="verbatimAttribute"/>
    </xsl:template>
    <xsl:template name="verbatimAttribute">
        <xsl:param name="class">translateno</xsl:param>
        <xsl:text></xsl:text>
        <span class="{$class}">
            <xsl:call-template name="showAttribute">
                <xsl:with-param name="attribute">
                    <xsl:value-of select="local-name(.)"/>
                </xsl:with-param>
            </xsl:call-template>
            <xsl:text>=</xsl:text>
            <xsl:value-of select="."/>
            <xsl:text></xsl:text>
        </span>
    </xsl:template>
    <xsl:template match="text()" mode="verbatim">
        <xsl:choose>
            <xsl:when test="normalize-space(.)=''">
                <xsl:for-each select="following-sibling::*[1]">
                    <xsl:call-template name="lineBreak">
                        <xsl:with-param name="id">7</xsl:with-param>
                    </xsl:call-template>
                    <xsl:call-template name="makeIndent"/>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="wraptext">
                    <xsl:with-param name="indent">
                        <xsl:for-each select="parent::*">
                            <xsl:call-template name="makeIndent"/>
                        </xsl:for-each>
                    </xsl:with-param>
                    <xsl:with-param name="text">
                        <xsl:value-of select="."/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="wraptext">
        <xsl:param name="indent"/>
        <xsl:param name="text"/>
        <xsl:choose>
            <xsl:when test="$text='&#10;'"/>
            <xsl:when test="contains($text,'&#10;')">
                <xsl:value-of select="substring-before($text,'&#10;')"/>
                <xsl:call-template name="lineBreak">
                    <xsl:with-param name="id">6</xsl:with-param>
                </xsl:call-template>
                <xsl:value-of select="$indent"/>
                <xsl:call-template name="wraptext">
                    <xsl:with-param name="indent">
                        <xsl:value-of select="$indent"/>
                    </xsl:with-param>
                    <xsl:with-param name="text">
                        <xsl:value-of select="substring-after($text,'&#10;')"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$text"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template name="lineBreak">
        <xsl:param name="id"/>
        <xsl:text></xsl:text>
    </xsl:template>
    <xsl:template name="showAttribute">
        <xsl:param name="attribute"/>
        <xsl:value-of select="$startBold"/>
        <xsl:value-of select="$attribute"/>
        <xsl:value-of select="$endBold"/>
    </xsl:template>
    <xsl:template name="showElement">
        <xsl:param name="element"/>
        <xsl:value-of select="$startBold"/>
        <xsl:value-of select="$element"/>
        <xsl:value-of select="$endBold"/>
    </xsl:template>-->
</xsl:stylesheet>
