<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:to="http://www.w3.org/2005/11/its/testoutputcompare"
		version="2.0">
  <xsl:output method="xml" indent="yes" encoding="utf-8"/>
  <xsl:template match="/">
    <project name="ITS" default="main"
	     basedir="." xmlns:to="http://www.w3.org/2005/11/its/testoutputcompare">
      <property name="sampleCatDesc" value="${{basedir}}/sampleCatDesc.xml"/>
      <property name="datacats2xsl" value="${{basedir}}/datacats2xsl.xsl"/>
      <property name="myVerbatim" value="${{basedir}}/myVerbatim-2.xsl"/>
      <property name="output2html" value="${{basedir}}/output2html.xsl"/>
      <property name="inputfilesdir" value="../inputdata"/>
      <target name="clean" depends="cleanGeneratedStylesheets">
	<delete>
	  <fileset dir="${{basedir}}" includes="*-result.xml  *-result-pre.xml *.html"/>
	</delete>
      </target>
      <target name="cleanGeneratedStylesheets">
	<delete>
	  <fileset dir="${{basedir}}" includes="*.xsl"
		   excludes="datacats2xsl.xsl myVerbatim.xsl
			     myVerbatim-2.xsl output2html.xsl
			     output2crOutputformat.xsl generateBuild.xsl"/>
	</delete>
      </target>
      <target name="compare">
	<xslt in="${{basedir}}/../input-file-list.xml"
	      out="../testresults.xml"
	      style="${{basedir}}/../compare.xsl"/>
      </target>
 <target name="compare2html" depends="compare">
	<xslt in="${{basedir}}/../Overview-template.html"
	      out="../compare.html"
	      style="${{basedir}}/../compareResultHtml.xsl"/>
      </target>
      <target name="createDatacats2xsl">
	<xsl:apply-templates
	    select="//to:inputFile[to:resultFile[@implementation='test3']]" mode="createDatacats2xsl"/>
      </target>
      <target name="createResult" depends="createDatacats2xsl">
	<xsl:apply-templates
	    select="//to:inputFile[to:resultFile[@implementation='test3']]" mode="createResult"/>
      </target>
        <target name="validate">
		<!-- Make sure the files are valid  -->
		<xmlvalidate 	failonerror="yes" lenient="no" warn="yes"
						classname="org.apache.xerces.parsers.SAXParser"
						classpath="lib/xerces.jar"
		>
			<fileset dir="." includes="*result.xml"/>
			<attribute name="http://xml.org/sax/features/validation" value="true"/>
			<attribute name="http://apache.org/xml/features/validation/schema"  value="true"/>
		</xmlvalidate>
		<echo message="Project files have been validated"  />

	</target>        
      <target name="main" depends="createResult"/>
    </project>
  </xsl:template>

  <xsl:template match="*" mode="createDatacats2xsl">
    <xslt in="./sampleCatDesc.xml"
	  out="{concat(substring-before(@name,'.xml'),'.xsl')}"
	  style="${{datacats2xsl}}">
      <param name="inputDocUri" expression="{concat('${inputfilesdir}/',@name)}"/>
      <param name="inputDatacats" expression="{@datacat}"/>
    </xslt>
  </xsl:template>
  <xsl:template match="*" mode="createResult">
    <xslt in="{concat('${inputfilesdir}/',@name)}"
	  out="{concat(substring-before(@name,'.xml'),'-result-pre.xml')}" style="{concat(substring-before(@name,'.xml'),'.xsl')}"/>
    <xslt in="{concat(substring-before(@name,'.xml'),'-result-pre.xml')}" out="{concat(substring-before(@name,'.xml'),'-result.xml')}"
	  style="output2crOutputformat.xsl"/>	                   
  </xsl:template>
</xsl:stylesheet>