<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:its="http://www.w3.org/2005/11/its"
                xmlns:datc="http://example.com/datacats"
                version="2.0">
   <xsl:output method="xml" indent="yes" encoding="utf-8"/>
   <xsl:strip-space elements="*"/>
   <xsl:template match="*|@*" mode="get-full-path">
      <xsl:apply-templates select="parent::*" mode="get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:if test="count(. | ../@*) = count(../@*)">@</xsl:if>
      <xsl:value-of select="concat('{', namespace-uri(.),'}',local-name())"/>
      <xsl:if test="self::element() and parent::element()">
         <xsl:text>[</xsl:text>
         <xsl:number/>
         <xsl:text>]</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template name="writeOutput">
      <xsl:param name="outputType">no-value</xsl:param>
      <xsl:param name="outputValue" as="node()*">
         <output>no-value</output>
      </xsl:param>
      <xsl:element name="node">
         <xsl:attribute name="path">
            <xsl:apply-templates mode="get-full-path" select="."/>
         </xsl:attribute>
         <xsl:attribute name="outputType">
            <xsl:value-of select="$outputType"/>
         </xsl:attribute>
         <xsl:copy-of select="$outputValue"/>
      </xsl:element>
   </xsl:template>
   <xsl:template match="/">
      <nodeList>
         <xsl:element name="nodeList">
            <xsl:attribute name="datacat">
               <xsl:text>ruby</xsl:text>
            </xsl:attribute>
            <xsl:apply-templates mode="ruby">
               <xsl:with-param name="existingDataCatValue">no-value</xsl:with-param>
            </xsl:apply-templates>
         </xsl:element>
      </nodeList>
   </xsl:template>
   <xsl:template match="its:ruby" mode="ruby" priority="+1000">
      <xsl:call-template name="writeOutput">
         <xsl:with-param name="outputType">new-value-local</xsl:with-param>
         <xsl:with-param name="outputValue" as="node()*">
            <output>
               <xsl:for-each select="self::its:ruby">
                  <xsl:copy-of select="."/>
               </xsl:for-each>
            </output>
         </xsl:with-param>
      </xsl:call-template>
      <xsl:apply-templates mode="ruby" select="@* | element()">
         <xsl:with-param name="existingDataCatValue" as="node()*">no-value</xsl:with-param>
      </xsl:apply-templates>
   </xsl:template>
   <xsl:template match="*" mode="ruby" priority="-1000">
      <xsl:param name="existingDataCatValue" as="node()*">no-value</xsl:param>
      <xsl:if test="$existingDataCatValue='no-value'">
         <xsl:call-template name="writeOutput">
            <xsl:with-param name="outputType">no-value</xsl:with-param>
            <xsl:with-param name="outputValue" as="node()*">
               <output/>
            </xsl:with-param>
         </xsl:call-template>
         <xsl:apply-templates mode="ruby" select="@* | element()">
            <xsl:with-param name="existingDataCatValue" as="node()*">no-value</xsl:with-param>
         </xsl:apply-templates>
      </xsl:if>
   </xsl:template>
   <xsl:template match="@*" mode="ruby" priority="-1000">
      <xsl:param name="existingDataCatValue" as="node()*">no-value</xsl:param>
      <xsl:call-template name="writeOutput">
         <xsl:with-param name="outputType">no-value</xsl:with-param>
         <xsl:with-param name="outputValue" as="node()*">
            <output/>
         </xsl:with-param>
      </xsl:call-template>
   </xsl:template>
   <xsl:template mode="rubyrubyPointer" match="element() | @*" priority="1">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="rubyrubyPointer"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template mode="rubyrbcPointer" match="element() | @*" priority="1">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="rubyrbcPointer"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template mode="rubyrtcPointer" match="element() | @*" priority="1">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="rubyrtcPointer"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template mode="rubyrbspanPointer" match="element() | @*" priority="1">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="rubyrbspanPointer"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template mode="rubyrtPointer" match="element() | @*" priority="1">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="rubyrtPointer"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template xmlns:ex="http://example.com" mode="ruby" match="//ex:p[1]//ex:rb" priority="1">
      <xsl:call-template name="writeOutput">
         <xsl:with-param name="outputType">new-value-global</xsl:with-param>
         <xsl:with-param name="outputValue" as="node()*">
            <output>
               <rubyPointer>
                  <xsl:apply-templates select="ancestor::ex:ruby" mode="rubyrubyPointer"/>
               </rubyPointer>
               <rbcPointer>
                  <xsl:apply-templates select="parent::ex:rbc" mode="rubyrbcPointer"/>
               </rbcPointer>
               <rtcPointer>
                  <xsl:apply-templates select="../following-sibling::ex:rtc" mode="rubyrtcPointer"/>
               </rtcPointer>
               <rbspanPointer>
                  <xsl:apply-templates select="../following-sibling::ex:rtc/ex:rt/@rbspan" mode="rubyrbspanPointer"/>
               </rbspanPointer>
               <rtPointer>
                  <xsl:apply-templates select="../following-sibling::ex:rtc/ex:rt" mode="rubyrtPointer"/>
               </rtPointer>
            </output>
         </xsl:with-param>
      </xsl:call-template>
      <xsl:apply-templates mode="ruby" select="@* | element()">
         <xsl:with-param name="existingDataCatValue" as="node()*">
            <output>
               <rubyPointer>
                  <xsl:apply-templates select="ancestor::ex:ruby" mode="rubyrubyPointer"/>
               </rubyPointer>
               <rbcPointer>
                  <xsl:apply-templates select="parent::ex:rbc" mode="rubyrbcPointer"/>
               </rbcPointer>
               <rtcPointer>
                  <xsl:apply-templates select="../following-sibling::ex:rtc" mode="rubyrtcPointer"/>
               </rtcPointer>
               <rbspanPointer>
                  <xsl:apply-templates select="../following-sibling::ex:rtc/ex:rt/@rbspan" mode="rubyrbspanPointer"/>
               </rbspanPointer>
               <rtPointer>
                  <xsl:apply-templates select="../following-sibling::ex:rtc/ex:rt" mode="rubyrtPointer"/>
               </rtPointer>
            </output>
         </xsl:with-param>
      </xsl:apply-templates>
   </xsl:template>
   <xsl:template mode="rubyrubyPointer" match="element() | @*" priority="2">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="rubyrubyPointer"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template mode="rubyrpPointer" match="element() | @*" priority="2">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="rubyrpPointer"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template mode="rubyrtPointer" match="element() | @*" priority="2">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="rubyrtPointer"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template xmlns:ex="http://example.com" mode="ruby" match="//ex:p[2]//ex:rb" priority="2">
      <xsl:call-template name="writeOutput">
         <xsl:with-param name="outputType">new-value-global</xsl:with-param>
         <xsl:with-param name="outputValue" as="node()*">
            <output>
               <rubyPointer>
                  <xsl:apply-templates select="ancestor::ex:ruby" mode="rubyrubyPointer"/>
               </rubyPointer>
               <rpPointer>
                  <xsl:apply-templates select="following-sibling::ex:rp" mode="rubyrpPointer"/>
               </rpPointer>
               <rtPointer>
                  <xsl:apply-templates select="following-sibling::ex:rt" mode="rubyrtPointer"/>
               </rtPointer>
            </output>
         </xsl:with-param>
      </xsl:call-template>
      <xsl:apply-templates mode="ruby" select="@* | element()">
         <xsl:with-param name="existingDataCatValue" as="node()*">
            <output>
               <rubyPointer>
                  <xsl:apply-templates select="ancestor::ex:ruby" mode="rubyrubyPointer"/>
               </rubyPointer>
               <rpPointer>
                  <xsl:apply-templates select="following-sibling::ex:rp" mode="rubyrpPointer"/>
               </rpPointer>
               <rtPointer>
                  <xsl:apply-templates select="following-sibling::ex:rt" mode="rubyrtPointer"/>
               </rtPointer>
            </output>
         </xsl:with-param>
      </xsl:apply-templates>
   </xsl:template>
</xsl:stylesheet>