<?xml version="1.0" encoding="utf-8"?>
<XSL:stylesheet xmlns:XSL="http://www.w3.org/1999/XSL/Transform" xmlns:its="http://www.w3.org/2005/11/its" xmlns:tei="http://www.tei-c.org/ns/1.0" version="1.0" tei:dummy-for-xmlns="">
  <XSL:import href="verbatim.xsl"/>
  <XSL:output method="html"/>
  <XSL:param name="startBold"/>
  <XSL:param name="endBold"/>
  <XSL:param name="startRed"/>
  <XSL:param name="endRed"/>
  <XSL:param name="spaceCharacter"> </XSL:param>
  <XSL:template match="/">
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="its.css"/>
      </head>
      <body>
        <pre>
          <XSL:apply-templates mode="verbatim"/>
        </pre>
      </body>
    </html>
  </XSL:template>
  <XSL:template match="tei:*" mode="verbatim" priority="1001">
    <XSL:choose>
      <XSL:when test="self::*">
        <XSL:call-template name="verbatimElement">
          <XSL:with-param name="class">translateno</XSL:with-param>
        </XSL:call-template>
      </XSL:when>
      <XSL:when test="namespace-uri()='http://www.w3.org/2005/11/its'"/>
      <XSL:otherwise>
        <XSL:call-template name="verbatimAttribute">
          <XSL:with-param name="class">translateno</XSL:with-param>
        </XSL:call-template>
      </XSL:otherwise>
    </XSL:choose>
  </XSL:template>
  <XSL:template match="tei:desc" mode="verbatim" priority="1002">
    <XSL:choose>
      <XSL:when test="self::*">
        <XSL:call-template name="verbatimElement">
          <XSL:with-param name="class">translateyes</XSL:with-param>
        </XSL:call-template>
      </XSL:when>
      <XSL:when test="namespace-uri()='http://www.w3.org/2005/11/its'"/>
      <XSL:otherwise>
        <XSL:call-template name="verbatimAttribute">
          <XSL:with-param name="class">translateyes</XSL:with-param>
        </XSL:call-template>
      </XSL:otherwise>
    </XSL:choose>
  </XSL:template>
  <XSL:template match="tei:gloss" mode="verbatim" priority="1003">
    <XSL:choose>
      <XSL:when test="self::*">
        <XSL:call-template name="verbatimElement">
          <XSL:with-param name="class">translateyes</XSL:with-param>
        </XSL:call-template>
      </XSL:when>
      <XSL:when test="namespace-uri()='http://www.w3.org/2005/11/its'"/>
      <XSL:otherwise>
        <XSL:call-template name="verbatimAttribute">
          <XSL:with-param name="class">translateyes</XSL:with-param>
        </XSL:call-template>
      </XSL:otherwise>
    </XSL:choose>
  </XSL:template>
  <XSL:template match="tei:valDesc" mode="verbatim" priority="1004">
    <XSL:choose>
      <XSL:when test="self::*">
        <XSL:call-template name="verbatimElement">
          <XSL:with-param name="class">translateyes</XSL:with-param>
        </XSL:call-template>
      </XSL:when>
      <XSL:when test="namespace-uri()='http://www.w3.org/2005/11/its'"/>
      <XSL:otherwise>
        <XSL:call-template name="verbatimAttribute">
          <XSL:with-param name="class">translateyes</XSL:with-param>
        </XSL:call-template>
      </XSL:otherwise>
    </XSL:choose>
  </XSL:template>
  <XSL:template match="tei:p[@rend='dataDesc']" mode="verbatim" priority="1005">
    <XSL:choose>
      <XSL:when test="self::*">
        <XSL:call-template name="verbatimElement">
          <XSL:with-param name="class">translateyes</XSL:with-param>
        </XSL:call-template>
      </XSL:when>
      <XSL:when test="namespace-uri()='http://www.w3.org/2005/11/its'"/>
      <XSL:otherwise>
        <XSL:call-template name="verbatimAttribute">
          <XSL:with-param name="class">translateyes</XSL:with-param>
        </XSL:call-template>
      </XSL:otherwise>
    </XSL:choose>
  </XSL:template>
  <XSL:template match="tei:remarks" mode="verbatim" priority="1006">
    <XSL:choose>
      <XSL:when test="self::*">
        <XSL:call-template name="verbatimElement">
          <XSL:with-param name="class">translateyes</XSL:with-param>
        </XSL:call-template>
      </XSL:when>
      <XSL:when test="namespace-uri()='http://www.w3.org/2005/11/its'"/>
      <XSL:otherwise>
        <XSL:call-template name="verbatimAttribute">
          <XSL:with-param name="class">translateyes</XSL:with-param>
        </XSL:call-template>
      </XSL:otherwise>
    </XSL:choose>
  </XSL:template>
  <XSL:template match="*[@its:translate]" mode="verbatim" priority="10000">
    <XSL:call-template name="verbatimElement">
      <XSL:with-param name="class">
        <XSL:text>translate</XSL:text>
        <XSL:value-of select="@its:translate"/>
      </XSL:with-param>
    </XSL:call-template>
  </XSL:template>
  <XSL:template match="its:*" mode="verbatim"/>
  <XSL:template match="@its:*" mode="verbatim"/>
  <XSL:template name="makeIndent">
    <XSL:for-each select="ancestor::*">
      <XSL:value-of select="$spaceCharacter"/>
    </XSL:for-each>
  </XSL:template>
</XSL:stylesheet>
