<xsl:stylesheet
    xmlns:its="http://www.w3.org/2005/11/its"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:XSL="http://www.w3.org/1999/XSL/TransformAlias" 
    exclude-result-prefixes="xsl" 
    version="1.0"
>
<xsl:output method="xml" indent="yes" encoding="utf-8"/>

<xsl:namespace-alias stylesheet-prefix="XSL" result-prefix="xsl"/>

<xsl:key name="TRANS" match="*[@its:translate]" use="."/>

<xsl:param name="ruleFile"/>

<xsl:template match="/">
  
  <XSL:stylesheet version="1.0"
		  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
		>

    <xsl:for-each select="//its:ns">
      <xsl:attribute name="{concat(@its:prefix,':dummy-for-xmlns')}" 
		     namespace="{@its:uri}"/>
    </xsl:for-each>

    <xsl:if test="not($ruleFile='')">
      <xsl:for-each
	  select="document($ruleFile)//its:documentRules/its:ns" >
	<xsl:attribute name="{concat(@its:prefix,':ext-dummy-for-xmlns')}" 
		     namespace="{@its:uri}"/>
      </xsl:for-each>
    </xsl:if>
    <XSL:import href="verbatim.xsl"/>
    <XSL:output method="html"/>
    <XSL:param name="startBold"></XSL:param>
    <XSL:param name="endBold"></XSL:param>    
    <XSL:param name="startRed"></XSL:param>
    <XSL:param name="endRed"></XSL:param>    
    <XSL:param name="spaceCharacter">&#160;</XSL:param>

    <XSL:template match="/">
      <html>
	<head>
	  <link rel="stylesheet" type="text/css" href="its.css"/>
	</head>
	<body>
	  <pre>
	    <XSL:apply-templates mode="verbatim"/>
	  </pre>
	</body>
      </html>
    </XSL:template>
    
    <xsl:if test="not($ruleFile='')">
      <xsl:for-each
	  select="document($ruleFile)//its:documentRules/its:documentRule[@its:translateSelector]" >
	<xsl:variable name="N">
	  <xsl:number/>
	</xsl:variable>
	<xsl:call-template name="makeTemplate">
	  <xsl:with-param name="priority">
	    <xsl:value-of select="$N + 100"/>
	  </xsl:with-param>
      </xsl:call-template>
      </xsl:for-each>
    </xsl:if>
    
    <xsl:for-each
	select="//its:documentRules/its:documentRule[@its:translateSelector]" >
      <xsl:variable name="N">
	<xsl:number/>
      </xsl:variable>
      <xsl:call-template name="makeTemplate">
	<xsl:with-param name="priority">
	  <xsl:value-of select="$N + 1000"/>
	</xsl:with-param>
      </xsl:call-template>
    </xsl:for-each>

    <XSL:template match="*[@its:translate]" mode="verbatim" priority="10000">
      <XSL:call-template name="verbatimElement">
	<XSL:with-param name="class">
	  <XSL:text>translate</XSL:text>
	  <XSL:value-of select="@its:translate"/>
	</XSL:with-param>
      </XSL:call-template>
    </XSL:template>
     
    <XSL:template match="its:*" mode="verbatim"/>
    <XSL:template match="@its:*" mode="verbatim"/>

    <XSL:template name="makeIndent">
      <XSL:for-each select="ancestor::*">
	<XSL:value-of select="$spaceCharacter"/>
      </XSL:for-each>
    </XSL:template>

  </XSL:stylesheet>

  
</xsl:template>

<xsl:template name="makeTemplate">
  <xsl:param name="priority"/>
  <xsl:variable name="match">
    <xsl:choose>
      <xsl:when test="starts-with(@its:translateSelector,'//*/')">
	<xsl:value-of
	    select="substring-after(@its:translateSelector,'//*/')"/>
      </xsl:when>
    <xsl:when test="starts-with(@its:translateSelector,'//')">
      <xsl:value-of
	  select="substring-after(@its:translateSelector,'//')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of
	  select="@its:translateSelector"/>
    </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>
  <XSL:template match="{$match}" 
		mode="verbatim"
	      priority="{$priority }">
  <XSL:choose>
    <XSL:when test="self::*">
      <XSL:call-template name="verbatimElement">
	<XSL:with-param name="class">
	  <xsl:text>translate</xsl:text>
	  <xsl:value-of select="@its:translate"/>
	</XSL:with-param>
      </XSL:call-template>
    </XSL:when>
    <XSL:when test="namespace-uri()='http://www.w3.org/2005/11/its'"/>
    <XSL:otherwise>
      <XSL:call-template name="verbatimAttribute">
	<XSL:with-param name="class">
	  <xsl:text>translate</xsl:text>
	  <xsl:value-of select="@its:translate"/>
	</XSL:with-param>
      </XSL:call-template>
    </XSL:otherwise>
  </XSL:choose>
</XSL:template>
</xsl:template>

</xsl:stylesheet>
