(:

TODO:
- documentation for this
- paths have to encompass qualified names
:)

declare namespace its ="http://www.w3.org/2005/11/its";
declare namespace eg ="http://example.com#";
declare namespace saxon="http://saxon.sf.net/";
declare option saxon:output "method=text";

let $getDocumentRulesNamespaces :=
 for $namespaceUri in
  (
   for $namespaces in ./descendant-or-self::its:ns
   return string($namespaces/@its:uri)
  )
 return
 (concat(
 "&#xA;declare namespace ",
 (let $prefix := ./descendant-or-self::its:ns[@its:uri=$namespaceUri][1]/@its:prefix return string($prefix)),
 "='",
 $namespaceUri,
 "';"
 ))

let $declareNamespaces :=
  ("&#xA;declare namespace eg ='http://example.com#';&#xA;declare namespace its ='http://www.w3.org/2005/11/its';", $getDocumentRulesNamespaces,"&#xA;")

let $functionWritePath :=
"&#xA;declare function eg:writePath($node as item()*,$path as xs:string) as xs:string&#xA;{&#xA;if ($node[self::element() or self::attribute()]) then&#xA;  (let $position := count($node/preceding-sibling::*[name() = name($node)]) +1&#xA;  let $newpath := &#xA;    if ($node[self::element()]) then(&#xA;concat(name($node), '[', $position,']/', $path))&#xA;    else(&#xA;      concat($path, '@', name($node), '/'))&#xA;  return &#xA;  eg:writePath($node/parent::*,$newpath))&#xA;else &#xA; substring((concat('/',$path)),0,string-length($path)+1)&#xA;};&#xA;"

(: $translateTestNodeAutonomous, created as described in 1) above :)

let $inputDoc := document-uri(.)

(:
-------------------------------
Definitions for translatability 
------------------------------- :)

let $translateTestNodeAutonomous := 
  let $query :=
    let $string1 := concat("&#xA;if ($nodes[1] intersect doc('", $inputDoc, "')")
    let $string2 := concat(") then ("," ")
    let $string3 := ", attribute eg:translateSelector { eg:writePath($nodes[1],'')} ) else"
    for $documentRule in ./descendant-or-self::its:translateRule
      let $node := $documentRule/@its:selector
      let $translateType := 
      (concat("attribute eg:translateValue {'",
        if($documentRule/@its:translate="yes") then ("yes (autonomous)") else ("no (autonomous)"), "'}"))
      return concat($string1, $node, $string2, $translateType, $string3)
  return $query

let $translateTestNodeContigent := ("
if($nodes[1]/@its:translate) then
(
attribute eg:translateValue { concat ($nodes[1]/@its:translate, ' (contigent)') }, attribute eg:translateSelector {eg:writePath($nodes[1],'')}
) else
if($nodes[1]/ancestor::*[@its:translate] and $nodes[1]/self::element()) then
(
attribute eg:translateValue { concat(
$nodes[1]/ancestor::*[@its:translate][1]/@its:translate,' (inherited)') }, attribute
eg:translateSelector {eg:writePath($nodes[1],'')}
)
else
")

let $translateDefaultRuleAttributes := concat("&#xA;&#xA;if ($nodes[1] intersect doc('",$inputDoc,"')//@*) then (attribute eg:translateValue {'no (default)'}, attribute eg:translateSelector { eg:writePath($nodes[1],'')} )")
let $TranslateDefaultRuleElements := concat("&#xA;else if ($nodes[1] intersect doc('",$inputDoc, "')/descendant-or-self::*) then (attribute eg:translateValue {'yes (default)'}, attribute eg:translateSelector { eg:writePath($nodes[1],'')} )")

let $functionTestNodeTranslateBegin :=
("&#xA;declare function eg:testNodeTranslate($nodes as item()*) as item()*&#xA;{&#xA;if(empty($nodes)) then() else&#xA;( element eg:node {&#xA;")

let $functionTestNodeTranslateEnd := "else()&#xA;}&#xA;, eg:testNodeTranslate($nodes[position()>1]))&#xA;};&#xA;&#xA;"

let $functionTestNodeTranslateAll := ($functionTestNodeTranslateBegin, $translateTestNodeContigent, $translateTestNodeAutonomous, $translateDefaultRuleAttributes, $TranslateDefaultRuleElements, $functionTestNodeTranslateEnd)

(:
-------------------------------
Definitions for directionality 
-------------------------------
 :)

let $dirTestNodeAutonomous := 
  let $query :=
    let $string1 := concat("&#xA;if ($nodes[1] intersect doc('", $inputDoc, "')")
    let $string2 := concat(") then ("," ")
    let $string3 := ", attribute eg:dirSelector { eg:writePath($nodes[1],'')} ) else"
    for $documentRule in ./descendant-or-self::its:dirRule
      let $node := $documentRule/@its:selector
      let $dirType := 
      (concat("attribute eg:dirValue {'", $documentRule/@its:dir, " (autonomous)'}"))
      return concat($string1, $node, $string2, $dirType, $string3)
  return $query

let $dirTestNodeContigent := ("
if($nodes[1]/@its:dir) then
(
attribute eg:dirValue { concat ($nodes[1]/@its:dir, ' (contigent)') }, attribute eg:dirSelector {eg:writePath($nodes[1],'')}
) else
if($nodes[1]/ancestor::*[@its:dir]) then
(
attribute eg:dirValue { concat(
$nodes[1]/ancestor::*[@its:dir][1]/@its:dir, ' (inherited)' )}, attribute
eg:dirSelector {eg:writePath($nodes[1],'')}
)
else
")

let $dirDefaultRuleAttributes := concat("&#xA;&#xA;if ($nodes[1] intersect doc('",$inputDoc,"')//@*) then (attribute eg:dirValue {'ltr (default)'}, attribute eg:dirSelector { eg:writePath($nodes[1],'')} )")
let $DirDefaultRuleElements := concat("&#xA;else if ($nodes[1] intersect doc('",$inputDoc, "')/descendant-or-self::*) then (attribute eg:dirValue {'ltr (default)'}, attribute eg:dirSelector { eg:writePath($nodes[1],'')} )")

let $functionTestNodeDirBegin :=
("&#xA;declare function eg:testNodeDir($nodes as item()*) as item()*&#xA;{&#xA;if(empty($nodes)) then() else&#xA;( element eg:node {&#xA;")

let $functionTestNodeDirEnd := "else()&#xA;}&#xA;, eg:testNodeDir($nodes[position()>1]))&#xA;};&#xA;&#xA;"

let $functionTestNodeDirAll := ($functionTestNodeDirBegin, $dirTestNodeContigent, $dirTestNodeAutonomous, $dirDefaultRuleAttributes, $DirDefaultRuleElements, $functionTestNodeDirEnd)

(:
-------------------------------
Main program
-------------------------------:)


(: the input document is in $inputDoc :)

let $processInput := concat("let$inputDoc := (doc('", $inputDoc, "')//*[not(namespace-uri()='http://www.w3.org/2005/11/its')] | doc('", $inputDoc, "')//@*[not(namespace-uri()='http://www.w3.org/2005/11/its') and not(namespace-uri()='http://www.w3.org/XML/1998/namespace')])&#xA;return &#xA; element eg:selections { element eg:TranslateSelections { eg:testNodeTranslate($inputDoc)&#xA; }, element eg:dirSelections { eg:testNodeDir($inputDoc)&#xA; }&#xA;}&#xA;")

  return (
$declareNamespaces, $functionWritePath, $functionTestNodeTranslateAll, $functionTestNodeDirAll, $processInput
)
