<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:its="http://www.w3.org/2005/11/its" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:datc="http://example.com/datacats" version="2.0">
   <xsl:output method="xml" indent="yes" encoding="utf-8"/>
   <xsl:strip-space elements="*"/>
   <xsl:template match="*|@*" mode="get-full-path">
      <xsl:apply-templates select="parent::*" mode="get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:if test="count(. | ../@*) = count(../@*)">@</xsl:if>
      <xsl:value-of select="name()"/>
      <xsl:if test="self::element() and parent::element()">
         <xsl:text>[</xsl:text>
         <xsl:value-of select="1+count(preceding-sibling::*[name()=name(current())])"/>
         <xsl:text>]</xsl:text>
      </xsl:if>
   </xsl:template>
   <xsl:template name="writeOutput">
      <xsl:param name="outputType">no-value</xsl:param>
      <xsl:param name="outputValue" as="node()*">
         <output>no-value</output>
      </xsl:param>
      <xsl:element name="node">
         <xsl:attribute name="path">
            <xsl:apply-templates mode="get-full-path" select="."/>
         </xsl:attribute>
         <xsl:attribute name="outputType">
            <xsl:value-of select="$outputType"/>
         </xsl:attribute>
         <xsl:copy-of select="$outputValue"/>
      </xsl:element>
   </xsl:template>
   <xsl:template match="/">
      <nodeList>
         <xsl:element name="nodeList">
            <xsl:attribute name="datacat">
               <xsl:text>product</xsl:text>
            </xsl:attribute>
            <xsl:apply-templates mode="product">
               <xsl:with-param name="existingDataCatValue">no-value</xsl:with-param>
            </xsl:apply-templates>
         </xsl:element>
      </nodeList>
   </xsl:template>
   <xsl:template match="@xyzAttr" mode="product"/>
   <xsl:template match="*[not(namespace-uri()='http://www.w3.org/2005/11/its')]" mode="product" priority="-1000">
      <xsl:param name="existingDataCatValue" as="node()*">no-value</xsl:param>
      <xsl:if test="$existingDataCatValue='no-value'">
         <xsl:call-template name="writeOutput">
            <xsl:with-param name="outputType">no-value</xsl:with-param>
            <xsl:with-param name="outputValue" as="node()*">
               <output/>
            </xsl:with-param>
         </xsl:call-template>
         <xsl:apply-templates mode="product" select="@* | element()">
            <xsl:with-param name="existingDataCatValue" as="node()*">no-value</xsl:with-param>
         </xsl:apply-templates>
      </xsl:if>
   </xsl:template>
   <xsl:template match="@*[not(namespace-uri()='http://www.w3.org/2005/11/its')]" mode="product" priority="-1000">
      <xsl:param name="existingDataCatValue" as="node()*">no-value</xsl:param>
   </xsl:template>
   <xsl:template mode="productPointerMarkupCopy" match="@sku | prod-name | detail | price/@units | @xyzPointer" priority="1">
      <xsl:choose>
         <xsl:when test="self::element()">
            <xsl:copy>
               <xsl:apply-templates select="@* | node()"/>
            </xsl:copy>
         </xsl:when>
         <xsl:otherwise>
            <output>
               <xsl:copy/>
            </output>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template mode="product" match="//line-item[@is-a='product']" priority="1">
      <xsl:call-template name="writeOutput">
         <xsl:with-param name="outputType">new-value-global</xsl:with-param>
         <xsl:with-param name="outputValue" as="node()*">
            <output>
               <xsl:apply-templates select="@sku | prod-name | detail | price/@units | @xyzPointer" mode="                                     productPointerMarkupCopy"/>
            </output>
         </xsl:with-param>
      </xsl:call-template>
      <xsl:apply-templates mode="product" select="@* | element()">
         <xsl:with-param name="existingDataCatValue" as="node()*">
            <output>
               <xsl:apply-templates select="@sku | prod-name | detail | price/@units | @xyzPointer" mode="                                     productPointerMarkupCopy"/>
            </output>
         </xsl:with-param>
      </xsl:apply-templates>
   </xsl:template>
   <xsl:template mode="productPointerMarkupCopy" match="@sku | name | description | price/@currency | name/trademark | @xyzPointer" priority="2">
      <xsl:choose>
         <xsl:when test="self::element()">
            <xsl:copy>
               <xsl:apply-templates select="@* | node()"/>
            </xsl:copy>
         </xsl:when>
         <xsl:otherwise>
            <output>
               <xsl:copy/>
            </output>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template mode="product" match="//product" priority="2">
      <xsl:call-template name="writeOutput">
         <xsl:with-param name="outputType">new-value-global</xsl:with-param>
         <xsl:with-param name="outputValue" as="node()*">
            <output>
               <xsl:apply-templates select="@sku | name | description | price/@currency | name/trademark | @xyzPointer" mode="                                     productPointerMarkupCopy"/>
            </output>
         </xsl:with-param>
      </xsl:call-template>
      <xsl:apply-templates mode="product" select="@* | element()">
         <xsl:with-param name="existingDataCatValue" as="node()*">
            <output>
               <xsl:apply-templates select="@sku | name | description | price/@currency | name/trademark | @xyzPointer" mode="                                     productPointerMarkupCopy"/>
            </output>
         </xsl:with-param>
      </xsl:apply-templates>
   </xsl:template>
   <xsl:template mode="productPointerMarkupCopy" match="@sku | name | description | price/@currency | @xyzPointer" priority="3">
      <xsl:choose>
         <xsl:when test="self::element()">
            <xsl:copy>
               <xsl:apply-templates select="@* | node()"/>
            </xsl:copy>
         </xsl:when>
         <xsl:otherwise>
            <output>
               <xsl:copy/>
            </output>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template mode="product" match="//product" priority="3">
      <xsl:call-template name="writeOutput">
         <xsl:with-param name="outputType">new-value-global</xsl:with-param>
         <xsl:with-param name="outputValue" as="node()*">
            <output>
               <xsl:apply-templates select="@sku | name | description | price/@currency | @xyzPointer" mode="                                     productPointerMarkupCopy"/>
            </output>
         </xsl:with-param>
      </xsl:call-template>
      <xsl:apply-templates mode="product" select="@* | element()">
         <xsl:with-param name="existingDataCatValue" as="node()*">
            <output>
               <xsl:apply-templates select="@sku | name | description | price/@currency | @xyzPointer" mode="                                     productPointerMarkupCopy"/>
            </output>
         </xsl:with-param>
      </xsl:apply-templates>
   </xsl:template>
</xsl:stylesheet>