<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:tr="http://www.w3.org/2005/11/its/testoutputcompare"
		xmlns:o="http://www.w3.org/2005/11/its/testoutputformat"
		xmlns:xs="http://www.w3.org/2001/XMLSchema"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:h="http://www.w3.org/1999/xhtml"
		xmlns="http://www.w3.org/1999/xhtml"
		version="2.0" exclude-result-prefixes="xs h">
<xsl:output  method="xhtml" encoding="utf-8"
			 indent="yes" doctype-public="-//W3C//DTD XHTML 1.0
						      Transitional//EN"  doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" exclude-result-prefixes="tr o"/>
  <xsl:variable name="compareResult" select="doc('testresults.xml')"/>
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="h:td[parent::h:tr/parent::h:table[@class='testresulttable'] and position()>=4 and child::h:a]" exclude-result-prefixes="tr o">
    <xsl:variable name="test" as="xs:string"><xsl:value-of select="../@id"/></xsl:variable>
    <td>
      <xsl:for-each select="@*"><xsl:copy/></xsl:for-each>
      <xsl:variable name="impl" select="string(position()-4)"/>
      <xsl:variable name="errorList"
		    select="$compareResult//tr:errorList[@implementation[contains(.,$impl)] and @relatedTest[.=$test]]"/>
      <xsl:attribute name="bgcolor">
	<xsl:choose>
	  <xsl:when test="$errorList/child::* or not($errorList)">
	    <xsl:text>#ff0000</xsl:text>
	  </xsl:when>
	  <xsl:otherwise><xsl:text>#00FF00</xsl:text></xsl:otherwise>
	</xsl:choose>
      </xsl:attribute> 
      <xsl:apply-templates select="node()"/>
    </td>
  </xsl:template>
</xsl:stylesheet>
