<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:tr="http://www.w3.org/2005/11/its/testoutputcompare"
    xmlns:o="http://www.w3.org/2005/11/its/testoutputformat"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="2.0" exclude-result-prefixes="xs">
    <xsl:output method="xml" indent="yes" encoding="utf-8"/>
    <xsl:template match="/">
        <tr:testResults>
            <xsl:for-each select="//tr:resultFile">
                <xsl:call-template name="compareResult">
                    <xsl:with-param name="expectedResult" as="item()">
                        <xsl:copy-of
                            select="doc(concat('expected/',substring-before(../@name,'.xml'),'-result.xml'))"
                        />
                    </xsl:with-param>
                    <xsl:with-param name="actualResult" as="item()">
                        <xsl:copy-of select="doc(string(@location))"/>
                    </xsl:with-param>
                    <xsl:with-param name="implname">
                        <xsl:value-of select="@implementation"/>
                    </xsl:with-param>
                    <xsl:with-param name="inputfilename">
                        <xsl:value-of select="../@name"/>
                    </xsl:with-param>
                    <xsl:with-param name="relatedTest">
                        <xsl:value-of select="../@relatedTest"/>
                    </xsl:with-param>
                </xsl:call-template>
            </xsl:for-each>
        </tr:testResults>
    </xsl:template>
    <xsl:template mode="filterText" match="element() | @*">
        <xsl:copy>
            <xsl:apply-templates select="@* | element()" mode="filterText"/>
        </xsl:copy>
    </xsl:template>
    <xsl:template mode="filterText" match="text()"/>
    <xsl:template name="compareResult">
        <xsl:param name="expectedResult"/>
        <xsl:param name="actualResult"/>
        <xsl:param name="implname" as="xs:string"/>
        <xsl:param name="inputfilename" as="xs:string"/>
        <xsl:param name="relatedTest" as="xs:string"/>
        <tr:errorList implementation="{$implname}" file="{$inputfilename}"
            relatedTest="{$relatedTest}">
            <xsl:for-each select="$expectedResult/*/o:nodeList/o:node/@path">
                <xsl:variable name="pathExpected" as="node()" select="."/>
                <xsl:variable name="pathActual" as="node()*"
                    select="$actualResult/*/o:nodeList/o:node[@path = $pathExpected]/@path"/>
                <xsl:choose>
                    <xsl:when test="exists($pathActual)">
                        <xsl:variable name="expectedOutput">
                            <o:output>
                                <xsl:apply-templates
                                    select="$pathExpected/../o:output/@* | $pathExpected/../o:output/element()"
                                    mode="filterText"/>
                            </o:output>
                        </xsl:variable>
                        <xsl:variable name="actualOutput">
                            <o:output>
                                <xsl:apply-templates
                                    select="$pathActual/../o:output/@* | $pathActual/../o:output/element()"
                                    mode="filterText"/>
                            </o:output>
                        </xsl:variable>
                        <xsl:variable name="expectedNamesValues">
                            <xsl:for-each select="$expectedOutput//element() | $expectedOutput//@*">
                                <xsl:value-of select="concat(local-name(),.)"/>
                            </xsl:for-each>
                        </xsl:variable>
                        <xsl:variable name="actualNamesValues">
                            <xsl:for-each select="$actualOutput//element() | $actualOutput//@*">
                                <xsl:value-of select="concat(local-name(),.)"/>
                            </xsl:for-each>
                        </xsl:variable>                        
                        <xsl:variable name="identitycheck">
                            <!-- <xsl:call-template name="compareNodes">
                                <xsl:with-param name="expected" select="$expectedOutput//element() | $expectedOutput//@*"/>
                                <xsl:with-param name="actual" select="$actualOutput//element() | $actualOutput//@*"/>
                            </xsl:call-template>-->
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="string($expectedNamesValues) = string($actualNamesValues)"/>
                            <xsl:otherwise>
                                <tr:error path="{$pathExpected}"
                                    datacategory="{string($pathExpected/../../@datacat)}"
                                    type="result-differs">
                                    <tr:expectedResult>
                                        <xsl:value-of select="$expectedNamesValues"/>
                                        <!-- <xsl:copy-of select="$pathExpected/../o:output"/> -->
                                    </tr:expectedResult>
                                    <tr:actualResult>
                                        <xsl:value-of select="$actualNamesValues"/>
                                        <!-- <xsl:copy-of select="$pathActual/../o:output"/> -->
                                    </tr:actualResult>
                                </tr:error>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <tr:error path="{$pathExpected}"
                            datacategory="{$pathExpected/../../@datacat}" type="node-not-found"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </tr:errorList>
    </xsl:template>
<!--     <xsl:template name="compareNodes">
        <xsl:param name="expected">notset</xsl:param>
        <xsl:param name="actual">notset</xsl:param>
        <xsl:variable name="nodeNumber">
            <xsl:value-of select="count(for $nodes in $expected//node() return $nodes)"/>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$nodeNumber=0">identical</xsl:when>
            <xsl:when
                test="name($expected[0]) != name($actual[0]) or string($expected[0]) != string($actual[0])"
                >different</xsl:when>
            <xsl:when
                test="$nodeNumber &gt;0 and not(name($expected[0]) != name($actual[0]) or string($expected[0]) != string($actual[0]))">
                <xsl:call-template name="compareNodes">
                    <xsl:with-param name="expected" select="$expected//node()[position()&gt;0]"/>
                    <xsl:with-param name="actual" select="$expected//node()[position()&gt;0]"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template> -->
</xsl:stylesheet>
