declare namespace my = "http://www.example.com/myns";
declare function my:compareResults($expected as node()*, $actual as node()*, $implname as xs:string, $inputfilename as xs:string) as item()*
{
<errorList implementation="{$implname}" file="{$inputfilename}">{
for $pathExpected in $expected/*/nodeList/node/@path
let $pathActual := $actual/*/nodeList/node[@path = $pathExpected]/@path
return
if (exists($pathActual)) then 
if(deep-equal($pathExpected/../output , $pathActual/../output))
then()
else
(<error path="{$pathExpected}" datacategory="{string($pathExpected/../../@datacat)}" type="result-differs">
<expectedResult>{$pathExpected/../output}</expectedResult>
<actualResult>{$pathActual/../output}</actualResult>
</error>)
else(<error path="{$pathExpected}" datacategory="{string($pathExpected/../../@datacat)}" type="node-not-found"/>)
}</errorList>
};
<testResults>{
for $resultDoc in doc("input-file-list.xml")//resultFile
let $actualResult := doc($resultDoc/@location)
let $expectedResult := doc(concat("expected/",substring-before($resultDoc/../@name,".xml"),"-result.xml"))
return 
my:compareResults($expectedResult, $actualResult, string($resultDoc/@implementation), string($resultDoc/../@name))
}</testResults>