<?xml version="1.0"?>

<!-- ===================================================================== -->
<!--                                                                       -->
<!-- harness-ps-create-bottom.xslt                                         -->
<!--                                                                       -->
<!-- This is an XSLT stylesheet for generating the HTML harness, from      -->
<!-- the XML test case description written according to the test case DTD. -->
<!--                                                                       -->
<!-- This version puts side-by-side PNG with SVG with the                  -->
<!-- Operator Script below.                                                -->
<!--                                                                       -->
<!-- Other stylesheets referenced and included                             --> 
<!-- (must be in same directory):                                          -->
<!--                                                                       -->
<!--       generateNames.xslt                                              -->
<!--       navigationBar-svg.xslt                                          -->
<!--                                                                       -->
<!-- Author : Jon Ferraiolo 23-may-2000, based on prior work from          -->
<!--                          Lofton Henderson, 2-mar-2000 and             -->
<!--                          Jon Ferraiolo,  12-Jan-2000                  -->
<!--                                                                       -->
<!-- History:                                                              -->
<!--  23-May-2000 - LH/JF: created.                                        -->
<!--   2-Mar-2000 - LH/JF: created.                                        -->
<!--  10-Apr-2000 - LH: fix toc link.                                      -->
<!--  18-May-2000 - LH:                                                    -->
<!--                disable top nav. bar and name (leave lower ones);      -->
<!--                fix typo (missing "<") in named template (GNTTC);      -->
<!--                fix named templates, either BEnbr or DTnbr, not both;  -->
<!--                disable parent, child links (make point to self).      -->
<!--  21-Jan-2001 - LH: substantial rewrite for clarity, maintainability:  -->
<!--                ** factor GenerateXXXTestCaseName named templates to   -->
<!--                   external file, and "xsl:include ..." it.            -->
<!--                ** factor NavigationBar named template to external     -->
<!--                   file navigationBar-svg.xslt (there is a "-html"     -->
<!--                   version, for all-SVG harness set).                  -->
<!--                ** eliminate xsl:text usage, using attribute-value     -->
<!--                   templates instead.                                  -->
<!--                ** use xsl:variable for relative test case names       -->
<!--                ** replace xsl:text in 'style' element by xsl:comment  -->
<!--                ** exclude-result-prefixes to get rid of extraneous    -->
<!--                   xmlns:xlink declaration in result tree.             -->
<!--  23-jan-2001 - LH: define 'nameSuffix' parameter (value "-ps") for    -->
<!--                navigationBar-html.xslt template.                      -->
<!--  23-jan-2001 - LH: fix missing "-ps" in 'link' literal result elts.   -->
<!--                                                                       -->
<!-- ===================================================================== -->

<xsl:stylesheet version="1.0" 
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html" indent="yes"/>
<xsl:output doctype-system="http://www.w3.org/TR/REC-html40/loose.dtd" 
            doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN" />

<!-- Shouldn't be necessary w/ HTML, but xalan generates xml-decl otherwise -->
<xsl:output omit-xml-declaration="yes"/>

<!-- ********** SVGTestCase ************** -->
<xsl:template match="SVGTestCase">

<!-- Set up test cases name variables for repeatedly reused names, 
     and for cleaner use in attribute value templates -->
<xsl:variable name="thisCaseName"><xsl:call-template name="GenerateNameThisTestCase"/></xsl:variable>
<xsl:variable name="nextCaseName"><xsl:call-template name="GenerateNameNextTestCase"/></xsl:variable>
<xsl:variable name="previousCaseName"><xsl:call-template name="GenerateNamePreviousTestCase"/></xsl:variable>
<xsl:variable name="parentCaseName"><xsl:call-template name="GenerateNameParentTestCase"/></xsl:variable>
<xsl:variable name="childCaseName"><xsl:call-template name="GenerateNameChildTestCase"/></xsl:variable>

<html>
<head>
  <meta http-equiv="Content-Language" content="en-us" />
  <meta http-equiv="Content-Type" content="text/html; charset=windows-1252" />
  <title><xsl:value-of select="$thisCaseName"/></title>
  
  <xsl:if test="Previous">
    <link rel="prev" href="{$previousCaseName}-ps.html" />
  </xsl:if>

  <xsl:if test="Next">
    <link rel="prev" href="{$nextCaseName}-ps.html" />
  </xsl:if>

  <xsl:if test="Parent">
    <link rel="prev" href="{$parentCaseName}-ps.html" />
  </xsl:if>

  <xsl:if test="Child">
    <link rel="prev" href="{$childCaseName}-ps.html" />
  </xsl:if>

  <link rel="contents" href="toc-ps.html" />

  <!-- Note (JF): The contents of following style element should
       be moved into an external style sheet. -->
  <!-- Note (LH): xsl:comment replaced old xsl:text usage. XT
       keeps nicely aligned output, but xalan uglifies it. -->

  <style>
      <xsl:comment>
        .verdana0    { font-family: Verdana; 
                       font-size: 10pt; 
                       word-spacing: 0; 
                       line-height: 200%;
                       text-align: Left; 
                       margin-top: 0; 
                       margin-bottom: 0 }
        .verdana1    { font-family: Verdana; 
                       font-size: 10pt; 
                       word-spacing: 0; 
                       line-height: 100%;
                       text-align: Left; 
                       margin-top: 0; 
                       margin-bottom: 0 }
     </xsl:comment>
  </style>

</head>

<body>

  <!-- Generate navigation bar -->
  <xsl:call-template name="NavigationBar">
     <xsl:with-param name="nameSuffix">-ps</xsl:with-param>
  </xsl:call-template>

  <!-- LH.  Code added to process OperatorScript into HTML <P>'s.  -->  
  <xsl:for-each select="OperatorScript/Paragraph">
    <p> 
       <xsl:apply-templates select="."/>
    </p>
  </xsl:for-each>

</body>
</html>

</xsl:template>



<!-- Include the utility templates for name and navbar generation -->
<xsl:include href="generateNames.xslt" />
<xsl:include href="navigationBar-html.xslt" />


<!-- ********** DEFAULT ACTION: COPY ENTIRE CONTENTS ************** -->
<!-- (Relying on normal default template rules.) -->

</xsl:stylesheet>

