<?xml version="1.0"?>

<!-- ===================================================================== -->
<!--                                                                       -->
<!-- navigationBar-svg.xslt                                                -->
<!--                                                                       -->
<!-- This XSLT stylesheet contains a common named template: for generation -->
<!-- of the navigation bar for SVG harness-generating stylesheets of the   -->
<!-- SVG test suite project. It should be included in those stylesheets    -->
<!-- using the xsl:include element.                                        -->
<!--                                                                       -->
<!-- Named Templates:                                                      -->
<!--                                                                       -->
<!--        NavigationBar                                                  -->
<!--                                                                       -->
<!-- Note.  Uses named template GenerateNameXXXTestCase, which must be     -->
<!-- available (directly or included) in stylesheet which includes this.   -->
<!--                                                                       -->
<!-- Caveat.  The XT processor does not correctly implement the attribute  -->
<!--                     exclude-result-prefixes="xlink"                   -->
<!-- on the xsl:stylesheet element, and unwanted "xmlns:xlink=.." appears. -->
<!-- Xalan handles it correctly.                                           -->
<!--                                                                       -->
<!-- Author : Lofton Henderson, 22-dec-2000.                               -->
<!--                                                                       -->
<!-- History:                                                              -->
<!--  22-dec-2000 - LH: created, by factoring the navbar template out of   -->
<!--                the SVG-generating "CreateSVGHarness.xslt"             -->
<!--                stylesheet.                                            -->
<!--  23-jan-2001 - LH: cleanup, replace xsl:text usage w/ xsl:attribute   -->
<!--                and literal result elements for 'a' elt.               -->
<!--                                                                       -->
<!-- ===================================================================== -->

<xsl:stylesheet version="1.0"
xmlns:xlink="http://www.w3.org/1999/xlink"  
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
exclude-result-prefixes="xlink">

<!-- ********** NavigationBar ************** -->
<xsl:template name="NavigationBar">

      <!-- 'Previous' link -->
      <xsl:if test="Previous">
        <a>
          <xsl:attribute name="xlink:href"><xsl:call-template name="GenerateNamePreviousTestCase"/>-nav.svg</xsl:attribute>
          <text style="font-family:Verdana;font-size:12;fill:blue" x="72" y="495">Previous</text>
        </a>
      </xsl:if>

      <!-- 'Next' link -->
      <xsl:if test="Next">
        <a>
          <xsl:attribute name="xlink:href"><xsl:call-template name="GenerateNameNextTestCase"/>-nav.svg</xsl:attribute>
          <text style="font-family:Verdana;font-size:12;fill:blue" x="144" y="495">Next</text>
        </a>
      </xsl:if>

      <!-- 'Parent' link -->
      <xsl:if test="Parent">
        <a>
          <!-- Parent link not implemented yet, 'parent' points to 'this' for now -->
          <xsl:attribute name="xlink:href"><xsl:call-template name="GenerateNameThisTestCase"/>-nav.svg</xsl:attribute>
          <!-- This is the real code, when 'parent' feature is activated...
          <xsl:attribute name="xlink:href"><xsl:call-template name="GenerateNameParentTestCase"/>-nav.svg</xsl:attribute>
          -->
          <text style="font-family:Verdana;font-size:12;fill:blue" x="191" y="495">Parent</text>
        </a>
      </xsl:if>

      <!-- 'Child' link -->
      <xsl:if test="Child">
        <a>
          <!-- Child link not implemented yet, 'child' points to 'this' for now -->
          <xsl:attribute name="xlink:href"><xsl:call-template name="GenerateNameThisTestCase"/>-nav.svg</xsl:attribute>
          <!-- This is the real code, when 'child' feature is activated...
          <xsl:attribute name="xlink:href"><xsl:call-template name="GenerateNameChildTestCase"/>-nav.svg</xsl:attribute>
          -->
          <text style="font-family:Verdana;font-size:12;fill:blue" x="248" y="495">Child</text>
        </a>
      </xsl:if>

      <!-- 'Contents' link -->
      <a xlink:href="toc-sv.svg">
        <text style="font-family:Verdana;font-size:12;fill:blue" x="293" y="495">Contents</text>
      </a>

</xsl:template>


</xsl:stylesheet>

