<?xml version="1.0"?>

<!-- ===================================================================== -->
<!--                                                                       -->
<!-- navigationBar-html.xslt                                               -->
<!--                                                                       -->
<!-- This XSLT stylesheet contains a common named template: for generation -->
<!-- of the navigation bar for HTML harness-generating stylesheets of the  -->
<!-- SVG test suite project. It should be included in those stylesheets    -->
<!-- using the xsl:include element.                                        -->
<!--                                                                       -->
<!-- Parameter(s):  nameSuffix                                             -->
<!--                                                                       -->
<!--   Allows for adding a suffix to the HTML filenames of navigation      -->
<!--   neighbors.  These names are of form:  testCaseName.html.  Suffix    -->
<!--   will result in testCaseName-suffix.html.  Default is "" (null).     -->
<!--   Example:  if suffix is "-ps" (defined in calling template using     -->
<!--   xsl:with-param), then names will be:  testCaseName-ps.html.         -->
<!--                                                                       -->
<!-- Named Templates:                                                      -->
<!--                                                                       -->
<!--        NavigationBar                                                  -->
<!--                                                                       -->
<!-- Note.  Uses named template GenerateNameXXXTestCase, which must be     -->
<!-- available (directly or included) in stylesheet which includes this.   -->
<!--                                                                       -->
<!-- Author : Lofton Henderson, 22-dec-2000.                               -->
<!--                                                                       -->
<!-- History:                                                              -->
<!--  22-dec-2000, LH - created, by factoring the navbar template out of   -->
<!--                the various HTML-generating "CreateXXXHarness.xslt"    -->
<!--                stylesheets.                                           -->
<!--  01-jan-2000, LH - cleanup, replace xsl:text usage w/ xsl:attribute   -->
<!--  22-jan-2000, LH - add target="_top" to 'a' elts, for multi-frame     -->
<!--                harnesses (unnecessary but harmless on single-frame).  -->
<!--  23-jan-2000, LH - add 'nameSuffix' parameter, to distinguish simple  -->
<!--                PNG-only harness from multi-frame harness.             -->
<!--                                                                       -->
<!-- ===================================================================== -->

<xsl:stylesheet version="1.0" 
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- ********** NavigationBar ************** -->
<xsl:template name="NavigationBar">

  <!-- 'nameSuffix' parameter, default "", for multi-frame harnesses -->

  <xsl:param name="nameSuffix"></xsl:param>

  <div class="navbar" align="center">
    <p>


      <!-- Note. 'target' attributes below are needed for multi-frame -->
      <!-- harnesses;  unnecessary but harmless on the PNG-only harness. -->

      <!-- 'Previous' link -->
      <xsl:if test="Previous">
        <a target="_top"><xsl:attribute name="href"><xsl:call-template name="GenerateNamePreviousTestCase"/><xsl:value-of select="$nameSuffix"/>.html</xsl:attribute>previous</a>
         <!-- Next stuff is to get space-char plus nbsp-entity into HTML -->
         <xsl:text disable-output-escaping="yes"> &amp;nbsp;</xsl:text>
      </xsl:if>

      <!-- 'Next' link -->
      <xsl:if test="Next">
        <a target="_top"><xsl:attribute name="href"><xsl:call-template name="GenerateNameNextTestCase"/><xsl:value-of select="$nameSuffix"/>.html</xsl:attribute>next</a> 
         <xsl:text disable-output-escaping="yes"> &amp;nbsp;</xsl:text>
      </xsl:if>

      <!-- 'Parent' link -->
      <!-- For now, 'parent' just points at current test case itself -->
      <!-- (When 'parent' feature is activated, change "This" to "Parent" below.) -->
      <xsl:if test="Parent">
        <a target="_top"><xsl:attribute name="href"><xsl:call-template name="GenerateNameThisTestCase"/><xsl:value-of select="$nameSuffix"/>.html</xsl:attribute>parent</a> 
         <xsl:text disable-output-escaping="yes"> &amp;nbsp;</xsl:text>
      </xsl:if>

      <!-- 'Child' link -->
      <!-- For now, 'child' just points at current test case itself -->
      <!-- (When 'child' feature is activated, change "This" to "Child" below.) -->
      <xsl:if test="Child">
        <a target="_top"><xsl:attribute name="href"><xsl:call-template name="GenerateNameThisTestCase"/><xsl:value-of select="$nameSuffix"/>.html</xsl:attribute>child</a> 
         <xsl:text disable-output-escaping="yes"> &amp;nbsp;</xsl:text>
      </xsl:if>

      <!-- 'Contents' (table of contents) link -->
      <a  target="_top" href="toc{$nameSuffix}.html">contents</a> 

    </p>
  </div>
</xsl:template>


</xsl:stylesheet>

