<?xml version="1.0"?>

<!-- ===================================================================== -->
<!--                                                                       -->
<!-- CreateHTMLHarness.xslt                                                -->
<!--                                                                       -->
<!-- This XSLT stylesheet generates the HTML PNG-only harness, from        -->
<!-- the XML test case description written according to the test case DTD. -->
<!--                                                                       -->
<!-- The harness puts the PNG above and Operator Script below.             -->
<!--                                                                       -->
<!-- Other stylesheets referenced and included                             --> 
<!-- (must be in same directory):                                          -->
<!--                                                                       -->
<!--       generateNames.xslt                                              -->
<!--       navigationBar-html.xslt                                         -->
<!--                                                                       -->
<!--                                                                       -->
<!-- Author : Lofton Henderson, 2-mar-2000                                 -->
<!--          (from initial work by Jon Ferraiolo,  12-Jan-2000)           -->
<!--                                                                       -->
<!-- History:                                                              -->
<!--  02-Mar-2000, LH/JF - created.                                        -->
<!--  10-Apr-2000, LH - fix toc link.                                      -->
<!--  18-May-2000, LH -                                                    -->
<!--                disable top nav. bar and name (leave lower ones);      -->
<!--                fix typo (missing "<") in named template (GNTTC);      -->
<!--                fix named templates, either BEnbr or DTnbr, not both;  -->
<!--                disable parent, child links (make point to self).      -->
<!--  22-May-2000, LH - chg xsl:text for DOCTYPE to "xsl:output doctype-.."-->
<!--  22-Dec-2000, LH - factor GenerateNameXXXTestCase named templates to  -->
<!--                external file, and "xsl:include ..." it.               -->
<!--  22-Dec-2000, LH - factor NavigationBar named template to external    -->
<!--                file navigationBar-html.xslt (there is a "-svg"        -->
<!--                version, for all-SVG harness set),                     -->
<!--                and "xsl:include .." it.                               -->
<!--  01-Jan-2001, LH - significant rewrites to eliminate much xsl:text    -->
<!--                usage, using xsl:attribute instead.                    -->
<!--  01-Jan-2001, LH - replace xsl:text in 'style' element by xsl:comment -->
<!--  01-Jan-2001, LH - use xsl:variable for relative test case names      -->
<!--  03-Jan-2001, LH - replace xsl:attribute w/ attribute-value templates -->
<!--                                                                       -->
<!--                                                                       -->
<!-- ===================================================================== -->

<xsl:stylesheet version="1.0" 
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html" indent="yes"/>
<xsl:output doctype-system="http://www.w3.org/TR/REC-html40/loose.dtd" 
            doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN" />

<!-- Shouldn't be necessary w/ HTML, but xalan generates xml-decl otherwise -->
<xsl:output omit-xml-declaration="yes"/>

<!-- ********** SVGTestCase ************** -->
<xsl:template match="SVGTestCase">

<!-- Set up test cases name variables for repeatedly reused names, 
     and for cleaner use in attribute value templates -->
<xsl:variable name="thisCaseName"><xsl:call-template name="GenerateNameThisTestCase"/></xsl:variable>
<xsl:variable name="nextCaseName"><xsl:call-template name="GenerateNameNextTestCase"/></xsl:variable>
<xsl:variable name="previousCaseName"><xsl:call-template name="GenerateNamePreviousTestCase"/></xsl:variable>
<xsl:variable name="parentCaseName"><xsl:call-template name="GenerateNameParentTestCase"/></xsl:variable>
<xsl:variable name="childCaseName"><xsl:call-template name="GenerateNameChildTestCase"/></xsl:variable>

<html>
<head>
  <meta http-equiv="Content-Language" content="en-us" />
  <meta http-equiv="Content-Type" content="text/html; charset=windows-1252" />
  <title><xsl:value-of select="$thisCaseName"/></title>
  
  <!-- HTML 'link' elements for the navigation-bar links -->
  <xsl:if test="Previous">
    <link rel="prev" href="{$previousCaseName}.html" />
  </xsl:if>

  <xsl:if test="Next">
    <link rel="prev" href="{$nextCaseName}.html" />
  </xsl:if>

  <xsl:if test="Parent">
    <link rel="prev" href="{$parentCaseName}.html" />
  </xsl:if>

  <xsl:if test="Child">
    <link rel="prev" href="{$childCaseName}.html" />
  </xsl:if>

  <link rel="contents" href="toc.html" />

  <!-- Note (JF): The contents of following style element should
       be moved into an external style sheet. -->
  <!-- Note (LH): xsl:comment replaced old xsl:text usage. XT
       keeps nicely aligned output, but xalan uglifies it. -->

  <style>
      <xsl:comment>
        .verdana0    { font-family: Verdana; 
                       font-size: 10pt; 
                       word-spacing: 0; 
                       line-height: 200%;
                       text-align: Left; 
                       margin-top: 0; 
                       margin-bottom: 0 }
        .verdana1    { font-family: Verdana; 
                       font-size: 10pt; 
                       word-spacing: 0; 
                       line-height: 100%;
                       text-align: Left; 
                       margin-top: 0; 
                       margin-bottom: 0 }
     </xsl:comment>
  </style>
 
</head>

<body>

<!-- Following code would add top navbar and name (deactivated per WG decision)...
  <xsl:call-template name="NavigationBar"/>
  <hr class="navbar" />
  <p style="text-align:center; font-weight:bold; font-family:Helvetica, sans-serif">SVG Conformance Test  - <xsl:value-of select="$thisCaseName"/></p>
-->


  <!-- Code for PNG-only HTML harness follows -->
  <p>
     <img border="0" width="450" height="450" src="{$thisCaseName}.png"
          alt="PNG file {$thisCaseName}.png, which shows the correct result as a raster image" />
  </p>

  
<!-- alternate code, for PNG [via IMG] and SVG [via EMBED] side-by-side in a table row...
  <table>
  <tr>
    <td>
     <img border="0" width="450" height="450" src="{$thisCaseName}.png"
          alt="PNG file {$thisCaseName}.png, which shows the correct result as a raster image" />
    </td>
    <td>
      <embed width="450" height="450" src="{$thisCaseName}.svg" />
    </td>
  </tr>
  </table>
-->

  <!-- Generate the navigation bar itself -->
  <hr class="navbar" />

  <xsl:call-template name="NavigationBar"/>


  <!-- Process each OperatorScript paragraph into HTML <P>'s.  -->  
  <xsl:for-each select="OperatorScript/Paragraph">
    <p> 
       <xsl:apply-templates select="."/>
    </p>
  </xsl:for-each>

</body>
</html>

</xsl:template>

<!-- Include the utility templates for name and navbar generation -->
<xsl:include href="generateNames.xslt" />
<xsl:include href="navigationBar-html.xslt" />


<!-- ********** DEFAULT ACTION: COPY ENTIRE CONTENTS ************** -->
<!-- (Relying on normal default template rules.) -->

</xsl:stylesheet>

