<?xml version="1.0"?>

<!-- ===================================================================== -->
<!--                                                                       -->
<!-- generateNames.xslt                                                    -->
<!--                                                                       -->
<!-- This XSLT stylesheet is a library of named templates, for use by      -->
<!-- the various harness-generating (and other) stylesheets of the SVG     -->
<!-- SVG test suite project. It should be included in those stylesheets    -->
<!-- using the xsl:include element.                                        -->
<!--                                                                       -->
<!-- Named Templates:                                                      -->
<!--                                                                       -->
<!--        GenerateNameThisTestCase                                       -->
<!--        GenerateNamePreviousTestCase                                   -->
<!--        GenerateNameNextTestCase                                       -->
<!--        GenerateNameParentTestCase                                     -->
<!--        GenerateNameChildTestCase                                      -->
<!--        GenerateNameThisTestCase                                       -->
<!--                                                                       -->
<!-- Author : Lofton Henderson, 22-dec-2000.                               -->
<!--                                                                       -->
<!-- History:                                                              -->
<!--  22-dec-2000 - LH: created, by factoring the templates out of the     -->
<!--                various "CreateXXXHarness.xslt" stylesheets.           -->
<!--                                                                       -->
<!-- ===================================================================== -->

<xsl:stylesheet version="1.0" 
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- ********** GenerateNameThisTestCase ************** -->
<xsl:template name="GenerateNameThisTestCase">
  <xsl:value-of select="@chapter"/>
  <xsl:text>-</xsl:text>
  <xsl:value-of select="@focus"/>
  <xsl:text>-</xsl:text>
  <xsl:value-of select="@testType"/>
  <xsl:text>-</xsl:text>
  <xsl:if test="@testType='BE'">
    <xsl:value-of select="@BENumber"/>
  </xsl:if>
  <xsl:if test="@testType='DT'">
    <xsl:value-of select="@DTNumber"/>
  </xsl:if>
</xsl:template>

<!-- ********** GenerateNamePreviousTestCase ************** -->
<xsl:template name="GenerateNamePreviousTestCase">
  <xsl:choose>
    <xsl:when test="Previous/@chapter"><xsl:value-of select="Previous/@chapter"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@chapter"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <xsl:choose>
    <xsl:when test="Previous/@focus"><xsl:value-of select="Previous/@focus"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@focus"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <xsl:choose>
    <xsl:when test="Previous/@testType"><xsl:value-of select="Previous/@testType"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@testType"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <!-- Add BE number or DT number -->
  <xsl:if test="@testType='BE'">
    <xsl:choose>
      <xsl:when test="Previous/@BENumber"><xsl:value-of select="Previous/@BENumber"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@BENumber"/></xsl:otherwise>
    </xsl:choose>
  </xsl:if>
  <xsl:if test="@testType='DT'">
    <xsl:choose>
      <xsl:when test="Previous/@DTNumber"><xsl:value-of select="Previous/@DTNumber"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@DTNumber"/></xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>


<!-- ********** GenerateNameNextTestCase ************** -->
<xsl:template name="GenerateNameNextTestCase">
  <xsl:choose>
    <xsl:when test="Next/@chapter"><xsl:value-of select="Next/@chapter"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@chapter"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <xsl:choose>
    <xsl:when test="Next/@focus"><xsl:value-of select="Next/@focus"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@focus"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <xsl:choose>
    <xsl:when test="Next/@testType"><xsl:value-of select="Next/@testType"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@testType"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <!-- Add BE number or DT number -->
  <xsl:if test="@testType='BE'">
    <xsl:choose>
      <xsl:when test="Next/@BENumber"><xsl:value-of select="Next/@BENumber"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@BENumber"/></xsl:otherwise>
    </xsl:choose>
  </xsl:if>
  <xsl:if test="@testType='DT'">
    <xsl:choose>
      <xsl:when test="Next/@DTNumber"><xsl:value-of select="Next/@DTNumber"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@DTNumber"/></xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>



<!-- ********** GenerateNameParentTestCase ************** -->
<xsl:template name="GenerateNameParentTestCase">
  <xsl:choose>
    <xsl:when test="Parent/@chapter"><xsl:value-of select="Parent/@chapter"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@chapter"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <xsl:choose>
    <xsl:when test="Parent/@focus"><xsl:value-of select="Parent/@focus"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@focus"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <xsl:choose>
    <xsl:when test="Parent/@testType"><xsl:value-of select="Parent/@testType"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@testType"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <!-- Add BE number or DT number -->
  <xsl:if test="@testType='BE'">
    <xsl:choose>
      <xsl:when test="Parent/@BENumber"><xsl:value-of select="Parent/@BENumber"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@BENumber"/></xsl:otherwise>
    </xsl:choose>
  </xsl:if>
  <xsl:if test="@testType='DT'">
    <xsl:choose>
      <xsl:when test="Parent/@DTNumber"><xsl:value-of select="Parent/@DTNumber"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@DTNumber"/></xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>


<!-- ********** GenerateNameChildTestCase ************** -->
<xsl:template name="GenerateNameChildTestCase">
  <xsl:choose>
    <xsl:when test="Child/@chapter"><xsl:value-of select="Child/@chapter"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@chapter"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <xsl:choose>
    <xsl:when test="Child/@focus"><xsl:value-of select="Child/@focus"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@focus"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <xsl:choose>
    <xsl:when test="Child/@testType"><xsl:value-of select="Child/@testType"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@testType"/></xsl:otherwise>
  </xsl:choose>
  <xsl:text>-</xsl:text>
  <!-- Add BE number or DT number -->
  <xsl:if test="@testType='BE'">
    <xsl:choose>
      <xsl:when test="Child/@BENumber"><xsl:value-of select="Child/@BENumber"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@BENumber"/></xsl:otherwise>
    </xsl:choose>
  </xsl:if>
  <xsl:if test="@testType='DT'">
    <xsl:choose>
      <xsl:when test="Child/@DTNumber"><xsl:value-of select="Child/@DTNumber"/></xsl:when>
      <xsl:otherwise><xsl:value-of select="@DTNumber"/></xsl:otherwise>
    </xsl:choose>
  </xsl:if>

</xsl:template>



</xsl:stylesheet>

