<?xml version="1.0"?>

<!-- ===================================================================== -->
<!--                                                                       -->
<!-- CreateSVGHarness.xslt                                                 -->
<!--                                                                       -->
<!-- This is an XSLT stylesheet for generating the all-SVG harness, from   -->
<!-- the XML test case description written according to the test case DTD. -->
<!--                                                                       -->
<!-- This version generates SVG files with navigation buttons (text and    -->
<!-- 'a' elements), and 'image' elements to reference the actual SVG       -->
<!-- test case file.                                                       -->
<!--                                                                       -->
<!-- Other stylesheets referenced and included                             --> 
<!-- (must be in same directory):                                          -->
<!--                                                                       -->
<!--       generateNames.xslt                                              -->
<!--       navigationBar-svg.xslt                                          -->
<!--                                                                       -->
<!-- Caveat.  The XT processor does not correctly implement the attribute  -->
<!--                     exclude-result-prefixes="xlink"                   -->
<!-- on the xsl:stylesheet element, and an unwanted xmlns:xlink            -->
<!-- declaration appears on the 'image' element.  Xalan is correct here.   -->
<!--                                                                       -->
<!--                                                                       -->
<!-- Author : Lofton Henderson, 12-apr-2000                                -->
<!--                                                                       -->
<!-- History:                                                              -->
<!--  12-Apr-2000 - LH: created.                                           -->
<!--  18-May-2000 - LH:                                                    -->
<!--                remove 'transform' attribute;                          -->
<!--                fix typo (missing "<") in named template (GNTTC);      -->
<!--                fix named templates, either BEnbr or DTnbr, not both;  -->
<!--                disable parent, child links (make point to self).      -->
<!--  22-May-2000 - LH: add "xsl:output doctype-..." element.              -->
<!--  04-Aug-2000 - LH: updated 'doctype' for CR version of DTD.           -->
<!--  21-Jan-2001 - LH: substantial rewrite for clarity, maintainability:  -->
<!--                ** factor GenerateXXXTestCaseName named templates to   -->
<!--                   external file, and "xsl:include ..." it.            -->
<!--                ** factor NavigationBar named template to external     -->
<!--                   file navigationBar-svg.xslt (there is a "-html"     -->
<!--                   version, for all-SVG harness set).                  -->
<!--                ** eliminate xsl:text usage, using attribute-value     -->
<!--                   templates instead.                                  -->
<!--                ** use xsl:variable for relative test case names       -->
<!--                ** exclude-result-prefixes to get rid of extraneous    -->
<!--                   xmlns:xlink declaration in result tree.             -->
<!--                                                                       -->
<!-- ===================================================================== -->

<xsl:stylesheet version="1.0" 
xmlns:xlink="http://www.w3.org/1999/xlink" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
exclude-result-prefixes="xlink">

<xsl:output method="xml" 
indent="yes"
omit-xml-declaration="no" 
standalone="no"/>

<xsl:output 
  doctype-system="http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtd"
  doctype-public="-//W3C//DTD SVG 20001102//EN" />

<xsl:template match="SVGTestCase">

<!-- Set up test cases name variables for repeatedly reused names, 
     and for cleaner use in attribute value templates -->
<xsl:variable name="thisCaseName"><xsl:call-template name="GenerateNameThisTestCase"/></xsl:variable>
<xsl:variable name="nextCaseName"><xsl:call-template name="GenerateNameNextTestCase"/></xsl:variable>
<xsl:variable name="previousCaseName"><xsl:call-template name="GenerateNamePreviousTestCase"/></xsl:variable>
<xsl:variable name="parentCaseName"><xsl:call-template name="GenerateNameParentTestCase"/></xsl:variable>
<xsl:variable name="childCaseName"><xsl:call-template name="GenerateNameChildTestCase"/></xsl:variable>

<svg width="460" height="570">


<!-- 'image' element to reference conventional SVG test case file. -->
<image x="10" y="10" width="450" height="450" xlink:href="{$thisCaseName}.svg" />

<text style="font-family:Verdana; font-size:12" x="72" y="480">
<xsl:value-of select="$thisCaseName"/>
</text>

<!-- Generate the navigation bar -->
<xsl:call-template name="NavigationBar"/>

</svg>

</xsl:template>

<!-- Include the utility templates for name and navbar generation -->
<xsl:include href="generateNames.xslt" />
<xsl:include href="navigationBar-svg.xslt" />


<!-- ********** DEFAULT ACTION: COPY ENTIRE CONTENTS ************** -->
<!-- (Relying on normal default template rules.) -->

</xsl:stylesheet>

