<?xml version="1.0"?>

<!-- ===================================================================== -->
<!--                                                                       -->
<!-- harness-ps-create-frameset.xslt                                       -->
<!--                                                                       -->
<!-- This XSLT stylesheet generates the frameset portion of the SVG-PNG    -->
<!-- side-by-side HTML harness, from                                       -->
<!-- the XML test case description written according to the test case DTD. -->
<!--                                                                       -->
<!-- Other stylesheet(s) referenced and included                           --> 
<!-- (must be in same directory):                                          -->
<!--                                                                       -->
<!--       generateNames.xslt                                              -->
<!--                                                                       -->
<!--                                                                       -->
<!-- Author : Jon Ferraiolo 23-may-2000, based on prior work from          -->
<!--                          Lofton Henderson, 2-mar-2000 and             -->
<!--                          Jon Ferraiolo,  12-Jan-2000                  -->
<!--                                                                       -->
<!-- History:                                                              -->
<!--  23-May-2000 - LH/JF: created.                                        -->
<!--   2-Mar-2000 - LH/JF: created.                                        -->
<!--  10-Apr-2000 - LH: fix toc link.                                      -->
<!--  18-May-2000 - LH:                                                    -->
<!--                disable top nav. bar and name (leave lower ones);      -->
<!--                fix typo (missing "<") in named template (GNTTC);      -->
<!--                fix named templates, either BEnbr or DTnbr, not both;  -->
<!--                disable parent, child links (make point to self).      -->
<!--  21-Jan-2001 - LH: substantial rewrite for clarity, maintainability:  -->
<!--                ** factor GenerateXXXTestCaseName named templates to   -->
<!--                   external file, and "xsl:include ..." it.            -->
<!--                ** eliminate xsl:text usage, using attribute-value     -->
<!--                   templates instead.                                  -->
<!--                ** use xsl:variable for relative test case names       -->
<!--                ** replace xsl:text in 'style' element by xsl:comment  -->
<!--                ** exclude-result-prefixes to get rid of extraneous    -->
<!--                   xmlns:xlink declaration in result tree.             -->
<!--  22-Jan-2001 - LH: remove unneeded include of navigationBar-html.xslt -->
<!--                                                                       -->
<!--                                                                       -->
<!-- ===================================================================== -->

<xsl:stylesheet version="1.0" 
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="html" indent="yes"/>
<xsl:output doctype-system="http://www.w3.org/TR/REC-html40/loose.dtd" 
            doctype-public="-//W3C//DTD HTML 4.0 Transitional//EN" />

<!-- Shouldn't be necessary w/ HTML, but xalan generates xml-decl otherwise -->
<xsl:output omit-xml-declaration="yes"/>

<!-- ********** SVGTestCase ************** -->
<xsl:template match="SVGTestCase">

<!-- Set up test cases name variables for repeatedly reused names, 
     and for cleaner use in attribute value templates -->
<xsl:variable name="thisCaseName"><xsl:call-template name="GenerateNameThisTestCase"/></xsl:variable>
<xsl:variable name="nextCaseName"><xsl:call-template name="GenerateNameNextTestCase"/></xsl:variable>
<xsl:variable name="previousCaseName"><xsl:call-template name="GenerateNamePreviousTestCase"/></xsl:variable>
<xsl:variable name="parentCaseName"><xsl:call-template name="GenerateNameParentTestCase"/></xsl:variable>
<xsl:variable name="childCaseName"><xsl:call-template name="GenerateNameChildTestCase"/></xsl:variable>

<html>
<head>
  <meta http-equiv="Content-Language" content="en-us" />
  <meta http-equiv="Content-Type" content="text/html; charset=windows-1252" />
  <title><xsl:value-of select="$thisCaseName"/></title>
  
  <!-- HTML 'link' elements for the navigation-bar links -->
  <xsl:if test="Previous">
    <link rel="prev" href="{$previousCaseName}.html" />
  </xsl:if>

  <xsl:if test="Next">
    <link rel="prev" href="{$nextCaseName}.html" />
  </xsl:if>

  <xsl:if test="Parent">
    <link rel="prev" href="{$parentCaseName}.html" />
  </xsl:if>

  <xsl:if test="Child">
    <link rel="prev" href="{$childCaseName}.html" />
  </xsl:if>

  <link rel="contents" href="toc.html" />

</head>

<frameset rows="65,450,*">
  <frame frameborder="0" marginwidth="0" marginheight="0" scrolling="auto" src="{$thisCaseName}-ps-top.html" />

  <frameset cols="450,450">
    <frame frameborder="0" marginwidth="0" marginheight="0" noresize="1" scrolling="no" src="{$thisCaseName}.png" />
     <frame frameborder="0" marginwidth="0" marginheight="0" noresize="1" scrolling="no" src="{$thisCaseName}.svg" />
  </frameset>
  <frame frameborder="0" marginwidth="0" marginheight="0" scrolling="auto" src="{$thisCaseName}-ps-bottom.html" />
</frameset>
<noframes>
  <body bgcolor="white">
  </body>
</noframes>
</html>

</xsl:template>

<!-- Include the utility templates for name generation -->
<xsl:include href="generateNames.xslt" />


<!-- ********** DEFAULT ACTION: COPY ENTIRE CONTENTS ************** -->
<!-- (Relying on normal default template rules.) -->

</xsl:stylesheet>

