
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 
    The "removeAttributeNode(oldAttr)" method raises a
   NOT_FOUND_ERR DOMException if the "oldAttr" attribute
   is not an attribute of the element.
    
   Retrieve the last employee and attempt to remove
   a non existing attribute node.  This should cause the
   intended exception to be raised.  This test makes use
   of the "createAttribute(name)" method from the Document 
   interface.

* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='INUSE_ATTRIBUTE_ERR'])</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D589198">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D589198</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-D589198')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-D589198')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='INUSE_ATTRIBUTE_ERR'])</a>
*/
public class elementnotfounderr extends DOMTestCase {

   public elementnotfounderr(DOMTestDocumentBuilderFactory factory) 
 {
      super(factory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc;
      Attr oldAttribute;
      NodeList addressElementList;
      Element testAddress;
      Attr attrAddress;
      doc = load("staff");
      addressElementList = doc.getElementsByTagName("address");
      testAddress = (Element)addressElementList.item(4);
      oldAttribute = doc.createAttribute("oldAttribute");
      
	{
		boolean success = false;
		try {
			attrAddress = testAddress.removeAttributeNode(oldAttribute);
      
		}
		catch(DOMException ex) {
			success = (ex.code == DOMException.NOT_FOUND_ERR);
		}
		assertTrue("elementNotFoundErrAssert",success);
	}

   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/elementnotfounderr";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(elementnotfounderr.class,args);
   }
}
