
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 
    The "removeChild(oldChild)" method removes the node
    indicated by "oldChild". 
    
    Retrieve the second employee and remove its first child.
    After the removal, the second employee should have twelve 
    children and the first child should now be the child
    that used to be at the second position in the list.

* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-1734834066</a>
*/
public class noderemovechildnode extends DOMTestCase {

   public noderemovechildnode(DOMTestDocumentBuilderFactory factory) 
 {
      super(factory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc;
      NodeList elementList;
      Node employeeNode;
      NodeList childList;
      Node oldChild;
      Node child;
      String childName;
      int length;
      Node removedChild;
      String removedName;
      doc = load("staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.getChildNodes();
      oldChild = childList.item(0);
      removedChild = employeeNode.removeChild(oldChild);
      removedName = removedChild.getNodeName();
      child = childList.item(0);
      childName = child.getNodeName();
      length = (int)childList.getLength();
      
	if(
	isIgnoringElementContentWhitespace()
	) {
	assertEquals("removedNameNoWhitespace","employeeId",removedName);
      assertEquals("childNameNoWhitespace","name",childName);
      assertEquals("lengthNoWhitespace",5,length);
      
	}
	
		else {
			assertEquals("removedName","#text",removedName);
      assertEquals("childName","employeeId",childName);
      assertEquals("length",12,length);
      
		}
	
   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/noderemovechildnode";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(noderemovechildnode.class,args);
   }
}
