
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 
    The "appendChild(newChild)" method raises a 
    WRONG_DOCUMENT_ERR DOMException if the "newChild" was
    created from a different document than the one that 
    created this node.
    
    Retrieve the second employee and attempt to append    
    a node created from a different document.   An attempt 
    to make such a replacement should raise the desired 
    exception.

* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NOT_FOUND_ERR'])</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-184E7107')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-184E7107')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NOT_FOUND_ERR'])</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-184E7107</a>
*/
public class nodeappendchildnewchilddiffdocument extends DOMTestCase {

   public nodeappendchildnewchilddiffdocument(DOMTestDocumentBuilderFactory factory) 
 {
      super(factory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc1;
      Document doc2;
      Node newChild;
      NodeList elementList;
      Node elementNode;
      Node appendedChild;
      doc1 = load("staff");
      doc2 = load("staff");
      newChild = doc1.createElement("newChild");
      elementList = doc2.getElementsByTagName("employee");
      elementNode = elementList.item(1);
      
	{
		boolean success = false;
		try {
			appendedChild = elementNode.appendChild(newChild);
      
		}
		catch(DOMException ex) {
			success = (ex.code == DOMException.WRONG_DOCUMENT_ERR);
		}
		assertTrue("nodeAppendChildNewChildDiffDocumentAssert1",success);
	}

   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/nodeappendchildnewchilddiffdocument";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(nodeappendchildnewchilddiffdocument.class,args);
   }
}
