
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 
    The "getPublicId()" method of an Entity node contains
   the public identifier associated with the entity, if
   one was specified.
   
   Retrieve the entity named "ent5" and access its  
   public identifier.  The string "entityURI" should be
   returned.

* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D7303025">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D7303025</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6ABAEB38">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-6ABAEB38</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D7C29F3E">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-D7C29F3E</a>
*/
public class entitygetpublicid extends DOMTestCase {

   public entitygetpublicid(DOMTestDocumentBuilderFactory factory) 
 {
      super(factory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc;
      DocumentType docType;
      NamedNodeMap entityList;
      Entity entityNode;
      String publicId;
      String systemId;
      String notation;
      doc = load("staff");
      docType = doc.getDoctype();
      entityList = docType.getEntities();
      entityNode = (Entity)entityList.getNamedItem("ent5");
      publicId = entityNode.getPublicId();
      assertEquals("publicId","entityURI",publicId);
      systemId = entityNode.getSystemId();
      assertURIEquals("systemId",null,null,null,"entityFile",null,null,null,systemId);
notation = entityNode.getNotationName();
      assertEquals("notation","notation1",notation);
      
   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/entitygetpublicid";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(entitygetpublicid.class,args);
   }
}
