
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 

    The "setAttributeNode(newAttr)" method raises an 

   "WRONG_DOCUMENT_ERR DOMException if the "newAttr" 

   was created from a different document than the one that

   created this document.

   

   Retrieve the last employee and attempt to set a new

   attribute node for its "employee" element.  The new

   attribute was created from a document other than the

   one that created this element, therefore a

   WRONG_DOCUMENT_ERR DOMException should be raised.

   This test uses the "createAttribute(newAttr)" method

   from the Document interface.


* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='WRONG_DOCUMENT_ERR'])</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-887236154</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-887236154')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-887236154')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='WRONG_DOCUMENT_ERR'])</a>
*/
public class elementwrongdocumenterr extends DOMTestCase {

   public elementwrongdocumenterr(DOMTestDocumentBuilderFactory factory) 
 {
      super(factory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc1;
      Document doc2;
      Attr newAttribute;
      NodeList addressElementList;
      Element testAddress;
      Attr attrAddress;
      doc1 = load("staff");
      doc2 = load("staff");
      newAttribute = doc2.createAttribute("newAttribute");
      addressElementList = doc1.getElementsByTagName("address");
      testAddress = (Element)addressElementList.item(4);
      
	{
		boolean success = false;
		try {
			attrAddress = testAddress.setAttributeNode(newAttribute);
      
		}
		catch(DOMException ex) {
			success = (ex.code == DOMException.WRONG_DOCUMENT_ERR);
		}
		assertTrue("elementWrongDocumentErrAssert",success);
	}

   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/elementwrongdocumenterr";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(elementwrongdocumenterr.class,args);
   }
}
