
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 
    The "replaceChild(newChild,oldChild)" method causes the 
    DOMException NO_MODIFICATION_ALLOWED_ERR to be raised
    if the node is readonly.
    
    Create an entity reference execute the "replaceChild(newChild,oldChild)" method.
    This causes a NO_MODIFICATION_ALLOWED_ERR DOMException to be thrown.

* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-258A00AF')/constant[@name='NO_MODIFICATION_ALLOWED_ERR'])</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-785887307')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#xpointer(id('ID-785887307')/raises/exception[@name='DOMException']/descr/p[substring-before(.,':')='NO_MODIFICATION_ALLOWED_ERR'])</a>
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-785887307</a>
* @see <a href="http://www.w3.org/2001/DOM-Test-Suite/level1/core/nodereplacechildnomodificationallowederr.xml">http://www.w3.org/2001/DOM-Test-Suite/level1/core/nodereplacechildnomodificationallowederr.xml</a>
*/
public class nodereplacechildnomodificationallowederrEE extends DOMTestCase {

   public nodereplacechildnomodificationallowederrEE(DOMTestDocumentBuilderFactory factory) 
 {
      super(factory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc;
      Node entRef;
      Node entText;
      Node createdNode;
      Node replacedChild;
      doc = load("staff");
      entRef = doc.createEntityReference("ent3");
      entText = entRef.getFirstChild();
      createdNode = doc.createElement("newChild");
      
	{
		boolean success = false;
		try {
			replacedChild = entRef.replaceChild(createdNode,entText);
      
		}
		catch(DOMException ex) {
			success = (ex.code == DOMException.NO_MODIFICATION_ALLOWED_ERR);
		}
		assertTrue("throw_NO_MODIFICATION_ALLOWED_ERR",success);
	}

   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/nodereplacechildnomodificationallowederrEE";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(nodereplacechildnomodificationallowederrEE.class,args);
   }
}
