
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:


Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University). All
Rights Reserved. This program is distributed under the W3C's Software
Intellectual Property License. This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.
See W3C License http://www.w3.org/Consortium/Legal/ for more details.

*/

package org.w3c.domts.level1.core;

import org.w3c.dom.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.domts.*;
import javax.xml.parsers.*;
import java.util.*;



/**
* 
    The "insertBefore(newChild,refChild)" method inserts the
    node "newChild" before the node "refChild". 
    
    Insert a newly created Element node before the eigth
    child of the second employee and check the "newChild"
    and "refChild" after insertion for correct placement.

* @author NIST
* @author Mary Brady
* @see <a href="http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727">http://www.w3.org/TR/1998/REC-DOM-Level-1-19981001/level-one-core#ID-952280727</a>
*/
public class nodeinsertbefore extends DOMTestCase {

   public nodeinsertbefore(DOMTestDocumentBuilderFactory factory) 
 {
      super(factory);

   }

   public void runTest() throws java.lang.Throwable {
      Document doc;
      NodeList elementList;
      Node employeeNode;
      NodeList childList;
      Node refChild;
      Node newChild;
      Node child;
      String childName;
      Node insertedNode;
      List actual = new ArrayList();
      
      List expectedWithWhitespace = new ArrayList();
      expectedWithWhitespace.add("#text");
      expectedWithWhitespace.add("employeeId");
      expectedWithWhitespace.add("#text");
      expectedWithWhitespace.add("name");
      expectedWithWhitespace.add("#text");
      expectedWithWhitespace.add("position");
      expectedWithWhitespace.add("#text");
      expectedWithWhitespace.add("newChild");
      expectedWithWhitespace.add("salary");
      expectedWithWhitespace.add("#text");
      expectedWithWhitespace.add("gender");
      expectedWithWhitespace.add("#text");
      expectedWithWhitespace.add("address");
      expectedWithWhitespace.add("#text");
      
      List expectedWithoutWhitespace = new ArrayList();
      expectedWithoutWhitespace.add("employeeId");
      expectedWithoutWhitespace.add("name");
      expectedWithoutWhitespace.add("position");
      expectedWithoutWhitespace.add("newChild");
      expectedWithoutWhitespace.add("salary");
      expectedWithoutWhitespace.add("gender");
      expectedWithoutWhitespace.add("address");
      
      List expected = new ArrayList();
      
      doc = load("staff");
      elementList = doc.getElementsByTagName("employee");
      employeeNode = elementList.item(1);
      childList = employeeNode.getChildNodes();
      
	if(
	isIgnoringElementContentWhitespace()
	) {
	refChild = childList.item(3);
      expected =  expectedWithoutWhitespace;

	}
	
		else {
			refChild = childList.item(7);
      expected =  expectedWithWhitespace;

		}
	newChild = doc.createElement("newChild");
      insertedNode = employeeNode.insertBefore(newChild,refChild);
      for(int _index = 0; _index < childList.getLength();_index++) {
      child = ( Node ) childList.item(_index);
	   childName = child.getNodeName();
      actual.add(childName);
      
	}
      assertEquals("nodeNames",expected,actual);
      
   }
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level1/core/nodeinsertbefore";
   }
   public static void main(String[] args) {
        DOMTestCase.doMain(nodeinsertbefore.class,args);
   }
}
